/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools.testgen.reproducer;

import java.util.Objects;
import org.optaplanner.core.impl.score.director.drools.testgen.TestGenDroolsScoreDirector;
import org.optaplanner.core.impl.score.director.drools.testgen.TestGenKieSessionJournal;
import org.optaplanner.core.impl.score.director.drools.testgen.reproducer.TestGenOriginalProblemReproducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestGenDroolsExceptionReproducer
implements TestGenOriginalProblemReproducer {
    private static final Logger logger = LoggerFactory.getLogger(TestGenDroolsExceptionReproducer.class);
    private final RuntimeException originalException;
    private final TestGenDroolsScoreDirector<?> scoreDirector;

    public TestGenDroolsExceptionReproducer(RuntimeException originalException, TestGenDroolsScoreDirector<?> scoreDirector) {
        this.originalException = originalException;
        this.scoreDirector = scoreDirector;
    }

    @Override
    public boolean isReproducible(TestGenKieSessionJournal journal) {
        try {
            journal.replay(this.scoreDirector.createKieSession());
            return false;
        }
        catch (RuntimeException reproducedException) {
            if (TestGenDroolsExceptionReproducer.areEqual(this.originalException, reproducedException)) {
                return true;
            }
            if (reproducedException.getMessage().startsWith("No fact handle for ")) {
                logger.debug("    Can't remove insert: {}", (Object)reproducedException.toString());
            } else {
                logger.info("Unexpected exception", (Throwable)reproducedException);
            }
            return false;
        }
    }

    @Override
    public void assertReproducible(TestGenKieSessionJournal journal, String message) {
        try {
            journal.replay(this.scoreDirector.createKieSession());
            throw new IllegalStateException(message + " No exception thrown.");
        }
        catch (RuntimeException reproducedException) {
            if (!TestGenDroolsExceptionReproducer.areEqual(this.originalException, reproducedException)) {
                throw new IllegalStateException(message + "\nExpected [" + this.originalException + "]\nCaused [" + reproducedException + "]", reproducedException);
            }
            return;
        }
    }

    private static boolean areEqual(RuntimeException originalException, RuntimeException reproducedException) {
        if (!originalException.getClass().equals(reproducedException.getClass())) {
            return false;
        }
        if (!Objects.equals(originalException.getMessage(), reproducedException.getMessage())) {
            return false;
        }
        if (reproducedException.getStackTrace().length == 0) {
            throw new IllegalStateException("Caught exception with empty stack trace => can't compare to the original. Use '-XX:-OmitStackTraceInFastThrow' to turn off this optimization.", reproducedException);
        }
        return originalException.getStackTrace()[0].equals(reproducedException.getStackTrace()[0]);
    }

    public String toString() {
        return this.originalException.toString();
    }
}

