/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.stepscore;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.SubSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.common.MillisecondsSpentNumberFormat;
import org.optaplanner.benchmark.impl.statistic.stepscore.StepScoreStatisticPoint;
import org.optaplanner.benchmark.impl.statistic.stepscore.StepScoreSubSingleStatistic;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.score.ScoreUtils;

@XStreamAlias(value="stepScoreProblemStatistic")
public class StepScoreProblemStatistic
extends ProblemStatistic {
    protected List<File> graphFileList = null;

    public StepScoreProblemStatistic(ProblemBenchmarkResult problemBenchmarkResult) {
        super(problemBenchmarkResult, ProblemStatisticType.STEP_SCORE);
    }

    @Override
    public SubSingleStatistic createSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        return new StepScoreSubSingleStatistic(subSingleBenchmarkResult);
    }

    @Override
    public List<File> getGraphFileList() {
        return this.graphFileList;
    }

    @Override
    public void writeGraphFiles(BenchmarkReport benchmarkReport) {
        ArrayList<XYPlot> plotList = new ArrayList<XYPlot>(15);
        int seriesIndex = 0;
        for (SingleBenchmarkResult singleBenchmarkResult : this.problemBenchmarkResult.getSingleBenchmarkResultList()) {
            ArrayList<XYSeries> seriesList = new ArrayList<XYSeries>(15);
            XYStepRenderer renderer = new XYStepRenderer();
            if (singleBenchmarkResult.hasAllSuccess()) {
                StepScoreSubSingleStatistic subSingleStatistic = (StepScoreSubSingleStatistic)singleBenchmarkResult.getSubSingleStatistic(this.problemStatisticType);
                List points = subSingleStatistic.getPointList();
                for (StepScoreStatisticPoint point : points) {
                    long timeMillisSpent = point.getTimeMillisSpent();
                    double[] levelValues = ScoreUtils.extractLevelDoubles((Score)point.getScore());
                    for (int i = 0; i < levelValues.length && i < 15; ++i) {
                        if (i >= seriesList.size()) {
                            seriesList.add(new XYSeries((Comparable)((Object)singleBenchmarkResult.getSolverBenchmarkResult().getNameWithFavoriteSuffix())));
                        }
                        ((XYSeries)seriesList.get(i)).add((double)timeMillisSpent, levelValues[i]);
                    }
                }
                if (subSingleStatistic.getPointList().size() <= 1) {
                    renderer = new StandardXYItemRenderer(3);
                }
            }
            if (singleBenchmarkResult.getSolverBenchmarkResult().isFavorite()) {
                renderer.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
            }
            for (int i = 0; i < seriesList.size(); ++i) {
                if (i >= plotList.size()) {
                    plotList.add(this.createPlot(benchmarkReport, i));
                }
                ((XYPlot)plotList.get(i)).setDataset(seriesIndex, (XYDataset)new XYSeriesCollection((XYSeries)seriesList.get(i)));
                ((XYPlot)plotList.get(i)).setRenderer(seriesIndex, (XYItemRenderer)renderer);
            }
            ++seriesIndex;
        }
        this.graphFileList = new ArrayList<File>(plotList.size());
        for (int scoreLevelIndex = 0; scoreLevelIndex < plotList.size(); ++scoreLevelIndex) {
            String scoreLevelLabel = this.problemBenchmarkResult.findScoreLevelLabel(scoreLevelIndex);
            JFreeChart chart = new JFreeChart(this.problemBenchmarkResult.getName() + " step " + scoreLevelLabel + " statistic", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plotList.get(scoreLevelIndex), true);
            this.graphFileList.add(this.writeChartToImageFile(chart, this.problemBenchmarkResult.getName() + "StepScoreStatisticLevel" + scoreLevelIndex));
        }
    }

    private XYPlot createPlot(BenchmarkReport benchmarkReport, int scoreLevelIndex) {
        Locale locale = benchmarkReport.getLocale();
        NumberAxis xAxis = new NumberAxis("Time spent");
        xAxis.setNumberFormatOverride((NumberFormat)new MillisecondsSpentNumberFormat(locale));
        String scoreLevelLabel = this.problemBenchmarkResult.findScoreLevelLabel(scoreLevelIndex);
        NumberAxis yAxis = new NumberAxis("Step " + scoreLevelLabel);
        yAxis.setNumberFormatOverride(NumberFormat.getInstance(locale));
        yAxis.setAutoRangeIncludesZero(false);
        XYPlot plot = new XYPlot(null, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
        plot.setOrientation(PlotOrientation.VERTICAL);
        return plot;
    }
}

