/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class SubChainReversingChangeMove
extends AbstractMove {
    protected final SubChain subChain;
    protected final GenuineVariableDescriptor variableDescriptor;
    protected final SingletonInverseVariableSupply inverseVariableSupply;
    protected final Object toPlanningValue;

    public SubChainReversingChangeMove(SubChain subChain, GenuineVariableDescriptor variableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, Object toPlanningValue) {
        this.subChain = subChain;
        this.variableDescriptor = variableDescriptor;
        this.inverseVariableSupply = inverseVariableSupply;
        this.toPlanningValue = toPlanningValue;
    }

    public String getVariableName() {
        return this.variableDescriptor.getVariableName();
    }

    public SubChain getSubChain() {
        return this.subChain;
    }

    public Object getToPlanningValue() {
        return this.toPlanningValue;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        if (this.subChain.getEntityList().contains(this.toPlanningValue)) {
            return false;
        }
        Object oldFirstValue = this.variableDescriptor.getValue(this.subChain.getFirstEntity());
        return !Objects.equals(oldFirstValue, this.toPlanningValue);
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        Object oldFirstValue = this.variableDescriptor.getValue(this.subChain.getFirstEntity());
        return new SubChainReversingChangeMove(this.subChain.reverse(), this.variableDescriptor, this.inverseVariableSupply, oldFirstValue);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector scoreDirector) {
        boolean unmovedReverse;
        Object firstEntity = this.subChain.getFirstEntity();
        Object lastEntity = this.subChain.getLastEntity();
        Object oldFirstValue = this.variableDescriptor.getValue(firstEntity);
        Object oldTrailingLastEntity = this.inverseVariableSupply.getInverseSingleton(lastEntity);
        Object newTrailingEntity = this.toPlanningValue == null ? null : this.inverseVariableSupply.getInverseSingleton(this.toPlanningValue);
        boolean bl = unmovedReverse = newTrailingEntity == firstEntity;
        if (!unmovedReverse && oldTrailingLastEntity != null) {
            scoreDirector.changeVariableFacade(this.variableDescriptor, oldTrailingLastEntity, oldFirstValue);
        }
        Object lastEntityValue = this.variableDescriptor.getValue(lastEntity);
        scoreDirector.changeVariableFacade(this.variableDescriptor, lastEntity, this.toPlanningValue);
        this.reverseChain(scoreDirector, lastEntity, lastEntityValue, firstEntity);
        if (!unmovedReverse) {
            if (newTrailingEntity != null) {
                scoreDirector.changeVariableFacade(this.variableDescriptor, newTrailingEntity, firstEntity);
            }
        } else if (oldTrailingLastEntity != null) {
            scoreDirector.changeVariableFacade(this.variableDescriptor, oldTrailingLastEntity, firstEntity);
        }
    }

    private void reverseChain(ScoreDirector scoreDirector, Object entity, Object previous, Object toEntity) {
        while (entity != toEntity) {
            Object value = this.variableDescriptor.getValue(previous);
            scoreDirector.changeVariableFacade(this.variableDescriptor, previous, entity);
            entity = previous;
            previous = value;
        }
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return this.subChain.getEntityList();
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toPlanningValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SubChainReversingChangeMove) {
            SubChainReversingChangeMove other = (SubChainReversingChangeMove)o;
            return new EqualsBuilder().append((Object)this.subChain, (Object)other.subChain).append((Object)this.variableDescriptor.getVariableName(), (Object)other.variableDescriptor.getVariableName()).append(this.toPlanningValue, other.toPlanningValue).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.subChain).append((Object)this.variableDescriptor.getVariableName()).append(this.toPlanningValue).toHashCode();
    }

    public String toString() {
        Object oldFirstValue = this.variableDescriptor.getValue(this.subChain.getFirstEntity());
        return this.subChain.toDottedString() + " {" + oldFirstValue + " -reversing-> " + this.toPlanningValue + "}";
    }
}

