/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.optional.partitioner;

import java.util.ArrayList;
import java.util.List;
import org.optaplanner.core.impl.partitionedsearch.partitioner.SolutionPartitioner;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;

public class CloudBalancePartitioner
implements SolutionPartitioner<CloudBalance> {
    public List<CloudBalance> splitWorkingSolution(ScoreDirector<CloudBalance> scoreDirector) {
        CloudBalance part;
        CloudBalance originalSolution = (CloudBalance)scoreDirector.getWorkingSolution();
        int partCount = Math.max(4, originalSolution.getComputerList().size() / 100);
        ArrayList<CloudBalance> partList = new ArrayList<CloudBalance>(partCount);
        for (int i = 0; i < partCount; ++i) {
            CloudBalance partSolution = new CloudBalance(originalSolution.getId(), new ArrayList<CloudComputer>(originalSolution.getComputerList().size() / partCount + 1), new ArrayList<CloudProcess>(originalSolution.getProcessList().size() / partCount + 1));
            partList.add(partSolution);
        }
        int partIndex = 0;
        for (CloudComputer originalComputer : originalSolution.getComputerList()) {
            part = (CloudBalance)partList.get(partIndex);
            part.getComputerList().add(new CloudComputer(originalComputer.getId(), originalComputer.getCpuPower(), originalComputer.getMemory(), originalComputer.getNetworkBandwidth(), originalComputer.getCost()));
            partIndex = (partIndex + 1) % partList.size();
        }
        partIndex = 0;
        for (CloudProcess originalProcess : originalSolution.getProcessList()) {
            part = (CloudBalance)partList.get(partIndex);
            part.getProcessList().add(new CloudProcess(originalProcess.getId(), originalProcess.getRequiredCpuPower(), originalProcess.getRequiredMemory(), originalProcess.getRequiredNetworkBandwidth()));
            if (originalProcess.getComputer() != null) {
                throw new IllegalStateException("The initialized process (" + originalProcess + ") has a computer (" + originalProcess.getComputer() + ") which belongs to the another partition.");
            }
            partIndex = (partIndex + 1) % partList.size();
        }
        return partList;
    }
}

