/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.entity.descriptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.AnchorShadowVariable;
import org.optaplanner.core.api.domain.variable.CustomShadowVariable;
import org.optaplanner.core.api.domain.variable.InverseRelationShadowVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.anchor.AnchorShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.custom.CustomShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.InverseRelationShadowVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.WeightFactorySelectionSorter;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class EntityDescriptor<Solution_> {
    public static final Class[] VARIABLE_ANNOTATION_CLASSES = new Class[]{PlanningVariable.class, InverseRelationShadowVariable.class, AnchorShadowVariable.class, CustomShadowVariable.class};
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final Class<?> entityClass;
    private SelectionFilter movableEntitySelectionFilter;
    private SelectionSorter decreasingDifficultySorter;
    private List<EntityDescriptor<Solution_>> inheritedEntityDescriptorList;
    private Map<String, GenuineVariableDescriptor<Solution_>> declaredGenuineVariableDescriptorMap;
    private Map<String, ShadowVariableDescriptor<Solution_>> declaredShadowVariableDescriptorMap;
    private Map<String, GenuineVariableDescriptor<Solution_>> effectiveGenuineVariableDescriptorMap;
    private Map<String, ShadowVariableDescriptor<Solution_>> effectiveShadowVariableDescriptorMap;
    private Map<String, VariableDescriptor<Solution_>> effectiveVariableDescriptorMap;

    public EntityDescriptor(SolutionDescriptor<Solution_> solutionDescriptor, Class<?> entityClass) {
        this.solutionDescriptor = solutionDescriptor;
        this.entityClass = entityClass;
    }

    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
        this.processEntityAnnotations(descriptorPolicy);
        this.processValueRangeProviderAnnotations(descriptorPolicy);
        this.processPlanningVariableAnnotations(descriptorPolicy);
    }

    private void processEntityAnnotations(DescriptorPolicy descriptorPolicy) {
        PlanningEntity entityAnnotation = this.entityClass.getAnnotation(PlanningEntity.class);
        if (entityAnnotation == null) {
            throw new IllegalStateException("The entityClass (" + this.entityClass + ") has been specified as a planning entity in the configuration, but does not have a " + PlanningEntity.class.getSimpleName() + " annotation.");
        }
        this.processMovable(descriptorPolicy, entityAnnotation);
        this.processDifficulty(descriptorPolicy, entityAnnotation);
    }

    private void processMovable(DescriptorPolicy descriptorPolicy, PlanningEntity entityAnnotation) {
        Class<? extends SelectionFilter> movableEntitySelectionFilterClass = entityAnnotation.movableEntitySelectionFilter();
        if (movableEntitySelectionFilterClass == PlanningEntity.NullMovableEntitySelectionFilter.class) {
            movableEntitySelectionFilterClass = null;
        }
        if (movableEntitySelectionFilterClass != null) {
            this.movableEntitySelectionFilter = ConfigUtils.newInstance(this, "movableEntitySelectionFilterClass", movableEntitySelectionFilterClass);
        }
    }

    private void processDifficulty(DescriptorPolicy descriptorPolicy, PlanningEntity entityAnnotation) {
        Class<? extends SelectionSorterWeightFactory> difficultyWeightFactoryClass;
        Class<? extends Comparator> difficultyComparatorClass = entityAnnotation.difficultyComparatorClass();
        if (difficultyComparatorClass == PlanningEntity.NullDifficultyComparator.class) {
            difficultyComparatorClass = null;
        }
        if ((difficultyWeightFactoryClass = entityAnnotation.difficultyWeightFactoryClass()) == PlanningEntity.NullDifficultyWeightFactory.class) {
            difficultyWeightFactoryClass = null;
        }
        if (difficultyComparatorClass != null && difficultyWeightFactoryClass != null) {
            throw new IllegalStateException("The entityClass (" + this.entityClass + ") cannot have a difficultyComparatorClass (" + difficultyComparatorClass.getName() + ") and a difficultyWeightFactoryClass (" + difficultyWeightFactoryClass.getName() + ") at the same time.");
        }
        if (difficultyComparatorClass != null) {
            Comparator difficultyComparator = ConfigUtils.newInstance(this, "difficultyComparatorClass", difficultyComparatorClass);
            this.decreasingDifficultySorter = new ComparatorSelectionSorter(difficultyComparator, SelectionSorterOrder.DESCENDING);
        }
        if (difficultyWeightFactoryClass != null) {
            SelectionSorterWeightFactory difficultyWeightFactory = ConfigUtils.newInstance(this, "difficultyWeightFactoryClass", difficultyWeightFactoryClass);
            this.decreasingDifficultySorter = new WeightFactorySelectionSorter(difficultyWeightFactory, SelectionSorterOrder.DESCENDING);
        }
    }

    private void processValueRangeProviderAnnotations(DescriptorPolicy descriptorPolicy) {
        List<Member> memberList = ConfigUtils.getDeclaredMembers(this.entityClass);
        for (Member member : memberList) {
            if (!((AnnotatedElement)((Object)member)).isAnnotationPresent(ValueRangeProvider.class)) continue;
            MemberAccessor memberAccessor = ConfigUtils.buildMemberAccessor(member, ConfigUtils.MemberAccessorType.FIELD_OR_READ_METHOD, ValueRangeProvider.class);
            descriptorPolicy.addFromEntityValueRangeProvider(memberAccessor);
        }
    }

    private void processPlanningVariableAnnotations(DescriptorPolicy descriptorPolicy) {
        this.declaredGenuineVariableDescriptorMap = new LinkedHashMap<String, GenuineVariableDescriptor<Solution_>>();
        this.declaredShadowVariableDescriptorMap = new LinkedHashMap<String, ShadowVariableDescriptor<Solution_>>();
        boolean noVariableAnnotation = true;
        List<Member> memberList = ConfigUtils.getDeclaredMembers(this.entityClass);
        for (Member member : memberList) {
            Class<? extends Annotation> variableAnnotationClass = ConfigUtils.extractAnnotationClass(member, VARIABLE_ANNOTATION_CLASSES);
            if (variableAnnotationClass == null) continue;
            noVariableAnnotation = false;
            MemberAccessor memberAccessor = ConfigUtils.buildMemberAccessor(member, ConfigUtils.MemberAccessorType.FIELD_OR_GETTER_METHOD_WITH_SETTER, variableAnnotationClass);
            this.registerVariableAccessor(descriptorPolicy, variableAnnotationClass, memberAccessor);
        }
        if (noVariableAnnotation) {
            throw new IllegalStateException("The entityClass (" + this.entityClass + ") should have at least 1 getter method or 1 field with a " + PlanningVariable.class.getSimpleName() + " annotation or a shadow variable annotation.");
        }
    }

    private void registerVariableAccessor(DescriptorPolicy descriptorPolicy, Class<? extends Annotation> variableAnnotationClass, MemberAccessor memberAccessor) {
        String memberName = memberAccessor.getName();
        if (this.declaredGenuineVariableDescriptorMap.containsKey(memberName) || this.declaredShadowVariableDescriptorMap.containsKey(memberName)) {
            VariableDescriptor duplicate = this.declaredGenuineVariableDescriptorMap.get(memberName);
            if (duplicate == null) {
                duplicate = this.declaredShadowVariableDescriptorMap.get(memberName);
            }
            throw new IllegalStateException("The entityClass (" + this.entityClass + ") has a " + variableAnnotationClass.getSimpleName() + " annotated member (" + memberAccessor + ") that is duplicated by another member for variableDescriptor (" + duplicate + ").\n  Verify that the annotation is not defined on both the field and its getter.");
        }
        if (variableAnnotationClass.equals(PlanningVariable.class)) {
            GenuineVariableDescriptor variableDescriptor = new GenuineVariableDescriptor(this, memberAccessor);
            this.declaredGenuineVariableDescriptorMap.put(memberName, variableDescriptor);
            variableDescriptor.processAnnotations(descriptorPolicy);
        } else if (variableAnnotationClass.equals(InverseRelationShadowVariable.class)) {
            InverseRelationShadowVariableDescriptor variableDescriptor = new InverseRelationShadowVariableDescriptor(this, memberAccessor);
            this.declaredShadowVariableDescriptorMap.put(memberName, variableDescriptor);
            ((ShadowVariableDescriptor)variableDescriptor).processAnnotations(descriptorPolicy);
        } else if (variableAnnotationClass.equals(AnchorShadowVariable.class)) {
            AnchorShadowVariableDescriptor variableDescriptor = new AnchorShadowVariableDescriptor(this, memberAccessor);
            this.declaredShadowVariableDescriptorMap.put(memberName, variableDescriptor);
            ((ShadowVariableDescriptor)variableDescriptor).processAnnotations(descriptorPolicy);
        } else if (variableAnnotationClass.equals(CustomShadowVariable.class)) {
            CustomShadowVariableDescriptor variableDescriptor = new CustomShadowVariableDescriptor(this, memberAccessor);
            this.declaredShadowVariableDescriptorMap.put(memberName, variableDescriptor);
            ((ShadowVariableDescriptor)variableDescriptor).processAnnotations(descriptorPolicy);
        } else {
            throw new IllegalStateException("The variableAnnotationClass (" + variableAnnotationClass + ") is not implemented.");
        }
    }

    public void linkInheritedEntityDescriptors(DescriptorPolicy descriptorPolicy) {
        this.inheritedEntityDescriptorList = new ArrayList<EntityDescriptor<Solution_>>(4);
        this.investigateParentsToLinkInherited(this.entityClass);
        this.createEffectiveVariableDescriptorMaps();
    }

    private void investigateParentsToLinkInherited(Class<?> investigateClass) {
        if (investigateClass == null || investigateClass.isArray()) {
            return;
        }
        this.linkInherited(investigateClass.getSuperclass());
        for (Class<?> superInterface : investigateClass.getInterfaces()) {
            this.linkInherited(superInterface);
        }
    }

    private void linkInherited(Class<?> investigateClass) {
        EntityDescriptor<Solution_> superEntityDescriptor = this.solutionDescriptor.getEntityDescriptorStrict(investigateClass);
        if (superEntityDescriptor != null) {
            this.inheritedEntityDescriptorList.add(superEntityDescriptor);
        } else {
            this.investigateParentsToLinkInherited(investigateClass);
        }
    }

    public void linkShadowSources(DescriptorPolicy descriptorPolicy) {
        for (ShadowVariableDescriptor<Solution_> shadowVariableDescriptor : this.declaredShadowVariableDescriptorMap.values()) {
            shadowVariableDescriptor.linkShadowSources(descriptorPolicy);
        }
    }

    private void createEffectiveVariableDescriptorMaps() {
        this.effectiveGenuineVariableDescriptorMap = new LinkedHashMap<String, GenuineVariableDescriptor<Solution_>>(this.declaredGenuineVariableDescriptorMap.size());
        this.effectiveShadowVariableDescriptorMap = new LinkedHashMap<String, ShadowVariableDescriptor<Solution_>>(this.declaredShadowVariableDescriptorMap.size());
        for (EntityDescriptor<Solution_> inheritedEntityDescriptor : this.inheritedEntityDescriptorList) {
            this.effectiveGenuineVariableDescriptorMap.putAll(inheritedEntityDescriptor.getGenuineVariableDescriptorMap());
            this.effectiveShadowVariableDescriptorMap.putAll(inheritedEntityDescriptor.getShadowVariableDescriptorMap());
        }
        this.effectiveGenuineVariableDescriptorMap.putAll(this.declaredGenuineVariableDescriptorMap);
        this.effectiveShadowVariableDescriptorMap.putAll(this.declaredShadowVariableDescriptorMap);
        this.effectiveVariableDescriptorMap = new LinkedHashMap<String, VariableDescriptor<Solution_>>(this.effectiveGenuineVariableDescriptorMap.size() + this.effectiveShadowVariableDescriptorMap.size());
        this.effectiveVariableDescriptorMap.putAll(this.effectiveGenuineVariableDescriptorMap);
        this.effectiveVariableDescriptorMap.putAll(this.effectiveShadowVariableDescriptorMap);
    }

    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public boolean matchesEntity(Object entity) {
        return this.entityClass.isAssignableFrom(entity.getClass());
    }

    public boolean hasMovableEntitySelectionFilter() {
        return this.movableEntitySelectionFilter != null;
    }

    public SelectionFilter getMovableEntitySelectionFilter() {
        return this.movableEntitySelectionFilter;
    }

    public SelectionSorter getDecreasingDifficultySorter() {
        return this.decreasingDifficultySorter;
    }

    public boolean hasAnyDeclaredGenuineVariableDescriptor() {
        return !this.declaredGenuineVariableDescriptorMap.isEmpty();
    }

    public Collection<String> getGenuineVariableNameSet() {
        return this.effectiveGenuineVariableDescriptorMap.keySet();
    }

    public Map<String, GenuineVariableDescriptor<Solution_>> getGenuineVariableDescriptorMap() {
        return this.effectiveGenuineVariableDescriptorMap;
    }

    public Collection<GenuineVariableDescriptor<Solution_>> getGenuineVariableDescriptors() {
        return this.effectiveGenuineVariableDescriptorMap.values();
    }

    public List<GenuineVariableDescriptor<Solution_>> getGenuineVariableDescriptorList() {
        return new ArrayList<GenuineVariableDescriptor<Solution_>>(this.effectiveGenuineVariableDescriptorMap.values());
    }

    public boolean hasGenuineVariableDescriptor(String variableName) {
        return this.effectiveGenuineVariableDescriptorMap.containsKey(variableName);
    }

    public GenuineVariableDescriptor<Solution_> getGenuineVariableDescriptor(String variableName) {
        return this.effectiveGenuineVariableDescriptorMap.get(variableName);
    }

    public Map<String, ShadowVariableDescriptor<Solution_>> getShadowVariableDescriptorMap() {
        return this.effectiveShadowVariableDescriptorMap;
    }

    public Collection<ShadowVariableDescriptor<Solution_>> getShadowVariableDescriptors() {
        return this.effectiveShadowVariableDescriptorMap.values();
    }

    public boolean hasShadowVariableDescriptor(String variableName) {
        return this.effectiveShadowVariableDescriptorMap.containsKey(variableName);
    }

    public ShadowVariableDescriptor<Solution_> getShadowVariableDescriptor(String variableName) {
        return this.effectiveShadowVariableDescriptorMap.get(variableName);
    }

    public Map<String, VariableDescriptor<Solution_>> getVariableDescriptorMap() {
        return this.effectiveVariableDescriptorMap;
    }

    public Collection<VariableDescriptor<Solution_>> getVariableDescriptors() {
        return this.effectiveVariableDescriptorMap.values();
    }

    public boolean hasVariableDescriptor(String variableName) {
        return this.effectiveVariableDescriptorMap.containsKey(variableName);
    }

    public VariableDescriptor<Solution_> getVariableDescriptor(String variableName) {
        return this.effectiveVariableDescriptorMap.get(variableName);
    }

    public Collection<GenuineVariableDescriptor<Solution_>> getDeclaredGenuineVariableDescriptors() {
        return this.declaredGenuineVariableDescriptorMap.values();
    }

    public Collection<ShadowVariableDescriptor<Solution_>> getDeclaredShadowVariableDescriptors() {
        return this.declaredShadowVariableDescriptorMap.values();
    }

    public Collection<VariableDescriptor<Solution_>> getDeclaredVariableDescriptors() {
        ArrayList<VariableDescriptor<Solution_>> variableDescriptors = new ArrayList<VariableDescriptor<Solution_>>(this.declaredGenuineVariableDescriptorMap.size() + this.declaredShadowVariableDescriptorMap.size());
        variableDescriptors.addAll(this.declaredGenuineVariableDescriptorMap.values());
        variableDescriptors.addAll(this.declaredShadowVariableDescriptorMap.values());
        return variableDescriptors;
    }

    public String buildInvalidVariableNameExceptionMessage(String variableName) {
        if (!ReflectionHelper.hasGetterMethod(this.entityClass, variableName)) {
            String exceptionMessage = "The variableName (" + variableName + ") for entityClass (" + this.entityClass + ") does not exists as a property (getter/setter) on that class.\nCheck the spelling of the variableName (" + variableName + ").";
            if (variableName.length() >= 2 && !Character.isUpperCase(variableName.charAt(0)) && Character.isUpperCase(variableName.charAt(1))) {
                String correctedVariableName = variableName.substring(0, 1).toUpperCase() + variableName.substring(1);
                exceptionMessage = exceptionMessage + " It probably needs to be correctedVariableName (" + correctedVariableName + ") instead because the JavaBeans spec states the first letter should be a upper case if the second is upper case.";
            }
            return exceptionMessage;
        }
        return "The variableName (" + variableName + ") for entityClass (" + this.entityClass + ") exists as a property (getter/setter) on that class, but not as an annotated as a planning variable.\nCheck if your planning entity's getter has the annotation " + PlanningVariable.class.getSimpleName() + " (or a shadow variable annotation).";
    }

    public boolean hasAnyChainedGenuineVariables() {
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.effectiveGenuineVariableDescriptorMap.values()) {
            if (variableDescriptor.isChained()) continue;
            return true;
        }
        return false;
    }

    public List<Object> extractEntities(Solution_ solution) {
        return this.solutionDescriptor.getEntityListByEntityClass(solution, this.entityClass);
    }

    public long getGenuineVariableCount() {
        return this.effectiveGenuineVariableDescriptorMap.size();
    }

    public long getMaximumValueCount(Solution_ solution, Object entity) {
        long maximumValueCount = 0L;
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.effectiveGenuineVariableDescriptorMap.values()) {
            maximumValueCount = Math.max(maximumValueCount, variableDescriptor.getValueCount(solution, entity));
        }
        return maximumValueCount;
    }

    public long getProblemScale(Solution_ solution, Object entity) {
        long problemScale = 1L;
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.effectiveGenuineVariableDescriptorMap.values()) {
            problemScale *= variableDescriptor.getValueCount(solution, entity);
        }
        return problemScale;
    }

    public int countUninitializedVariables(Object entity) {
        int count = 0;
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.effectiveGenuineVariableDescriptorMap.values()) {
            if (variableDescriptor.isInitialized(entity)) continue;
            ++count;
        }
        return count;
    }

    public boolean isInitialized(Object entity) {
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.effectiveGenuineVariableDescriptorMap.values()) {
            if (variableDescriptor.isInitialized(entity)) continue;
            return false;
        }
        return true;
    }

    public int countReinitializableVariables(ScoreDirector<Solution_> scoreDirector, Object entity) {
        int count = 0;
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.effectiveGenuineVariableDescriptorMap.values()) {
            if (!variableDescriptor.isReinitializable(scoreDirector, entity)) continue;
            ++count;
        }
        return count;
    }

    public boolean isMovable(ScoreDirector<Solution_> scoreDirector, Object entity) {
        return this.movableEntitySelectionFilter == null || this.movableEntitySelectionFilter.accept(scoreDirector, entity);
    }

    public boolean isEntityInitializedOrImmovable(ScoreDirector<Solution_> scoreDirector, Object entity) {
        return this.isInitialized(entity) || !this.isMovable(scoreDirector, entity);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entityClass.getName() + ")";
    }
}

