/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.drools.core.base.accumulators.AbstractAccumulateFunction;

public class IntegerSumAccumulateFunction
extends AbstractAccumulateFunction {
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public Serializable createContext() {
        return new SumData();
    }

    public void init(Serializable context) {
        ((SumData)context).total = 0;
    }

    public void accumulate(Serializable context, Object value) {
        if (value != null) {
            ((SumData)context).total += ((Integer)value).intValue();
        }
    }

    public void reverse(Serializable context, Object value) {
        if (value != null) {
            ((SumData)context).total -= ((Integer)value).intValue();
        }
    }

    public Object getResult(Serializable context) {
        return ((SumData)context).total;
    }

    public boolean supportsReverse() {
        return true;
    }

    public Class<?> getResultType() {
        return Integer.class;
    }

    protected static class SumData
    implements Externalizable {
        public int total = 0;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.total = in.readInt();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.total);
        }
    }
}

