/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardmediumsoftbigdecimal;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.optaplanner.core.api.score.AbstractScore;
import org.optaplanner.core.api.score.FeasibilityScore;
import org.optaplanner.core.api.score.Score;

public final class HardMediumSoftBigDecimalScore
extends AbstractScore<HardMediumSoftBigDecimalScore>
implements FeasibilityScore<HardMediumSoftBigDecimalScore> {
    private static final String HARD_LABEL = "hard";
    private static final String MEDIUM_LABEL = "medium";
    private static final String SOFT_LABEL = "soft";
    private final BigDecimal hardScore;
    private final BigDecimal mediumScore;
    private final BigDecimal softScore;

    public static HardMediumSoftBigDecimalScore parseScore(String scoreString) {
        String[] scoreTokens = HardMediumSoftBigDecimalScore.parseScoreTokens(HardMediumSoftBigDecimalScore.class, scoreString, HARD_LABEL, MEDIUM_LABEL, SOFT_LABEL);
        int initScore = HardMediumSoftBigDecimalScore.parseInitScore(HardMediumSoftBigDecimalScore.class, scoreString, scoreTokens[0]);
        BigDecimal hardScore = HardMediumSoftBigDecimalScore.parseLevelAsBigDecimal(HardMediumSoftBigDecimalScore.class, scoreString, scoreTokens[1]);
        BigDecimal mediumScore = HardMediumSoftBigDecimalScore.parseLevelAsBigDecimal(HardMediumSoftBigDecimalScore.class, scoreString, scoreTokens[2]);
        BigDecimal softScore = HardMediumSoftBigDecimalScore.parseLevelAsBigDecimal(HardMediumSoftBigDecimalScore.class, scoreString, scoreTokens[3]);
        return HardMediumSoftBigDecimalScore.valueOfUninitialized(initScore, hardScore, mediumScore, softScore);
    }

    public static HardMediumSoftBigDecimalScore valueOfUninitialized(int initScore, BigDecimal hardScore, BigDecimal mediumScore, BigDecimal softScore) {
        return new HardMediumSoftBigDecimalScore(initScore, hardScore, mediumScore, softScore);
    }

    public static HardMediumSoftBigDecimalScore valueOf(BigDecimal hardScore, BigDecimal mediumScore, BigDecimal softScore) {
        return new HardMediumSoftBigDecimalScore(0, hardScore, mediumScore, softScore);
    }

    private HardMediumSoftBigDecimalScore() {
        super(Integer.MIN_VALUE);
        this.hardScore = null;
        this.mediumScore = null;
        this.softScore = null;
    }

    private HardMediumSoftBigDecimalScore(int initScore, BigDecimal hardScore, BigDecimal mediumScore, BigDecimal softScore) {
        super(initScore);
        this.hardScore = hardScore;
        this.mediumScore = mediumScore;
        this.softScore = softScore;
    }

    public BigDecimal getHardScore() {
        return this.hardScore;
    }

    public BigDecimal getMediumScore() {
        return this.mediumScore;
    }

    public BigDecimal getSoftScore() {
        return this.softScore;
    }

    @Override
    public HardMediumSoftBigDecimalScore toInitializedScore() {
        return this.initScore == 0 ? this : new HardMediumSoftBigDecimalScore(0, this.hardScore, this.mediumScore, this.softScore);
    }

    @Override
    public HardMediumSoftBigDecimalScore withInitScore(int newInitScore) {
        this.assertNoInitScore();
        return new HardMediumSoftBigDecimalScore(newInitScore, this.hardScore, this.mediumScore, this.softScore);
    }

    @Override
    public boolean isFeasible() {
        return this.initScore >= 0 && this.hardScore.compareTo(BigDecimal.ZERO) >= 0;
    }

    @Override
    public HardMediumSoftBigDecimalScore add(HardMediumSoftBigDecimalScore augment) {
        return new HardMediumSoftBigDecimalScore(this.initScore + augment.getInitScore(), this.hardScore.add(augment.getHardScore()), this.mediumScore.add(augment.getMediumScore()), this.softScore.add(augment.getSoftScore()));
    }

    @Override
    public HardMediumSoftBigDecimalScore subtract(HardMediumSoftBigDecimalScore subtrahend) {
        return new HardMediumSoftBigDecimalScore(this.initScore - subtrahend.getInitScore(), this.hardScore.subtract(subtrahend.getHardScore()), this.mediumScore.subtract(subtrahend.getMediumScore()), this.softScore.subtract(subtrahend.getSoftScore()));
    }

    @Override
    public HardMediumSoftBigDecimalScore multiply(double multiplicand) {
        BigDecimal multiplicandBigDecimal = BigDecimal.valueOf(multiplicand);
        return new HardMediumSoftBigDecimalScore((int)Math.floor((double)this.initScore * multiplicand), this.hardScore.multiply(multiplicandBigDecimal).setScale(this.hardScore.scale(), RoundingMode.FLOOR), this.mediumScore.multiply(multiplicandBigDecimal).setScale(this.mediumScore.scale(), RoundingMode.FLOOR), this.softScore.multiply(multiplicandBigDecimal).setScale(this.softScore.scale(), RoundingMode.FLOOR));
    }

    @Override
    public HardMediumSoftBigDecimalScore divide(double divisor) {
        BigDecimal divisorBigDecimal = BigDecimal.valueOf(divisor);
        return new HardMediumSoftBigDecimalScore((int)Math.floor((double)this.initScore / divisor), this.hardScore.divide(divisorBigDecimal, this.hardScore.scale(), RoundingMode.FLOOR), this.mediumScore.divide(divisorBigDecimal, this.mediumScore.scale(), RoundingMode.FLOOR), this.softScore.divide(divisorBigDecimal, this.softScore.scale(), RoundingMode.FLOOR));
    }

    @Override
    public HardMediumSoftBigDecimalScore power(double exponent) {
        BigDecimal exponentBigDecimal = BigDecimal.valueOf(exponent);
        return new HardMediumSoftBigDecimalScore((int)Math.floor(Math.pow(this.initScore, exponent)), this.hardScore.pow(exponentBigDecimal.intValue()).setScale(this.hardScore.scale(), RoundingMode.FLOOR), this.mediumScore.pow(exponentBigDecimal.intValue()).setScale(this.mediumScore.scale(), RoundingMode.FLOOR), this.softScore.pow(exponentBigDecimal.intValue()).setScale(this.softScore.scale(), RoundingMode.FLOOR));
    }

    @Override
    public HardMediumSoftBigDecimalScore negate() {
        return new HardMediumSoftBigDecimalScore(-this.initScore, this.hardScore.negate(), this.mediumScore.negate(), this.softScore.negate());
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.hardScore, this.mediumScore, this.softScore};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HardMediumSoftBigDecimalScore) {
            HardMediumSoftBigDecimalScore other = (HardMediumSoftBigDecimalScore)o;
            return this.initScore == other.getInitScore() && this.hardScore.equals(other.getHardScore()) && this.mediumScore.equals(other.getMediumScore()) && this.softScore.equals(other.getSoftScore());
        }
        return false;
    }

    public int hashCode() {
        return (((629 + this.initScore) * 37 + this.hardScore.hashCode()) * 37 + this.mediumScore.hashCode()) * 37 + this.softScore.hashCode();
    }

    @Override
    public int compareTo(HardMediumSoftBigDecimalScore other) {
        if (this.initScore != other.getInitScore()) {
            return this.initScore < other.getInitScore() ? -1 : 1;
        }
        int hardScoreComparison = this.hardScore.compareTo(other.getHardScore());
        int mediumScoreComparison = this.mediumScore.compareTo(other.getMediumScore());
        if (hardScoreComparison != 0) {
            return hardScoreComparison;
        }
        if (mediumScoreComparison != 0) {
            return mediumScoreComparison;
        }
        return this.softScore.compareTo(other.getSoftScore());
    }

    public String toString() {
        return this.getInitPrefix() + this.hardScore + HARD_LABEL + "/" + this.mediumScore + MEDIUM_LABEL + "/" + this.softScore + SOFT_LABEL;
    }

    @Override
    public boolean isCompatibleArithmeticArgument(Score otherScore) {
        return otherScore instanceof HardMediumSoftBigDecimalScore;
    }
}

