/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardmediumsoftbigdecimal;

import java.math.BigDecimal;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardmediumsoftbigdecimal.HardMediumSoftBigDecimalScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class HardMediumSoftBigDecimalScoreHolder
extends AbstractScoreHolder {
    protected BigDecimal hardScore;
    protected BigDecimal mediumScore;
    protected BigDecimal softScore;

    public HardMediumSoftBigDecimalScoreHolder(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled);
    }

    public BigDecimal getHardScore() {
        return this.hardScore;
    }

    public BigDecimal getMediumScore() {
        return this.mediumScore;
    }

    public BigDecimal getSoftScore() {
        return this.softScore;
    }

    public void addHardConstraintMatch(RuleContext kcontext, final BigDecimal weight) {
        this.hardScore = this.hardScore == null ? weight : this.hardScore.add(weight);
        this.registerBigDecimalConstraintMatch(kcontext, 0, weight, new AbstractScoreHolder.BigDecimalConstraintUndoListener(){

            @Override
            public void undo() {
                HardMediumSoftBigDecimalScoreHolder.this.hardScore = HardMediumSoftBigDecimalScoreHolder.this.hardScore.subtract(weight);
            }
        });
    }

    public void addMediumConstraintMatch(RuleContext kcontext, final BigDecimal weight) {
        this.mediumScore = this.mediumScore == null ? weight : this.mediumScore.add(weight);
        this.registerBigDecimalConstraintMatch(kcontext, 1, weight, new AbstractScoreHolder.BigDecimalConstraintUndoListener(){

            @Override
            public void undo() {
                HardMediumSoftBigDecimalScoreHolder.this.mediumScore = HardMediumSoftBigDecimalScoreHolder.this.mediumScore.subtract(weight);
            }
        });
    }

    public void addSoftConstraintMatch(RuleContext kcontext, final BigDecimal weight) {
        this.softScore = this.softScore == null ? weight : this.softScore.add(weight);
        this.registerBigDecimalConstraintMatch(kcontext, 2, weight, new AbstractScoreHolder.BigDecimalConstraintUndoListener(){

            @Override
            public void undo() {
                HardMediumSoftBigDecimalScoreHolder.this.softScore = HardMediumSoftBigDecimalScoreHolder.this.softScore.subtract(weight);
            }
        });
    }

    @Override
    public Score extractScore(int initScore) {
        return HardMediumSoftBigDecimalScore.valueOfUninitialized(initScore, this.hardScore == null ? BigDecimal.ZERO : this.hardScore, this.mediumScore == null ? BigDecimal.ZERO : this.mediumScore, this.softScore == null ? BigDecimal.ZERO : this.softScore);
    }
}

