/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardsoftdouble;

import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftdouble.HardSoftDoubleScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class HardSoftDoubleScoreHolder
extends AbstractScoreHolder {
    protected double hardScore;
    protected double softScore;

    public HardSoftDoubleScoreHolder(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled);
    }

    public double getHardScore() {
        return this.hardScore;
    }

    public double getSoftScore() {
        return this.softScore;
    }

    public void addHardConstraintMatch(RuleContext kcontext, final double weight) {
        this.hardScore += weight;
        this.registerDoubleConstraintMatch(kcontext, 0, weight, new AbstractScoreHolder.DoubleConstraintUndoListener(){

            @Override
            public void undo() {
                HardSoftDoubleScoreHolder.this.hardScore -= weight;
            }
        });
    }

    public void addSoftConstraintMatch(RuleContext kcontext, final double weight) {
        this.softScore += weight;
        this.registerDoubleConstraintMatch(kcontext, 1, weight, new AbstractScoreHolder.DoubleConstraintUndoListener(){

            @Override
            public void undo() {
                HardSoftDoubleScoreHolder.this.softScore -= weight;
            }
        });
    }

    @Override
    public Score extractScore(int initScore) {
        return HardSoftDoubleScore.valueOfUninitialized(initScore, this.hardScore, this.softScore);
    }
}

