/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.locator;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.optaplanner.core.impl.domain.locator.LocationStrategy;
import org.optaplanner.core.impl.domain.locator.LocationStrategyResolver;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;

public class Locator<Solution_> {
    private final LocationStrategyResolver locationStrategyResolver;
    private Map<Object, Object> idToWorkingObjectMap;

    public Locator(SolutionDescriptor<Solution_> solutionDescriptor) {
        this.locationStrategyResolver = solutionDescriptor.getLocationStrategyResolver();
    }

    public void resetWorkingObjects(Collection<Object> allFacts) {
        this.idToWorkingObjectMap = new HashMap<Object, Object>(allFacts.size());
        for (Object fact : allFacts) {
            this.addWorkingObject(fact);
        }
    }

    public void addWorkingObject(Object workingObject) {
        LocationStrategy locationStrategy = this.locationStrategyResolver.determineLocationStrategy(workingObject);
        locationStrategy.addWorkingObject(this.idToWorkingObjectMap, workingObject);
    }

    public void removeWorkingObject(Object workingObject) {
        LocationStrategy locationStrategy = this.locationStrategyResolver.determineLocationStrategy(workingObject);
        locationStrategy.removeWorkingObject(this.idToWorkingObjectMap, workingObject);
    }

    public void clearWorkingObjects() {
        this.idToWorkingObjectMap = null;
    }

    public <E> E locateWorkingObject(E externalObject) {
        if (externalObject == null) {
            return null;
        }
        LocationStrategy locationStrategy = this.locationStrategyResolver.determineLocationStrategy(externalObject);
        return locationStrategy.locateWorkingObject(this.idToWorkingObjectMap, externalObject);
    }
}

