/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.solution.descriptor;

import com.google.common.collect.Iterators;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningEntityProperty;
import org.optaplanner.core.api.domain.solution.PlanningScore;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.domain.solution.cloner.SolutionCloner;
import org.optaplanner.core.api.domain.solution.drools.ProblemFactCollectionProperty;
import org.optaplanner.core.api.domain.solution.drools.ProblemFactProperty;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.score.AbstractBendableScore;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import org.optaplanner.core.api.score.buildin.hardsoftdouble.HardSoftDoubleScore;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScore;
import org.optaplanner.core.api.score.buildin.simpledouble.SimpleDoubleScore;
import org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScore;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.accessor.BeanPropertyMemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.locator.LocationStrategyResolver;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.domain.solution.AbstractSolution;
import org.optaplanner.core.impl.domain.solution.cloner.FieldAccessingSolutionCloner;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.score.buildin.bendable.BendableScoreDefinition;
import org.optaplanner.core.impl.score.buildin.bendablebigdecimal.BendableBigDecimalScoreDefinition;
import org.optaplanner.core.impl.score.buildin.bendablelong.BendableLongScoreDefinition;
import org.optaplanner.core.impl.score.buildin.hardmediumsoft.HardMediumSoftScoreDefinition;
import org.optaplanner.core.impl.score.buildin.hardmediumsoftlong.HardMediumSoftLongScoreDefinition;
import org.optaplanner.core.impl.score.buildin.hardsoft.HardSoftScoreDefinition;
import org.optaplanner.core.impl.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScoreDefinition;
import org.optaplanner.core.impl.score.buildin.hardsoftdouble.HardSoftDoubleScoreDefinition;
import org.optaplanner.core.impl.score.buildin.hardsoftlong.HardSoftLongScoreDefinition;
import org.optaplanner.core.impl.score.buildin.simple.SimpleScoreDefinition;
import org.optaplanner.core.impl.score.buildin.simplebigdecimal.SimpleBigDecimalScoreDefinition;
import org.optaplanner.core.impl.score.buildin.simpledouble.SimpleDoubleScoreDefinition;
import org.optaplanner.core.impl.score.buildin.simplelong.SimpleLongScoreDefinition;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolutionDescriptor<Solution_> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Class<Solution_> solutionClass;
    private SolutionCloner<Solution_> solutionCloner;
    private final Map<String, MemberAccessor> problemFactMemberAccessorMap;
    private final Map<String, MemberAccessor> problemFactCollectionMemberAccessorMap;
    private final Map<String, MemberAccessor> entityMemberAccessorMap;
    private final Map<String, MemberAccessor> entityCollectionMemberAccessorMap;
    private MemberAccessor scoreMemberAccessor;
    private ScoreDefinition scoreDefinition;
    private final Map<Class<?>, EntityDescriptor<Solution_>> entityDescriptorMap;
    private final List<Class<?>> reversedEntityClassList;
    private final ConcurrentMap<Class<?>, EntityDescriptor<Solution_>> lowestEntityDescriptorCache = new ConcurrentHashMap();
    private LocationStrategyResolver locationStrategyResolver = null;

    public static <Solution_> SolutionDescriptor<Solution_> buildSolutionDescriptor(Class<Solution_> solutionClass, Class<?> ... entityClasses) {
        return SolutionDescriptor.buildSolutionDescriptor(solutionClass, Arrays.asList(entityClasses), null);
    }

    public static <Solution_> SolutionDescriptor<Solution_> buildSolutionDescriptor(Class<Solution_> solutionClass, List<Class<?>> entityClassList, ScoreDefinition deprecatedScoreDefinition) {
        DescriptorPolicy descriptorPolicy = new DescriptorPolicy();
        SolutionDescriptor<Solution_> solutionDescriptor = new SolutionDescriptor<Solution_>(solutionClass);
        solutionDescriptor.processAnnotations(descriptorPolicy, deprecatedScoreDefinition);
        for (Class<?> entityClass : SolutionDescriptor.sortEntityClassList(entityClassList)) {
            EntityDescriptor<Solution_> entityDescriptor = new EntityDescriptor<Solution_>(solutionDescriptor, entityClass);
            solutionDescriptor.addEntityDescriptor(entityDescriptor);
            entityDescriptor.processAnnotations(descriptorPolicy);
        }
        solutionDescriptor.afterAnnotationsProcessed(descriptorPolicy);
        return solutionDescriptor;
    }

    private static List<Class<?>> sortEntityClassList(List<Class<?>> entityClassList) {
        ArrayList sortedEntityClassList = new ArrayList(entityClassList.size());
        for (Class<?> entityClass : entityClassList) {
            boolean added = false;
            for (int i = 0; i < sortedEntityClassList.size(); ++i) {
                Class sortedEntityClass = (Class)sortedEntityClassList.get(i);
                if (!entityClass.isAssignableFrom(sortedEntityClass)) continue;
                sortedEntityClassList.add(i, entityClass);
                added = true;
                break;
            }
            if (added) continue;
            sortedEntityClassList.add(entityClass);
        }
        return sortedEntityClassList;
    }

    public SolutionDescriptor(Class<Solution_> solutionClass) {
        this.solutionClass = solutionClass;
        this.problemFactMemberAccessorMap = new LinkedHashMap<String, MemberAccessor>();
        this.problemFactCollectionMemberAccessorMap = new LinkedHashMap<String, MemberAccessor>();
        this.entityMemberAccessorMap = new LinkedHashMap<String, MemberAccessor>();
        this.entityCollectionMemberAccessorMap = new LinkedHashMap<String, MemberAccessor>();
        this.entityDescriptorMap = new LinkedHashMap();
        this.reversedEntityClassList = new ArrayList();
    }

    public void addEntityDescriptor(EntityDescriptor<Solution_> entityDescriptor) {
        Class<?> entityClass = entityDescriptor.getEntityClass();
        for (Class<?> otherEntityClass : this.entityDescriptorMap.keySet()) {
            if (!entityClass.isAssignableFrom(otherEntityClass)) continue;
            throw new IllegalArgumentException("An earlier entityClass (" + otherEntityClass + ") should not be a subclass of a later entityClass (" + entityClass + "). Switch their declaration so superclasses are defined earlier.");
        }
        this.entityDescriptorMap.put(entityClass, entityDescriptor);
        this.reversedEntityClassList.add(0, entityClass);
        this.lowestEntityDescriptorCache.put(entityClass, entityDescriptor);
    }

    public void processAnnotations(DescriptorPolicy descriptorPolicy, ScoreDefinition deprecatedScoreDefinition) {
        this.processSolutionAnnotations(descriptorPolicy);
        for (Class<?> lineageClass : ConfigUtils.getAllAnnotatedLineageClasses(this.solutionClass, PlanningSolution.class)) {
            List<Member> memberList = ConfigUtils.getDeclaredMembers(lineageClass);
            for (Member member : memberList) {
                this.processValueRangeProviderAnnotation(descriptorPolicy, member);
                this.processProblemFactPropertyAnnotation(descriptorPolicy, member);
                this.processPlanningEntityPropertyAnnotation(descriptorPolicy, member);
                this.processScoreAnnotation(descriptorPolicy, member, deprecatedScoreDefinition);
            }
        }
        if (this.entityCollectionMemberAccessorMap.isEmpty() && this.entityMemberAccessorMap.isEmpty()) {
            throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") must have at least 1 member with a " + PlanningEntityCollectionProperty.class.getSimpleName() + " annotation or a " + PlanningEntityProperty.class.getSimpleName() + " annotation.");
        }
        if (Solution.class.isAssignableFrom(this.solutionClass)) {
            this.processLegacySolution(descriptorPolicy, deprecatedScoreDefinition);
            return;
        }
        if (this.scoreMemberAccessor == null) {
            throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") must have 1 member with a " + PlanningScore.class.getSimpleName() + " annotation.\nMaybe add a getScore() method with a " + PlanningScore.class.getSimpleName() + " annotation.");
        }
    }

    private void processLegacySolution(DescriptorPolicy descriptorPolicy, ScoreDefinition deprecatedScoreDefinition) {
        if (!this.problemFactMemberAccessorMap.isEmpty()) {
            MemberAccessor memberAccessor = this.problemFactMemberAccessorMap.values().iterator().next();
            throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") which implements the legacy interface " + Solution.class.getSimpleName() + ") must not have a member (" + memberAccessor.getName() + ") with a " + ProblemFactProperty.class.getSimpleName() + " annotation.\nMaybe remove the use of the legacy interface.");
        }
        if (!this.problemFactCollectionMemberAccessorMap.isEmpty()) {
            MemberAccessor memberAccessor = this.problemFactCollectionMemberAccessorMap.values().iterator().next();
            throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") which implements the legacy interface " + Solution.class.getSimpleName() + ") must not have a member (" + memberAccessor.getName() + ") with a " + ProblemFactCollectionProperty.class.getSimpleName() + " annotation.\nMaybe remove the use of the legacy interface.");
        }
        try {
            Method getProblemFactsMethod = this.solutionClass.getMethod("getProblemFacts", new Class[0]);
            BeanPropertyMemberAccessor problemFactsMemberAccessor = new BeanPropertyMemberAccessor(getProblemFactsMethod);
            this.problemFactCollectionMemberAccessorMap.put(problemFactsMemberAccessor.getName(), problemFactsMemberAccessor);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Impossible situation: the solutionClass (" + this.solutionClass + ") which implements the legacy interface " + Solution.class.getSimpleName() + ", lacks its getProblemFacts() method.", e);
        }
        if (this.scoreMemberAccessor != null) {
            throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") which implements the legacy interface " + Solution.class.getSimpleName() + ") must not have a member (" + this.scoreMemberAccessor.getName() + ") with a " + PlanningScore.class.getSimpleName() + " annotation.\nMaybe remove the use of the legacy interface.");
        }
        try {
            Method getScoreMethod = this.solutionClass.getMethod("getScore", new Class[0]);
            this.scoreMemberAccessor = new BeanPropertyMemberAccessor(getScoreMethod);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Impossible situation: the solutionClass (" + this.solutionClass + ") which implements the legacy interface " + Solution.class.getSimpleName() + ", lacks its getScore() method.", e);
        }
        if (deprecatedScoreDefinition == null) {
            deprecatedScoreDefinition = new SimpleScoreDefinition();
        }
        this.scoreDefinition = deprecatedScoreDefinition;
        Class<Score> scoreClass = this.extractScoreClass();
        if (!scoreClass.isAssignableFrom(this.scoreDefinition.getScoreClass())) {
            throw new IllegalArgumentException("The scoreClass (" + scoreClass + ") of solutionClass (" + this.solutionClass + ") is not the same or a superclass as the scoreDefinition's scoreClass (" + this.scoreDefinition.getScoreClass() + ").");
        }
    }

    public void checkIfProblemFactsExist() {
        if (this.problemFactCollectionMemberAccessorMap.isEmpty() && this.problemFactMemberAccessorMap.isEmpty()) {
            throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") must have at least 1 member with a " + ProblemFactCollectionProperty.class.getSimpleName() + " annotation or a " + ProblemFactProperty.class.getSimpleName() + " annotation when used with Drools score calculation.");
        }
    }

    private void processSolutionAnnotations(DescriptorPolicy descriptorPolicy) {
        PlanningSolution solutionAnnotation = this.solutionClass.getAnnotation(PlanningSolution.class);
        if (solutionAnnotation == null) {
            throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") has been specified as a solution in the configuration, but does not have a " + PlanningSolution.class.getSimpleName() + " annotation.");
        }
        this.processSolutionCloner(descriptorPolicy, solutionAnnotation);
        this.locationStrategyResolver = new LocationStrategyResolver(solutionAnnotation.locationStrategyType());
    }

    private void processSolutionCloner(DescriptorPolicy descriptorPolicy, PlanningSolution solutionAnnotation) {
        Class<? extends SolutionCloner> solutionClonerClass = solutionAnnotation.solutionCloner();
        if (solutionClonerClass == PlanningSolution.NullSolutionCloner.class) {
            solutionClonerClass = null;
        }
        this.solutionCloner = solutionClonerClass != null ? ConfigUtils.newInstance(this, "solutionClonerClass", solutionClonerClass) : new FieldAccessingSolutionCloner(this);
    }

    private void processValueRangeProviderAnnotation(DescriptorPolicy descriptorPolicy, Member member) {
        if (((AnnotatedElement)((Object)member)).isAnnotationPresent(ValueRangeProvider.class)) {
            MemberAccessor memberAccessor = ConfigUtils.buildMemberAccessor(member, ConfigUtils.MemberAccessorType.FIELD_OR_READ_METHOD, ValueRangeProvider.class);
            descriptorPolicy.addFromSolutionValueRangeProvider(memberAccessor);
        }
    }

    private void processProblemFactPropertyAnnotation(DescriptorPolicy descriptorPolicy, Member member) {
        Class<? extends Annotation> annotationClass = ConfigUtils.extractAnnotationClass(member, ProblemFactProperty.class, ProblemFactCollectionProperty.class);
        if (annotationClass != null) {
            MemberAccessor memberAccessor = ConfigUtils.buildMemberAccessor(member, ConfigUtils.MemberAccessorType.FIELD_OR_READ_METHOD, annotationClass);
            this.assertUnexistingProblemFactOrPlanningEntityProperty(memberAccessor, annotationClass);
            if (annotationClass == ProblemFactProperty.class) {
                this.problemFactMemberAccessorMap.put(memberAccessor.getName(), memberAccessor);
            } else if (annotationClass == ProblemFactCollectionProperty.class) {
                if (!Collection.class.isAssignableFrom(memberAccessor.getType())) {
                    throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") has a " + ProblemFactCollectionProperty.class.getSimpleName() + " annotated member (" + member + ") that does not return a " + Collection.class.getSimpleName() + ".");
                }
                this.problemFactCollectionMemberAccessorMap.put(memberAccessor.getName(), memberAccessor);
            }
        }
    }

    private void processPlanningEntityPropertyAnnotation(DescriptorPolicy descriptorPolicy, Member member) {
        Class<? extends Annotation> annotationClass = ConfigUtils.extractAnnotationClass(member, PlanningEntityProperty.class, PlanningEntityCollectionProperty.class);
        if (annotationClass != null) {
            MemberAccessor memberAccessor = ConfigUtils.buildMemberAccessor(member, ConfigUtils.MemberAccessorType.FIELD_OR_GETTER_METHOD, annotationClass);
            this.assertUnexistingProblemFactOrPlanningEntityProperty(memberAccessor, annotationClass);
            if (annotationClass == PlanningEntityProperty.class) {
                this.entityMemberAccessorMap.put(memberAccessor.getName(), memberAccessor);
            } else if (annotationClass == PlanningEntityCollectionProperty.class) {
                if (!Collection.class.isAssignableFrom(memberAccessor.getType())) {
                    throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") has a " + PlanningEntityCollectionProperty.class.getSimpleName() + " annotated member (" + member + ") that does not return a " + Collection.class.getSimpleName() + ".");
                }
                this.entityCollectionMemberAccessorMap.put(memberAccessor.getName(), memberAccessor);
            }
        }
    }

    private void assertUnexistingProblemFactOrPlanningEntityProperty(MemberAccessor memberAccessor, Class<? extends Annotation> annotationClass) {
        Class otherAnnotationClass;
        MemberAccessor duplicate;
        String memberName = memberAccessor.getName();
        if (this.problemFactMemberAccessorMap.containsKey(memberName)) {
            duplicate = this.problemFactMemberAccessorMap.get(memberName);
            otherAnnotationClass = ProblemFactProperty.class;
        } else if (this.problemFactCollectionMemberAccessorMap.containsKey(memberName)) {
            duplicate = this.problemFactCollectionMemberAccessorMap.get(memberName);
            otherAnnotationClass = ProblemFactCollectionProperty.class;
        } else if (this.entityMemberAccessorMap.containsKey(memberName)) {
            duplicate = this.entityMemberAccessorMap.get(memberName);
            otherAnnotationClass = PlanningEntityProperty.class;
        } else if (this.entityCollectionMemberAccessorMap.containsKey(memberName)) {
            duplicate = this.entityCollectionMemberAccessorMap.get(memberName);
            otherAnnotationClass = PlanningEntityCollectionProperty.class;
        } else {
            return;
        }
        throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") has a " + annotationClass.getSimpleName() + " annotated member (" + memberAccessor + ") that is duplicated by a " + otherAnnotationClass.getSimpleName() + " annotated member (" + duplicate + ").\n" + (annotationClass.equals(otherAnnotationClass) ? "Maybe the annotation is defined on both the field and its getter." : "Maybe 2 mutually exclusive annotations are configured."));
    }

    private void processScoreAnnotation(DescriptorPolicy descriptorPolicy, Member member, ScoreDefinition deprecatedScoreDefinition) {
        if (((AnnotatedElement)((Object)member)).isAnnotationPresent(PlanningScore.class)) {
            MemberAccessor memberAccessor = ConfigUtils.buildMemberAccessor(member, ConfigUtils.MemberAccessorType.FIELD_OR_GETTER_METHOD_WITH_SETTER, PlanningScore.class);
            if (deprecatedScoreDefinition != null) {
                throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") has a " + PlanningScore.class.getSimpleName() + " annotated member (" + memberAccessor + ") but the solver configuration still has a deprecated scoreDefinitionType or scoreDefinitionClass element.\nMaybe remove the <scoreDefinitionType>, <bendableHardLevelsSize>, <bendableSoftLevelsSize> and <scoreDefinitionClass> elements from the solver configuration.");
            }
            if (!Score.class.isAssignableFrom(memberAccessor.getType())) {
                throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") has a " + PlanningScore.class.getSimpleName() + " annotated member (" + memberAccessor + ") that does not return a subtype of Score.");
            }
            if (this.scoreMemberAccessor != null) {
                if (!this.scoreMemberAccessor.getName().equals(memberAccessor.getName()) || !this.scoreMemberAccessor.getClass().equals(memberAccessor.getClass())) {
                    throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") has a " + PlanningScore.class.getSimpleName() + " annotated member (" + memberAccessor + ") that is duplicated by another member (" + this.scoreMemberAccessor + ").\n  Verify that the annotation is not defined on both the field and its getter.");
                }
                return;
            }
            this.scoreMemberAccessor = memberAccessor;
            Class<?> scoreType = this.scoreMemberAccessor.getType();
            PlanningScore annotation = this.scoreMemberAccessor.getAnnotation(PlanningScore.class);
            this.scoreDefinition = this.buildScoreDefinition(scoreType, annotation);
        }
    }

    public ScoreDefinition buildScoreDefinition(Class<? extends Score> scoreType, PlanningScore annotation) {
        Class<? extends ScoreDefinition> scoreDefinitionClass = annotation.scoreDefinitionClass();
        if (scoreDefinitionClass != PlanningScore.NullScoreDefinition.class) {
            if (annotation.bendableHardLevelsSize() != -1 || annotation.bendableSoftLevelsSize() != -1) {
                throw new IllegalArgumentException("The solutionClass (" + this.solutionClass + ") has a " + PlanningScore.class.getSimpleName() + " annotated member (" + this.scoreMemberAccessor + ") that has a scoreDefinition (" + scoreDefinitionClass + ") that must not have a bendableHardLevelsSize (" + annotation.bendableHardLevelsSize() + ") or a bendableSoftLevelsSize (" + annotation.bendableSoftLevelsSize() + ").");
            }
            return ConfigUtils.newInstance(this, "scoreDefinitionClass", scoreDefinitionClass);
        }
        if (scoreType == Score.class) {
            if (!AbstractSolution.class.isAssignableFrom(this.solutionClass)) {
                throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") has a " + PlanningScore.class.getSimpleName() + " annotated member (" + this.scoreMemberAccessor + ") that doesn't return a non-abstract " + Score.class.getSimpleName() + " class.\nMaybe make it return " + HardSoftScore.class.getSimpleName() + " or another specific " + Score.class.getSimpleName() + " implementation.");
            }
            if (this.solutionClass == AbstractSolution.class) {
                throw new IllegalArgumentException("The solutionClass (" + this.solutionClass + ") cannot be directly a " + AbstractSolution.class.getSimpleName() + ", but a subclass would be ok.");
            }
            Class<Solution_> baseClass = this.solutionClass;
            while (baseClass.getSuperclass() != AbstractSolution.class) {
                if ((baseClass = baseClass.getSuperclass()) != null) continue;
                throw new IllegalStateException("Impossible situation because the solutionClass (" + this.solutionClass + ") is assignable from " + AbstractSolution.class.getSimpleName() + ".");
            }
            Type genericAbstractSolution = this.solutionClass.getGenericSuperclass();
            if (!(genericAbstractSolution instanceof ParameterizedType)) {
                throw new IllegalStateException("Impossible situation because the genericAbstractSolution (" + genericAbstractSolution + ") is a " + AbstractSolution.class.getSimpleName() + ".");
            }
            ParameterizedType parameterizedAbstractSolution = (ParameterizedType)genericAbstractSolution;
            Type[] typeArguments = parameterizedAbstractSolution.getActualTypeArguments();
            if (typeArguments.length != 1) {
                throw new IllegalStateException("Impossible situation because the parameterizedAbstractSolution (" + parameterizedAbstractSolution + ") is a " + AbstractSolution.class.getSimpleName() + ".");
            }
            Type typeArgument = typeArguments[0];
            if (!(typeArgument instanceof Class)) {
                throw new IllegalStateException("Impossible situation because a (" + AbstractSolution.class.getSimpleName() + "'s typeArgument (" + typeArgument + ") must be a " + Score.class.getSimpleName() + ".");
            }
            scoreType = (Class)typeArgument;
        }
        if (!AbstractBendableScore.class.isAssignableFrom(scoreType)) {
            if (annotation.bendableHardLevelsSize() != -1 || annotation.bendableSoftLevelsSize() != -1) {
                throw new IllegalArgumentException("The solutionClass (" + this.solutionClass + ") has a " + PlanningScore.class.getSimpleName() + " annotated member (" + this.scoreMemberAccessor + ") that returns a scoreType (" + scoreType + ") that must not have a bendableHardLevelsSize (" + annotation.bendableHardLevelsSize() + ") or a bendableSoftLevelsSize (" + annotation.bendableSoftLevelsSize() + ").");
            }
            if (scoreType.equals(SimpleScore.class)) {
                return new SimpleScoreDefinition();
            }
            if (scoreType.equals(SimpleLongScore.class)) {
                return new SimpleLongScoreDefinition();
            }
            if (scoreType.equals(SimpleDoubleScore.class)) {
                return new SimpleDoubleScoreDefinition();
            }
            if (scoreType.equals(SimpleBigDecimalScore.class)) {
                return new SimpleBigDecimalScoreDefinition();
            }
            if (scoreType.equals(HardSoftScore.class)) {
                return new HardSoftScoreDefinition();
            }
            if (scoreType.equals(HardSoftLongScore.class)) {
                return new HardSoftLongScoreDefinition();
            }
            if (scoreType.equals(HardSoftDoubleScore.class)) {
                return new HardSoftDoubleScoreDefinition();
            }
            if (scoreType.equals(HardSoftBigDecimalScore.class)) {
                return new HardSoftBigDecimalScoreDefinition();
            }
            if (scoreType.equals(HardMediumSoftScore.class)) {
                return new HardMediumSoftScoreDefinition();
            }
            if (scoreType.equals(HardMediumSoftLongScore.class)) {
                return new HardMediumSoftLongScoreDefinition();
            }
            throw new IllegalArgumentException("The solutionClass (" + this.solutionClass + ") has a " + PlanningScore.class.getSimpleName() + " annotated member (" + this.scoreMemberAccessor + ") that returns a scoreType (" + scoreType + ") that is not recognized as a default " + Score.class.getSimpleName() + " implementation.\n  If you intend to use a custom implementation, maybe set a scoreDefinition in the " + PlanningScore.class.getSimpleName() + " annotation.");
        }
        int bendableHardLevelsSize = annotation.bendableHardLevelsSize();
        int bendableSoftLevelsSize = annotation.bendableSoftLevelsSize();
        if (bendableHardLevelsSize == -1 || bendableSoftLevelsSize == -1) {
            throw new IllegalArgumentException("The solutionClass (" + this.solutionClass + ") has a " + PlanningScore.class.getSimpleName() + " annotated member (" + this.scoreMemberAccessor + ") that returns a scoreType (" + scoreType + ") that must have a bendableHardLevelsSize (" + annotation.bendableHardLevelsSize() + ") and a bendableSoftLevelsSize (" + annotation.bendableSoftLevelsSize() + ").");
        }
        if (scoreType.equals(BendableScore.class)) {
            return new BendableScoreDefinition(bendableHardLevelsSize, bendableSoftLevelsSize);
        }
        if (scoreType.equals(BendableLongScore.class)) {
            return new BendableLongScoreDefinition(bendableHardLevelsSize, bendableSoftLevelsSize);
        }
        if (scoreType.equals(BendableBigDecimalScore.class)) {
            return new BendableBigDecimalScoreDefinition(bendableHardLevelsSize, bendableSoftLevelsSize);
        }
        throw new IllegalArgumentException("The solutionClass (" + this.solutionClass + ") has a " + PlanningScore.class.getSimpleName() + " annotated member (" + this.scoreMemberAccessor + ") that returns a bendable scoreType (" + scoreType + ") that is not recognized as a default " + Score.class.getSimpleName() + " implementation.\n  If you intend to use a custom implementation, maybe set a scoreDefinition in the annotation.");
    }

    public void afterAnnotationsProcessed(DescriptorPolicy descriptorPolicy) {
        for (EntityDescriptor<Solution_> entityDescriptor : this.entityDescriptorMap.values()) {
            entityDescriptor.linkInheritedEntityDescriptors(descriptorPolicy);
        }
        for (EntityDescriptor<Solution_> entityDescriptor : this.entityDescriptorMap.values()) {
            entityDescriptor.linkShadowSources(descriptorPolicy);
        }
        this.determineGlobalShadowOrder();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("    Model annotations parsed for Solution {}:", (Object)this.solutionClass.getSimpleName());
            for (Map.Entry entry : this.entityDescriptorMap.entrySet()) {
                EntityDescriptor entityDescriptor = (EntityDescriptor)entry.getValue();
                this.logger.trace("        Entity {}:", (Object)entityDescriptor.getEntityClass().getSimpleName());
                for (VariableDescriptor variableDescriptor : entityDescriptor.getDeclaredVariableDescriptors()) {
                    this.logger.trace("            Variable {} ({})", (Object)variableDescriptor.getVariableName(), (Object)(variableDescriptor instanceof GenuineVariableDescriptor ? "genuine" : "shadow"));
                }
            }
        }
    }

    private void determineGlobalShadowOrder() {
        ArrayList<Object> pairList = new ArrayList<Object>();
        HashMap<ShadowVariableDescriptor<Solution_>, MutablePair> shadowToPairMap = new HashMap<ShadowVariableDescriptor<Solution_>, MutablePair>();
        for (EntityDescriptor<Solution_> entityDescriptor : this.entityDescriptorMap.values()) {
            for (ShadowVariableDescriptor<Solution_> shadowVariableDescriptor : entityDescriptor.getDeclaredShadowVariableDescriptors()) {
                int sourceSize = shadowVariableDescriptor.getSourceVariableDescriptorList().size();
                MutablePair pair = MutablePair.of(shadowVariableDescriptor, (Object)sourceSize);
                pairList.add(pair);
                shadowToPairMap.put(shadowVariableDescriptor, pair);
            }
        }
        for (EntityDescriptor<Solution_> entityDescriptor : this.entityDescriptorMap.values()) {
            for (GenuineVariableDescriptor genuineVariableDescriptor : entityDescriptor.getDeclaredGenuineVariableDescriptors()) {
                for (ShadowVariableDescriptor sink : genuineVariableDescriptor.getSinkVariableDescriptorList()) {
                    Pair sinkPair = (Pair)shadowToPairMap.get(sink);
                    sinkPair.setValue((Object)((Integer)sinkPair.getValue() - 1));
                }
            }
        }
        int globalShadowOrder = 0;
        while (!pairList.isEmpty()) {
            pairList.sort(Comparator.comparingInt(Pair::getValue));
            Pair pair = (Pair)pairList.remove(0);
            ShadowVariableDescriptor shadow = (ShadowVariableDescriptor)pair.getKey();
            if ((Integer)pair.getValue() != 0) {
                if ((Integer)pair.getValue() < 0) {
                    throw new IllegalStateException("Impossible state because the shadowVariable (" + shadow.getSimpleEntityAndVariableName() + ") can not be used more as a sink than it has sources.");
                }
                throw new IllegalStateException("There is a cyclic shadow variable path that involves the shadowVariable (" + shadow.getSimpleEntityAndVariableName() + ") because it must be later than its sources (" + shadow.getSourceVariableDescriptorList() + ") and also earlier than its sinks (" + shadow.getSinkVariableDescriptorList() + ").");
            }
            for (ShadowVariableDescriptor sink : shadow.getSinkVariableDescriptorList()) {
                Pair sinkPair = (Pair)shadowToPairMap.get(sink);
                sinkPair.setValue((Object)((Integer)sinkPair.getValue() - 1));
            }
            shadow.setGlobalShadowOrder(globalShadowOrder);
            ++globalShadowOrder;
        }
    }

    public Class<Solution_> getSolutionClass() {
        return this.solutionClass;
    }

    public Class<? extends Score> extractScoreClass() {
        return this.scoreMemberAccessor.getType();
    }

    public ScoreDefinition getScoreDefinition() {
        return this.scoreDefinition;
    }

    public SolutionCloner<Solution_> getSolutionCloner() {
        return this.solutionCloner;
    }

    public Map<String, MemberAccessor> getProblemFactMemberAccessorMap() {
        return this.problemFactMemberAccessorMap;
    }

    public Map<String, MemberAccessor> getProblemFactCollectionMemberAccessorMap() {
        return this.problemFactCollectionMemberAccessorMap;
    }

    public List<String> getProblemFactMemberAndProblemFactCollectionMemberNames() {
        ArrayList<String> memberNames = new ArrayList<String>(this.problemFactMemberAccessorMap.size() + this.problemFactCollectionMemberAccessorMap.size());
        memberNames.addAll(this.problemFactMemberAccessorMap.keySet());
        memberNames.addAll(this.problemFactCollectionMemberAccessorMap.keySet());
        return memberNames;
    }

    public Map<String, MemberAccessor> getEntityMemberAccessorMap() {
        return this.entityMemberAccessorMap;
    }

    public Map<String, MemberAccessor> getEntityCollectionMemberAccessorMap() {
        return this.entityCollectionMemberAccessorMap;
    }

    public List<String> getEntityMemberAndEntityCollectionMemberNames() {
        ArrayList<String> memberNames = new ArrayList<String>(this.entityMemberAccessorMap.size() + this.entityCollectionMemberAccessorMap.size());
        memberNames.addAll(this.entityMemberAccessorMap.keySet());
        memberNames.addAll(this.entityCollectionMemberAccessorMap.keySet());
        return memberNames;
    }

    public Set<Class<?>> getEntityClassSet() {
        return this.entityDescriptorMap.keySet();
    }

    public Collection<EntityDescriptor<Solution_>> getEntityDescriptors() {
        return this.entityDescriptorMap.values();
    }

    public Collection<EntityDescriptor<Solution_>> getGenuineEntityDescriptors() {
        ArrayList<EntityDescriptor<Solution_>> genuineEntityDescriptorList = new ArrayList<EntityDescriptor<Solution_>>(this.entityDescriptorMap.size());
        for (EntityDescriptor<Solution_> entityDescriptor : this.entityDescriptorMap.values()) {
            if (!entityDescriptor.hasAnyDeclaredGenuineVariableDescriptor()) continue;
            genuineEntityDescriptorList.add(entityDescriptor);
        }
        return genuineEntityDescriptorList;
    }

    public boolean hasEntityDescriptorStrict(Class<?> entityClass) {
        return this.entityDescriptorMap.containsKey(entityClass);
    }

    public EntityDescriptor<Solution_> getEntityDescriptorStrict(Class<?> entityClass) {
        return this.entityDescriptorMap.get(entityClass);
    }

    public boolean hasEntityDescriptor(Class<?> entitySubclass) {
        EntityDescriptor<Solution_> entityDescriptor = this.findEntityDescriptor(entitySubclass);
        return entityDescriptor != null;
    }

    public EntityDescriptor<Solution_> findEntityDescriptorOrFail(Class<?> entitySubclass) {
        EntityDescriptor<Solution_> entityDescriptor = this.findEntityDescriptor(entitySubclass);
        if (entityDescriptor == null) {
            throw new IllegalArgumentException("A planning entity is an instance of an entitySubclass (" + entitySubclass + ") that is not configured as a planning entity.\nIf that class (" + entitySubclass.getSimpleName() + ") (or superclass thereof) is not a entityClass (" + this.getEntityClassSet() + "), check your Solution implementation's annotated methods.\nIf it is, check your solver configuration.");
        }
        return entityDescriptor;
    }

    public EntityDescriptor<Solution_> findEntityDescriptor(Class<?> entitySubclass) {
        return this.lowestEntityDescriptorCache.computeIfAbsent(entitySubclass, key -> {
            for (Class<?> entityClass : this.reversedEntityClassList) {
                if (!entityClass.isAssignableFrom(entitySubclass)) continue;
                return this.entityDescriptorMap.get(entityClass);
            }
            return null;
        });
    }

    public GenuineVariableDescriptor<Solution_> findGenuineVariableDescriptor(Object entity, String variableName) {
        EntityDescriptor<Solution_> entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
        return entityDescriptor.getGenuineVariableDescriptor(variableName);
    }

    public GenuineVariableDescriptor<Solution_> findGenuineVariableDescriptorOrFail(Object entity, String variableName) {
        EntityDescriptor<Solution_> entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
        GenuineVariableDescriptor<Solution_> variableDescriptor = entityDescriptor.getGenuineVariableDescriptor(variableName);
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(entityDescriptor.buildInvalidVariableNameExceptionMessage(variableName));
        }
        return variableDescriptor;
    }

    public VariableDescriptor<Solution_> findVariableDescriptor(Object entity, String variableName) {
        EntityDescriptor<Solution_> entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
        return entityDescriptor.getVariableDescriptor(variableName);
    }

    public VariableDescriptor<Solution_> findVariableDescriptorOrFail(Object entity, String variableName) {
        EntityDescriptor<Solution_> entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
        VariableDescriptor<Solution_> variableDescriptor = entityDescriptor.getVariableDescriptor(variableName);
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(entityDescriptor.buildInvalidVariableNameExceptionMessage(variableName));
        }
        return variableDescriptor;
    }

    public LocationStrategyResolver getLocationStrategyResolver() {
        return this.locationStrategyResolver;
    }

    public Collection<Object> getAllFacts(Solution_ solution) {
        ArrayList<Object> facts = new ArrayList<Object>();
        Arrays.asList(this.entityMemberAccessorMap, this.problemFactMemberAccessorMap).forEach(map -> map.forEach((key, memberAccessor) -> {
            Object object = this.extractMemberObject((MemberAccessor)memberAccessor, solution);
            if (object != null) {
                facts.add(object);
            }
        }));
        Arrays.asList(this.entityCollectionMemberAccessorMap, this.problemFactCollectionMemberAccessorMap).forEach(map -> map.forEach((key, memberAccessor) -> facts.addAll(this.extractMemberCollection((MemberAccessor)memberAccessor, solution))));
        return facts;
    }

    public int getEntityCount(Solution_ solution) {
        int entityCount = 0;
        for (MemberAccessor entityMemberAccessor : this.entityMemberAccessorMap.values()) {
            Object entity = this.extractMemberObject(entityMemberAccessor, solution);
            if (entity == null) continue;
            ++entityCount;
        }
        for (MemberAccessor entityCollectionMemberAccessor : this.entityCollectionMemberAccessorMap.values()) {
            Collection<Object> entityCollection = this.extractMemberCollection(entityCollectionMemberAccessor, solution);
            entityCount += entityCollection.size();
        }
        return entityCount;
    }

    public List<Object> getEntityList(Solution_ solution) {
        ArrayList<Object> entityList = new ArrayList<Object>();
        for (MemberAccessor entityMemberAccessor : this.entityMemberAccessorMap.values()) {
            Object entity = this.extractMemberObject(entityMemberAccessor, solution);
            if (entity == null) continue;
            entityList.add(entity);
        }
        for (MemberAccessor entityCollectionMemberAccessor : this.entityCollectionMemberAccessorMap.values()) {
            Collection<Object> entityCollection = this.extractMemberCollection(entityCollectionMemberAccessor, solution);
            entityList.addAll(entityCollection);
        }
        return entityList;
    }

    public List<Object> getEntityListByEntityClass(Solution_ solution, Class<?> entityClass) {
        ArrayList<Object> entityList = new ArrayList<Object>();
        for (MemberAccessor entityMemberAccessor : this.entityMemberAccessorMap.values()) {
            Object entity;
            if (!entityMemberAccessor.getType().isAssignableFrom(entityClass) || (entity = this.extractMemberObject(entityMemberAccessor, solution)) == null || !entityClass.isInstance(entity)) continue;
            entityList.add(entity);
        }
        for (MemberAccessor entityCollectionMemberAccessor : this.entityCollectionMemberAccessorMap.values()) {
            Collection<Object> entityCollection = this.extractMemberCollection(entityCollectionMemberAccessor, solution);
            for (Object entity : entityCollection) {
                if (!entityClass.isInstance(entity)) continue;
                entityList.add(entity);
            }
        }
        return entityList;
    }

    public long getGenuineVariableCount(Solution_ solution) {
        long variableCount = 0L;
        Iterator<Object> it = this.extractAllEntitiesIterator(solution);
        while (it.hasNext()) {
            Object entity = it.next();
            EntityDescriptor<Solution_> entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
            variableCount += entityDescriptor.getGenuineVariableCount();
        }
        return variableCount;
    }

    public long getMaximumValueCount(Solution_ solution) {
        long maximumValueCount = 0L;
        Iterator<Object> it = this.extractAllEntitiesIterator(solution);
        while (it.hasNext()) {
            Object entity = it.next();
            EntityDescriptor<Solution_> entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
            maximumValueCount = Math.max(maximumValueCount, entityDescriptor.getMaximumValueCount(solution, entity));
        }
        return maximumValueCount;
    }

    public int getValueCount(Solution_ solution) {
        boolean valueCount = false;
        throw new UnsupportedOperationException("getValueCount is not yet supported - this blocks ValueRatioTabuSizeStrategy");
    }

    public long getProblemScale(Solution_ solution) {
        long problemScale = 0L;
        Iterator<Object> it = this.extractAllEntitiesIterator(solution);
        while (it.hasNext()) {
            Object entity = it.next();
            EntityDescriptor<Solution_> entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
            problemScale += entityDescriptor.getProblemScale(solution, entity);
        }
        return problemScale;
    }

    public int countUninitializedVariables(Solution_ solution) {
        int count = 0;
        Iterator<Object> it = this.extractAllEntitiesIterator(solution);
        while (it.hasNext()) {
            Object entity = it.next();
            EntityDescriptor<Solution_> entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
            count += entityDescriptor.countUninitializedVariables(entity);
        }
        return count;
    }

    public int countReinitializableVariables(ScoreDirector<Solution_> scoreDirector, Solution_ solution) {
        int count = 0;
        Iterator<Object> it = this.extractAllEntitiesIterator(solution);
        while (it.hasNext()) {
            Object entity = it.next();
            EntityDescriptor<Solution_> entityDescriptor = this.findEntityDescriptorOrFail(entity.getClass());
            count += entityDescriptor.countReinitializableVariables(scoreDirector, entity);
        }
        return count;
    }

    public Iterator<Object> extractAllEntitiesIterator(Solution_ solution) {
        ArrayList<Iterator<Object>> iteratorList = new ArrayList<Iterator<Object>>(this.entityMemberAccessorMap.size() + this.entityCollectionMemberAccessorMap.size());
        for (MemberAccessor entityMemberAccessor : this.entityMemberAccessorMap.values()) {
            Object entity = this.extractMemberObject(entityMemberAccessor, solution);
            if (entity == null) continue;
            iteratorList.add(Collections.singletonList(entity).iterator());
        }
        for (MemberAccessor entityCollectionMemberAccessor : this.entityCollectionMemberAccessorMap.values()) {
            Collection<Object> entityCollection = this.extractMemberCollection(entityCollectionMemberAccessor, solution);
            iteratorList.add(entityCollection.iterator());
        }
        return Iterators.concat(iteratorList.iterator());
    }

    private Object extractMemberObject(MemberAccessor memberAccessor, Solution_ solution) {
        return memberAccessor.executeGetter(solution);
    }

    private Collection<Object> extractMemberCollection(MemberAccessor collectionMemberAccessor, Solution_ solution, boolean isFact) {
        Collection collection = (Collection)collectionMemberAccessor.executeGetter(solution);
        if (collection == null) {
            throw new IllegalArgumentException("The solutionClass (" + this.solutionClass + ")'s " + (isFact ? "factCollectionProperty" : "entityCollectionProperty") + " (" + collectionMemberAccessor + ") should never return null.");
        }
        return collection;
    }

    private Collection<Object> extractMemberCollection(MemberAccessor collectionMemberAccessor, Solution_ solution) {
        return this.extractMemberCollection(collectionMemberAccessor, solution, false);
    }

    public Score getScore(Solution_ solution) {
        return (Score)this.scoreMemberAccessor.executeGetter(solution);
    }

    public void setScore(Solution_ solution, Score score) {
        this.scoreMemberAccessor.executeSetter(solution, score);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.solutionClass.getName() + ")";
    }
}

