/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools.testgen;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.kie.api.runtime.KieSession;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.holder.ScoreHolder;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.drools.DroolsScoreDirector;
import org.optaplanner.core.impl.score.director.drools.DroolsScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.drools.testgen.TestGenKieSessionJournal;
import org.optaplanner.core.impl.score.director.drools.testgen.TestGenTestWriter;
import org.optaplanner.core.impl.score.director.drools.testgen.TestGenerator;
import org.optaplanner.core.impl.score.director.drools.testgen.reproducer.TestGenCorruptedScoreException;
import org.optaplanner.core.impl.score.director.drools.testgen.reproducer.TestGenCorruptedScoreReproducer;
import org.optaplanner.core.impl.score.director.drools.testgen.reproducer.TestGenDroolsExceptionReproducer;

public class TestGenDroolsScoreDirector<Solution_>
extends DroolsScoreDirector<Solution_> {
    private static final String TEST_CLASS_NAME = "DroolsReproducerTest";
    private final TestGenKieSessionJournal journal = new TestGenKieSessionJournal();
    private final File testFile = new File("DroolsReproducerTest.java");
    private final TestGenTestWriter writer = new TestGenTestWriter();

    public TestGenDroolsScoreDirector(DroolsScoreDirectorFactory<Solution_> scoreDirectorFactory, boolean locatorEnabled, boolean constraintMatchEnabledPreference, List<String> scoreDrlList, List<File> scoreDrlFileList) {
        super(scoreDirectorFactory, locatorEnabled, constraintMatchEnabledPreference);
        this.writer.setClassName(TEST_CLASS_NAME);
        this.writer.setScoreDefinition(scoreDirectorFactory.getScoreDefinition());
        this.writer.setConstraintMatchEnabled(constraintMatchEnabledPreference);
        this.writer.setScoreDrlList(scoreDrlList);
        this.writer.setScoreDrlFileList(scoreDrlFileList);
    }

    public KieSession createKieSession() {
        KieSession newKieSession = ((DroolsScoreDirectorFactory)this.getScoreDirectorFactory()).newKieSession();
        ScoreDefinition scoreDefinition = this.getScoreDefinition();
        if (scoreDefinition != null) {
            ScoreHolder sh = scoreDefinition.buildScoreHolder(this.constraintMatchEnabledPreference);
            newKieSession.setGlobal("scoreHolder", (Object)sh);
        }
        return newKieSession;
    }

    @Override
    public void setWorkingSolution(Solution_ workingSolution) {
        super.setWorkingSolution(workingSolution);
        this.journal.dispose();
        Collection<Object> workingFacts = this.getWorkingFacts();
        this.journal.addFacts(workingFacts);
        for (Object fact : workingFacts) {
            this.journal.insertInitial(fact);
        }
    }

    @Override
    public Score calculateScore() {
        this.journal.fireAllRules();
        try {
            return super.calculateScore();
        }
        catch (RuntimeException e) {
            TestGenDroolsExceptionReproducer reproducer = new TestGenDroolsExceptionReproducer(e, this);
            TestGenKieSessionJournal minJournal = TestGenerator.minimize(this.journal, reproducer);
            this.writer.print(minJournal, this.testFile);
            throw this.wrapOriginalException(e);
        }
    }

    @Override
    public void assertWorkingScoreFromScratch(Score workingScore, Object completedAction) {
        try {
            super.assertWorkingScoreFromScratch(workingScore, completedAction);
        }
        catch (IllegalStateException e) {
            TestGenCorruptedScoreReproducer reproducer = new TestGenCorruptedScoreReproducer(e.getMessage(), this);
            TestGenKieSessionJournal minJournal = TestGenerator.minimize(this.journal, reproducer);
            try {
                minJournal.replay(this.createKieSession());
                throw new IllegalStateException();
            }
            catch (TestGenCorruptedScoreException tgcse) {
                this.writer.setCorruptedScoreException(tgcse);
                this.writer.print(minJournal, this.testFile);
                throw this.wrapOriginalException(e);
            }
        }
    }

    @Override
    public Collection<ConstraintMatchTotal> getConstraintMatchTotals() {
        this.journal.fireAllRules();
        return super.getConstraintMatchTotals();
    }

    @Override
    public void dispose() {
        this.journal.dispose();
        super.dispose();
    }

    @Override
    public void afterEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.journal.insert(entity);
        super.afterEntityAdded(entityDescriptor, entity);
    }

    @Override
    public void afterVariableChanged(VariableDescriptor variableDescriptor, Object entity) {
        this.journal.update(entity, variableDescriptor);
        super.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void afterEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.journal.delete(entity);
        super.afterEntityRemoved(entityDescriptor, entity);
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        this.journal.insert(problemFact);
        super.afterProblemFactAdded(problemFact);
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        this.journal.delete(problemFact);
        super.afterProblemFactRemoved(problemFact);
    }

    private RuntimeException wrapOriginalException(RuntimeException e) {
        return new RuntimeException(e.getMessage() + "\nDrools test written to: " + this.testFile.getAbsolutePath(), e);
    }
}

