/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools.testgen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.kie.api.runtime.KieSession;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.score.director.drools.testgen.TestGenKieSessionEventSupport;
import org.optaplanner.core.impl.score.director.drools.testgen.TestGenKieSessionListener;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenFact;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenNullFact;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenValueFact;
import org.optaplanner.core.impl.score.director.drools.testgen.operation.TestGenKieSessionDelete;
import org.optaplanner.core.impl.score.director.drools.testgen.operation.TestGenKieSessionFireAllRules;
import org.optaplanner.core.impl.score.director.drools.testgen.operation.TestGenKieSessionInsert;
import org.optaplanner.core.impl.score.director.drools.testgen.operation.TestGenKieSessionOperation;
import org.optaplanner.core.impl.score.director.drools.testgen.operation.TestGenKieSessionUpdate;

public class TestGenKieSessionJournal {
    private final TestGenKieSessionEventSupport eventSupport = new TestGenKieSessionEventSupport();
    private final HashMap<Object, TestGenFact> existingInstances = new HashMap();
    private final List<TestGenFact> facts;
    private final List<TestGenKieSessionInsert> initialInsertJournal;
    private final List<TestGenKieSessionOperation> updateJournal;
    private int operationId = 0;

    public TestGenKieSessionJournal() {
        this.facts = new ArrayList<TestGenFact>();
        this.initialInsertJournal = new ArrayList<TestGenKieSessionInsert>();
        this.updateJournal = new ArrayList<TestGenKieSessionOperation>();
    }

    public TestGenKieSessionJournal(List<TestGenFact> facts, List<TestGenKieSessionInsert> initialInsertJournal, List<TestGenKieSessionOperation> updateJournal) {
        this.facts = facts;
        this.initialInsertJournal = initialInsertJournal;
        this.updateJournal = updateJournal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replay(KieSession replayKieSession) {
        for (TestGenFact testGenFact : this.facts) {
            testGenFact.reset();
        }
        for (TestGenKieSessionOperation testGenKieSessionOperation : this.initialInsertJournal) {
            testGenKieSessionOperation.invoke(replayKieSession);
        }
        try {
            for (TestGenKieSessionOperation testGenKieSessionOperation : this.updateJournal) {
                testGenKieSessionOperation.invoke(replayKieSession);
                if (!testGenKieSessionOperation.getClass().equals(TestGenKieSessionFireAllRules.class)) continue;
                this.eventSupport.afterFireAllRules(replayKieSession, this);
            }
        }
        finally {
            replayKieSession.dispose();
        }
    }

    public void addFacts(Collection<Object> workingFacts) {
        int i = 0;
        for (Object instance : workingFacts) {
            TestGenValueFact fact = new TestGenValueFact(i++, instance);
            this.facts.add(fact);
            this.existingInstances.put(instance, fact);
        }
        for (TestGenFact fact : this.facts) {
            fact.setUp(this.existingInstances);
        }
    }

    public void insertInitial(Object fact) {
        this.initialInsertJournal.add(new TestGenKieSessionInsert(this.operationId++, this.existingInstances.get(fact)));
    }

    public void insert(Object fact) {
        this.updateJournal.add(new TestGenKieSessionInsert(this.operationId++, this.existingInstances.get(fact)));
    }

    public void update(Object entity, VariableDescriptor<?> variableDescriptor) {
        TestGenFact entityFact = this.existingInstances.get(entity);
        Object value = variableDescriptor.getValue(entity);
        TestGenNullFact valueFact = value == null ? new TestGenNullFact() : this.existingInstances.get(value);
        this.updateJournal.add(new TestGenKieSessionUpdate(this.operationId++, entityFact, variableDescriptor, valueFact));
    }

    public void delete(Object entity) {
        this.updateJournal.add(new TestGenKieSessionDelete(this.operationId++, this.existingInstances.get(entity)));
    }

    public void fireAllRules() {
        this.updateJournal.add(new TestGenKieSessionFireAllRules(this.operationId++));
    }

    public void dispose() {
        this.facts.clear();
        this.existingInstances.clear();
        this.initialInsertJournal.clear();
        this.updateJournal.clear();
        this.operationId = 0;
    }

    public void addListener(TestGenKieSessionListener listener) {
        this.eventSupport.addEventListener(listener);
    }

    public void removeListener(TestGenKieSessionListener listener) {
        this.eventSupport.removeEventListener(listener);
    }

    public List<TestGenFact> getFacts() {
        return this.facts;
    }

    public List<TestGenKieSessionInsert> getInitialInserts() {
        return this.initialInsertJournal;
    }

    public List<TestGenKieSessionOperation> getMoveOperations() {
        return this.updateJournal;
    }
}

