/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools.testgen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.optaplanner.core.api.score.holder.ScoreHolder;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.drools.testgen.TestGenKieSessionJournal;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenFact;
import org.optaplanner.core.impl.score.director.drools.testgen.operation.TestGenKieSessionOperation;
import org.optaplanner.core.impl.score.director.drools.testgen.reproducer.TestGenCorruptedScoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TestGenTestWriter {
    private static final Logger logger = LoggerFactory.getLogger(TestGenTestWriter.class);
    private StringBuilder sb;
    private TestGenKieSessionJournal journal;
    private String className;
    private List<String> scoreDrlList = Collections.emptyList();
    private List<File> scoreDrlFileList = Collections.emptyList();
    private ScoreDefinition<?> scoreDefinition;
    private boolean constraintMatchEnabled;
    private TestGenCorruptedScoreException scoreEx;

    TestGenTestWriter() {
    }

    public void print(TestGenKieSessionJournal journal, Writer w) {
        this.print(journal);
        this.writeTest(w);
    }

    public void print(TestGenKieSessionJournal journal, File testFile) {
        this.print(journal);
        this.writeTestFile(testFile);
    }

    private void print(TestGenKieSessionJournal journal) {
        this.journal = journal;
        this.sb = new StringBuilder(32768);
        this.printInit();
        this.printSetup();
        this.printTest();
    }

    private void printInit() {
        this.sb.append("package org.optaplanner.testgen;\n\n");
        TreeSet<String> imports = new TreeSet<String>();
        imports.add("org.junit.Before");
        imports.add("org.junit.Test");
        imports.add("org.kie.api.KieServices");
        imports.add("org.kie.api.builder.KieFileSystem");
        imports.add("org.kie.api.runtime.KieContainer");
        imports.add("org.kie.api.runtime.KieSession");
        if (!this.scoreDrlFileList.isEmpty()) {
            imports.add("java.io.File");
        }
        if (this.scoreDefinition != null) {
            imports.add("org.junit.Assert");
            imports.add(ScoreHolder.class.getCanonicalName());
            imports.add(this.scoreDefinition.getClass().getCanonicalName());
        }
        for (TestGenFact fact : this.journal.getFacts()) {
            for (Class<?> cls : fact.getImports()) {
                String pkgName = cls.getPackage().getName();
                if (pkgName.equals("java.lang")) continue;
                imports.add(cls.getCanonicalName());
            }
        }
        for (String cls : imports) {
            this.sb.append(String.format("import %s;\n", cls));
        }
        this.sb.append("\n").append("public class ").append(this.className).append(" {\n\n").append("    KieContainer kieContainer;\n").append("    KieSession kieSession;\n");
        if (this.scoreDefinition != null) {
            this.sb.append(String.format("    ScoreHolder scoreHolder = new %s().buildScoreHolder(%s);\n", this.scoreDefinition.getClass().getSimpleName(), this.constraintMatchEnabled));
        }
        for (TestGenFact fact : this.journal.getFacts()) {
            fact.printInitialization(this.sb);
        }
        this.sb.append("\n");
    }

    private void printSetup() {
        this.sb.append("    @Before\n").append("    public void setUp() {\n").append("        KieServices kieServices = KieServices.Factory.get();\n").append("        KieFileSystem kfs = kieServices.newKieFileSystem();\n");
        this.scoreDrlFileList.forEach(file -> this.sb.append("        kfs.write(kieServices.getResources()\n").append("                .newFileSystemResource(new File(\"").append(file.getAbsoluteFile()).append("\"), \"UTF-8\"));\n"));
        this.scoreDrlList.forEach(drl -> this.sb.append("        kfs.write(kieServices.getResources()\n").append("                .newClassPathResource(\"").append((String)drl).append("\"));\n"));
        this.sb.append("        kieServices.newKieBuilder(kfs).buildAll();\n").append("        kieContainer = kieServices.newKieContainer(kieServices.getRepository().getDefaultReleaseId());\n").append("        kieSession = kieContainer.newKieSession();\n\n");
        if (this.scoreDefinition != null) {
            this.sb.append("        kieSession.setGlobal(\"").append("scoreHolder").append("\", scoreHolder);\n\n");
        }
        for (TestGenFact testGenFact : this.journal.getFacts()) {
            testGenFact.printSetup(this.sb);
        }
        this.sb.append("\n");
        for (TestGenKieSessionOperation testGenKieSessionOperation : this.journal.getInitialInserts()) {
            testGenKieSessionOperation.print(this.sb);
        }
        this.sb.append("    }\n\n");
    }

    private void printTest() {
        this.sb.append("    @Test\n").append("    public void test() {\n");
        for (TestGenKieSessionOperation testGenKieSessionOperation : this.journal.getMoveOperations()) {
            testGenKieSessionOperation.print(this.sb);
        }
        if (this.scoreEx != null) {
            this.sb.append("        // This is the corrupted score, just to make sure the bug is reproducible\n").append("        Assert.assertEquals(\"").append(this.scoreEx.getWorkingScore()).append("\", scoreHolder.extractScore(0).toString());\n");
            this.sb.append("        kieSession = kieContainer.newKieSession();\n").append("        scoreHolder = new ").append(this.scoreDefinition.getClass().getSimpleName()).append("().buildScoreHolder(").append(this.constraintMatchEnabled).append(");\n").append("        kieSession.setGlobal(\"").append("scoreHolder").append("\", scoreHolder);\n");
            this.sb.append("\n\n        // Insert everything into a fresh session to see the uncorrupted score\n");
            for (TestGenKieSessionOperation testGenKieSessionOperation : this.journal.getInitialInserts()) {
                testGenKieSessionOperation.print(this.sb);
            }
            this.sb.append("        kieSession.fireAllRules();\n").append("        Assert.assertEquals(\"").append(this.scoreEx.getUncorruptedScore()).append("\", scoreHolder.extractScore(0).toString());\n");
        }
        this.sb.append("    }\n").append("}\n");
    }

    private void writeTestFile(File file) {
        OutputStreamWriter osw;
        FileOutputStream fos;
        File parent = file.getAbsoluteFile().getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            logger.warn("Couldn't create directory: {}", (Object)parent);
        }
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException ex) {
            logger.error("Cannot open test file: " + file.toString(), (Throwable)ex);
            return;
        }
        try {
            osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ex) {
            logger.error("Can't open", (Throwable)ex);
            return;
        }
        this.writeTest(osw);
    }

    private void writeTest(Writer w) {
        try {
            w.append(this.sb);
        }
        catch (IOException ex) {
            logger.error("Can't write", (Throwable)ex);
        }
        finally {
            try {
                w.close();
            }
            catch (IOException ex) {
                logger.error("Can't close", (Throwable)ex);
            }
        }
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setScoreDrlList(List<String> scoreDrlList) {
        this.scoreDrlList = scoreDrlList == null ? Collections.emptyList() : scoreDrlList;
    }

    public void setScoreDrlFileList(List<File> scoreDrlFileList) {
        this.scoreDrlFileList = scoreDrlFileList == null ? Collections.emptyList() : scoreDrlFileList;
    }

    public void setScoreDefinition(ScoreDefinition<?> scoreDefinition) {
        this.scoreDefinition = scoreDefinition;
    }

    public void setConstraintMatchEnabled(boolean constraintMatchEnabled) {
        this.constraintMatchEnabled = constraintMatchEnabled;
    }

    public void setCorruptedScoreException(TestGenCorruptedScoreException ex) {
        this.scoreEx = ex;
    }
}

