/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools.testgen.fact;

import java.lang.reflect.Method;
import java.util.List;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.domain.common.accessor.BeanPropertyMemberAccessor;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenFact;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenValueFact;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenValueProvider;

public class TestGenFactField
implements Comparable<TestGenFactField> {
    private final TestGenValueFact fact;
    private final BeanPropertyMemberAccessor accessor;
    private final TestGenValueProvider<?> valueProvider;
    private boolean active = true;

    TestGenFactField(TestGenValueFact fact, BeanPropertyMemberAccessor accessor, TestGenValueProvider<?> valueProvider) {
        this.fact = fact;
        this.accessor = accessor;
        this.valueProvider = valueProvider;
    }

    void reset() {
        Object value = this.active ? this.valueProvider.get() : this.valueProvider.getUninitialized();
        this.accessor.executeSetter(this.fact.getInstance(), value);
    }

    public List<Class<?>> getImports() {
        return this.valueProvider.getImports();
    }

    public List<TestGenFact> getRequiredFacts() {
        return this.valueProvider.getRequiredFacts();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    void print(StringBuilder sb) {
        if (this.active) {
            Method setter = ReflectionHelper.getSetterMethod(this.fact.getInstance().getClass(), this.accessor.getType(), this.accessor.getName());
            this.valueProvider.printSetup(sb);
            if (this.valueProvider.get() != null) {
                sb.append(String.format("        %s.%s(%s);\n", this.fact.getVariableName(), setter.getName(), this.valueProvider.toString()));
            }
        }
    }

    @Override
    public int compareTo(TestGenFactField o) {
        return this.accessor.getName().compareTo(o.accessor.getName());
    }
}

