/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLTypeLoader;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.ss.usermodel.Table;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.Internal;
import org.apache.poi.util.StringUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.helpers.XSSFXmlColumnPr;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTable;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableColumn;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.TableDocument;

public class XSSFTable
extends POIXMLDocumentPart
implements Table {
    private CTTable ctTable;
    private List<XSSFXmlColumnPr> xmlColumnPr;
    private CTTableColumn[] ctColumns;
    private HashMap<String, Integer> columnMap;
    private CellReference startCellReference;
    private CellReference endCellReference;
    private String commonXPath;

    public XSSFTable() {
        this.ctTable = CTTable.Factory.newInstance();
    }

    public XSSFTable(PackagePart part) throws IOException {
        super(part);
        this.readFrom(part.getInputStream());
    }

    @Deprecated
    public XSSFTable(PackagePart part, PackageRelationship rel) throws IOException {
        this(part);
    }

    public void readFrom(InputStream is) throws IOException {
        try {
            TableDocument doc = TableDocument.Factory.parse((InputStream)is, (XmlOptions)POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
            this.ctTable = doc.getTable();
        }
        catch (XmlException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public XSSFSheet getXSSFSheet() {
        return (XSSFSheet)this.getParent();
    }

    public void writeTo(OutputStream out) throws IOException {
        this.updateHeaders();
        TableDocument doc = TableDocument.Factory.newInstance();
        doc.setTable(this.ctTable);
        doc.save(out, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
    }

    @Override
    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.writeTo(out);
        out.close();
    }

    @Internal(since="POI 3.15 beta 3")
    public CTTable getCTTable() {
        return this.ctTable;
    }

    public boolean mapsTo(long id) {
        List<XSSFXmlColumnPr> pointers = this.getXmlColumnPrs();
        for (XSSFXmlColumnPr pointer : pointers) {
            if (pointer.getMapId() != id) continue;
            return true;
        }
        return false;
    }

    private CTTableColumn[] getTableColumns() {
        if (this.ctColumns == null) {
            this.ctColumns = this.ctTable.getTableColumns().getTableColumnArray();
        }
        return this.ctColumns;
    }

    public String getCommonXpath() {
        if (this.commonXPath == null) {
            Object[] commonTokens = new String[]{};
            block0: for (CTTableColumn column : this.getTableColumns()) {
                if (column.getXmlColumnPr() == null) continue;
                String xpath = column.getXmlColumnPr().getXpath();
                String[] tokens = xpath.split("/");
                if (commonTokens.length == 0) {
                    commonTokens = tokens;
                    continue;
                }
                int maxLength = Math.min(commonTokens.length, tokens.length);
                for (int i = 0; i < maxLength; ++i) {
                    if (((String)commonTokens[i]).equals(tokens[i])) continue;
                    List<Object> subCommonTokens = Arrays.asList(commonTokens).subList(0, i);
                    String[] container = new String[]{};
                    commonTokens = subCommonTokens.toArray(container);
                    continue block0;
                }
            }
            commonTokens[0] = "";
            this.commonXPath = StringUtil.join((Object[])commonTokens, (String)"/");
        }
        return this.commonXPath;
    }

    public List<XSSFXmlColumnPr> getXmlColumnPrs() {
        if (this.xmlColumnPr == null) {
            this.xmlColumnPr = new ArrayList<XSSFXmlColumnPr>();
            for (CTTableColumn column : this.getTableColumns()) {
                if (column.getXmlColumnPr() == null) continue;
                XSSFXmlColumnPr columnPr = new XSSFXmlColumnPr(this, column, column.getXmlColumnPr());
                this.xmlColumnPr.add(columnPr);
            }
        }
        return this.xmlColumnPr;
    }

    public String getName() {
        return this.ctTable.getName();
    }

    public void setName(String name) {
        if (name == null) {
            this.ctTable.unsetName();
            return;
        }
        this.ctTable.setName(name);
    }

    public String getDisplayName() {
        return this.ctTable.getDisplayName();
    }

    public void setDisplayName(String name) {
        this.ctTable.setDisplayName(name);
    }

    public long getNumberOfMappedColumns() {
        return this.ctTable.getTableColumns().getCount();
    }

    public long getNumerOfMappedColumns() {
        return this.getNumberOfMappedColumns();
    }

    public CellReference getStartCellReference() {
        if (this.startCellReference == null) {
            this.setCellReferences();
        }
        return this.startCellReference;
    }

    public CellReference getEndCellReference() {
        if (this.endCellReference == null) {
            this.setCellReferences();
        }
        return this.endCellReference;
    }

    private void setCellReferences() {
        String ref = this.ctTable.getRef();
        if (ref != null) {
            String[] boundaries = ref.split(":", 2);
            String from = boundaries[0];
            String to = boundaries[1];
            this.startCellReference = new CellReference(from);
            this.endCellReference = new CellReference(to);
        }
    }

    public void updateReferences() {
        this.startCellReference = null;
        this.endCellReference = null;
    }

    public int getRowCount() {
        CellReference from = this.getStartCellReference();
        CellReference to = this.getEndCellReference();
        int rowCount = 0;
        if (from != null && to != null) {
            rowCount = to.getRow() - from.getRow() + 1;
        }
        return rowCount;
    }

    public void updateHeaders() {
        XSSFSheet sheet = (XSSFSheet)this.getParent();
        CellReference ref = this.getStartCellReference();
        if (ref == null) {
            return;
        }
        int headerRow = ref.getRow();
        int firstHeaderColumn = ref.getCol();
        XSSFRow row = sheet.getRow(headerRow);
        if (row != null && row.getCTRow().validate()) {
            int cellnum = firstHeaderColumn;
            for (CTTableColumn col : this.getCTTable().getTableColumns().getTableColumnArray()) {
                XSSFCell cell = row.getCell(cellnum);
                if (cell != null) {
                    col.setName(cell.getStringCellValue());
                }
                ++cellnum;
            }
            this.ctColumns = null;
            this.columnMap = null;
            this.xmlColumnPr = null;
            this.commonXPath = null;
        }
    }

    private static String caseInsensitive(String s) {
        return s.toUpperCase(Locale.ROOT);
    }

    public int findColumnIndex(String columnHeader) {
        Integer idx;
        if (columnHeader == null) {
            return -1;
        }
        if (this.columnMap == null) {
            int count = this.getTableColumns().length;
            this.columnMap = new HashMap(count * 3 / 2);
            int i = 0;
            for (CTTableColumn column : this.getTableColumns()) {
                String columnName = column.getName();
                this.columnMap.put(XSSFTable.caseInsensitive(columnName), i);
                ++i;
            }
        }
        return (idx = this.columnMap.get(XSSFTable.caseInsensitive(columnHeader.replace("'", "")))) == null ? -1 : idx;
    }

    public String getSheetName() {
        return this.getXSSFSheet().getSheetName();
    }

    public boolean isHasTotalsRow() {
        return this.ctTable.getTotalsRowShown();
    }

    public int getStartColIndex() {
        return this.getStartCellReference().getCol();
    }

    public int getStartRowIndex() {
        return this.getStartCellReference().getRow();
    }

    public int getEndColIndex() {
        return this.getEndCellReference().getCol();
    }

    public int getEndRowIndex() {
        return this.getEndCellReference().getRow();
    }
}

