/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.solver.move;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.nurserostering.domain.Employee;
import org.optaplanner.examples.nurserostering.domain.NurseRoster;
import org.optaplanner.examples.nurserostering.domain.ShiftAssignment;
import org.optaplanner.examples.nurserostering.solver.move.NurseRosteringMoveHelper;

public class EmployeeChangeMove
extends AbstractMove<NurseRoster> {
    private ShiftAssignment shiftAssignment;
    private Employee toEmployee;

    public EmployeeChangeMove(ShiftAssignment shiftAssignment, Employee toEmployee) {
        this.shiftAssignment = shiftAssignment;
        this.toEmployee = toEmployee;
    }

    public boolean isMoveDoable(ScoreDirector<NurseRoster> scoreDirector) {
        return !Objects.equals(this.shiftAssignment.getEmployee(), this.toEmployee);
    }

    public EmployeeChangeMove createUndoMove(ScoreDirector<NurseRoster> scoreDirector) {
        return new EmployeeChangeMove(this.shiftAssignment, this.shiftAssignment.getEmployee());
    }

    protected void doMoveOnGenuineVariables(ScoreDirector<NurseRoster> scoreDirector) {
        NurseRosteringMoveHelper.moveEmployee(scoreDirector, this.shiftAssignment, this.toEmployee);
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.shiftAssignment);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toEmployee);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof EmployeeChangeMove) {
            EmployeeChangeMove other = (EmployeeChangeMove)((Object)o);
            return new EqualsBuilder().append((Object)this.shiftAssignment, (Object)other.shiftAssignment).append((Object)this.toEmployee, (Object)other.toEmployee).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.shiftAssignment).append((Object)this.toEmployee).toHashCode();
    }

    public String toString() {
        return this.shiftAssignment + " {" + this.shiftAssignment.getEmployee() + " -> " + this.toEmployee + "}";
    }
}

