/*
 * Decompiled with CFR 0.152.
 */
package org.kie.test.util.compare;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComparePair {
    private static final Logger logger = LoggerFactory.getLogger(ComparePair.class);
    private Object orig;
    private Object copy;
    private Class<?> objInterface;
    private String[] nullFields = null;
    private boolean useGetMethods = true;

    public static void compareOrig(Object origObj, Object newObj, Class objClass) {
        ComparePair compare = new ComparePair(origObj, newObj, objClass);
        LinkedList<ComparePair> compares = new LinkedList<ComparePair>();
        compares.add(compare);
        while (!compares.isEmpty()) {
            compares.addAll(((ComparePair)compares.poll()).compare());
        }
    }

    public ComparePair(Object a, Object b, Class<?> c) {
        this.orig = a;
        this.copy = b;
        this.objInterface = c;
    }

    public ComparePair(Object a, Object b) {
        this(a, b, a.getClass());
    }

    public List<ComparePair> compare() {
        if (this.useGetMethods) {
            return this.compareObjectsViaGetMethods(this.orig, this.copy, this.objInterface);
        }
        ComparePair.compareObjectsViaFields(this.orig, this.copy, this.nullFields);
        return null;
    }

    public ComparePair useFields() {
        this.useGetMethods = false;
        return this;
    }

    public void recursiveCompare() {
        LinkedList<ComparePair> compares = new LinkedList<ComparePair>();
        compares.add(this);
        while (!compares.isEmpty()) {
            compares.addAll(((ComparePair)compares.poll()).compare());
        }
    }

    public ComparePair addNullFields(String ... fieldNames) {
        int i;
        if (fieldNames == null) {
            return this;
        }
        if (this.nullFields == null) {
            this.nullFields = new String[0];
        }
        String[] newNullFields = new String[this.nullFields.length + fieldNames.length];
        for (i = 0; i < this.nullFields.length; ++i) {
            newNullFields[i] = this.nullFields[i];
        }
        for (i = 0; i < fieldNames.length; ++i) {
            newNullFields[i + this.nullFields.length] = fieldNames[i];
        }
        this.nullFields = newNullFields;
        return this;
    }

    private List<ComparePair> compareObjectsViaGetMethods(Object orig, Object copy, Class<?> objInterface) {
        ArrayList<ComparePair> cantCompare = new ArrayList<ComparePair>();
        for (Method getIsMethod : objInterface.getDeclaredMethods()) {
            String fieldName;
            String methodName = getIsMethod.getName();
            if (methodName.startsWith("get")) {
                fieldName = methodName.substring(3);
            } else {
                if (!methodName.startsWith("is")) continue;
                fieldName = methodName.substring(2);
            }
            fieldName = fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
            try {
                Object origField = getIsMethod.invoke(orig, new Object[0]);
                Object copyField = getIsMethod.invoke(copy, new Object[0]);
                boolean skip = false;
                if (origField == null) {
                    if (this.nullFields != null) {
                        for (String nullField : this.nullFields) {
                            if (!fieldName.equals(nullField)) continue;
                            skip = true;
                            break;
                        }
                    }
                    if (!skip) {
                        Assert.fail((String)("Please fill in the " + fieldName + " field in the " + objInterface.getSimpleName() + "!"));
                    }
                }
                if (skip) continue;
                if (origField != null && !(origField instanceof Enum) && origField.getClass().getPackage().getName().startsWith("org.")) {
                    ComparePair newComPair = new ComparePair(origField, copyField, this.getInterface(origField));
                    newComPair.addNullFields(this.nullFields);
                    cantCompare.add(newComPair);
                    continue;
                }
                if (origField instanceof List) {
                    List origList = (List)origField;
                    List copyList = (List)copyField;
                    for (int i = 0; i < origList.size(); ++i) {
                        Class<?> newInterface = origField.getClass();
                        while (newInterface.getInterfaces().length > 0) {
                            newInterface = newInterface.getInterfaces()[0];
                        }
                        ComparePair newCompair = new ComparePair(origList.get(i), copyList.get(i), this.getInterface(origList.get(i)));
                        newCompair.addNullFields(this.nullFields);
                        cantCompare.add(newCompair);
                    }
                    continue;
                }
                Assert.assertEquals((String)fieldName, (Object)origField, (Object)copyField);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to compare " + fieldName, e);
            }
        }
        return cantCompare;
    }

    private Class<?> getInterface(Object obj) {
        Class<?> newInterface;
        Class<?> parent = newInterface = obj.getClass();
        while (parent != null) {
            Class<?> newParent;
            parent = null;
            if (newInterface.getInterfaces().length <= 0 || !(newParent = newInterface.getInterfaces()[0]).getPackage().getName().startsWith("org.")) continue;
            parent = newInterface = newParent;
        }
        return newInterface;
    }

    public static void compareObjectsViaFields(Object orig, Object copy) {
        String name = orig == null ? "null" : orig.getClass().getSimpleName();
        ComparePair.compareValues(orig, copy, name, new String[0]);
    }

    public static void compareObjectsViaFields(Object orig, Object copy, String ... skipFields) {
        if (orig == copy) {
            return;
        }
        if (copy == null) {
            Assert.fail((String)("Copy " + orig.getClass().getSimpleName() + " is null!"));
        } else if (orig == null) {
            Assert.fail((String)("Original " + copy.getClass().getSimpleName() + " is null!"));
        }
        Class<?> origClass = orig.getClass();
        String origClassName = origClass.getSimpleName();
        Class<?> copyClass = copy.getClass();
        Assert.assertEquals((String)("copy is an instance of " + copyClass.getSimpleName() + " ( instead of " + origClassName + ")"), origClass, copy.getClass());
        for (Field field : orig.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                Object origFieldVal = field.get(orig);
                Object copyFieldVal = field.get(copy);
                String fieldName = field.getName();
                boolean skip = false;
                for (String skipFieldName : skipFields) {
                    if (!skipFieldName.matches(fieldName)) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                boolean nullFound = false;
                if (origFieldVal == null || copyFieldVal == null) {
                    nullFound = true;
                    String[] stringArray = skipFields;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String nullFieldName;
                        String actualNullFieldName = nullFieldName = stringArray[i];
                        if (nullFieldName.contains(".")) {
                            int dotIndex = nullFieldName.indexOf(".");
                            if (!nullFieldName.substring(0, dotIndex).equals(origClassName)) continue;
                            actualNullFieldName = nullFieldName.substring(dotIndex + 1);
                        }
                        if (!nullFound || !actualNullFieldName.matches(fieldName)) continue;
                        nullFound = false;
                    }
                }
                String objectFieldName = origClass.getSimpleName() + "." + field.getName();
                Assert.assertFalse((String)(objectFieldName + "!"), (boolean)nullFound);
                if (copyFieldVal == origFieldVal) continue;
                ComparePair.compareValues(origFieldVal, copyFieldVal, objectFieldName, skipFields);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to access " + field.getName() + " when testing " + origClass.getSimpleName() + ".", e);
            }
        }
    }

    private static void compareValues(Object origFieldVal, Object copyFieldVal, String objectFieldName, String[] skipFields) {
        Assert.assertNotNull((String)(objectFieldName + " is null in the copy!"), (Object)copyFieldVal);
        Assert.assertNotNull((String)(objectFieldName + " is null in the original!"), (Object)origFieldVal);
        Package pkg = origFieldVal.getClass().getPackage();
        if (pkg == null || pkg.getName().startsWith("java.")) {
            if (origFieldVal.getClass().isArray()) {
                if (origFieldVal instanceof byte[]) {
                    Assert.assertArrayEquals((String)objectFieldName, (byte[])((byte[])origFieldVal), (byte[])((byte[])copyFieldVal));
                }
            } else if (origFieldVal instanceof Map && copyFieldVal instanceof Map) {
                Collection shouldBeEmpty = CollectionUtils.disjunction(((Map)origFieldVal).values(), ((Map)copyFieldVal).values());
                Assert.assertTrue((String)("Comparison of Map values failed on " + objectFieldName), (boolean)shouldBeEmpty.isEmpty());
            } else if (origFieldVal instanceof Collection) {
                Assert.assertEquals((String)("Different collection sizes on " + objectFieldName), (long)((Collection)origFieldVal).size(), (long)((Collection)copyFieldVal).size());
                for (Object elem : (Collection)origFieldVal) {
                    boolean match = false;
                    for (Object copyElem : (Collection)copyFieldVal) {
                        try {
                            ComparePair.compareObjectsViaFields(elem, copyElem, skipFields);
                            match = true;
                            break;
                        }
                        catch (Throwable t) {
                            logger.debug(t.getMessage());
                        }
                    }
                    Assert.assertTrue((String)("Different collection values on " + objectFieldName), (boolean)match);
                }
            } else {
                Assert.assertEquals((String)objectFieldName, (Object)origFieldVal, (Object)copyFieldVal);
            }
        }
    }

    public static interface FieldComparator<T> {
        public void compare(T var1, T var2);
    }
}

