/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.constraint;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;

public class ConstraintMatchTotal
implements Serializable,
Comparable<ConstraintMatchTotal> {
    protected final String constraintPackage;
    protected final String constraintName;
    protected final Set<ConstraintMatch> constraintMatchSet;
    protected Score scoreTotal;

    public ConstraintMatchTotal(String constraintPackage, String constraintName, Score zeroScore) {
        this.constraintPackage = constraintPackage;
        this.constraintName = constraintName;
        this.constraintMatchSet = new LinkedHashSet<ConstraintMatch>();
        this.scoreTotal = zeroScore;
    }

    public String getConstraintPackage() {
        return this.constraintPackage;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public Set<ConstraintMatch> getConstraintMatchSet() {
        return this.constraintMatchSet;
    }

    public int getConstraintMatchCount() {
        return this.getConstraintMatchSet().size();
    }

    public Score getScoreTotal() {
        return this.scoreTotal;
    }

    public ConstraintMatch addConstraintMatch(RuleContext kcontext, Score score) {
        List<Object> justificationList = this.extractJustificationList(kcontext);
        return this.addConstraintMatch(justificationList, score);
    }

    public ConstraintMatch addConstraintMatch(List<Object> justificationList, Score score) {
        this.scoreTotal = this.scoreTotal.add(score);
        ConstraintMatch constraintMatch = new ConstraintMatch(this.constraintPackage, this.constraintName, justificationList, score);
        boolean added = this.constraintMatchSet.add(constraintMatch);
        if (!added) {
            throw new IllegalStateException("The constraintMatchTotal (" + this + ") could not add constraintMatch (" + constraintMatch + ") to its constraintMatchSet (" + this.constraintMatchSet + ").");
        }
        return constraintMatch;
    }

    public void removeConstraintMatch(ConstraintMatch constraintMatch) {
        this.scoreTotal = this.scoreTotal.subtract(constraintMatch.getScore());
        boolean removed = this.constraintMatchSet.remove(constraintMatch);
        if (!removed) {
            throw new IllegalStateException("The constraintMatchTotal (" + this + ") could not remove constraintMatch (" + constraintMatch + ") from its constraintMatchSet (" + this.constraintMatchSet + ").");
        }
    }

    protected List<Object> extractJustificationList(RuleContext kcontext) {
        List droolsMatchObjects = kcontext.getMatch().getObjects();
        return Lists.reverse((List)droolsMatchObjects);
    }

    public String getConstraintId() {
        return this.constraintPackage + "/" + this.constraintName;
    }

    @Override
    public int compareTo(ConstraintMatchTotal other) {
        return new CompareToBuilder().append((Object)this.getConstraintPackage(), (Object)other.getConstraintPackage()).append((Object)this.getConstraintName(), (Object)other.getConstraintName()).append((Object)this.getScoreTotal(), (Object)other.getScoreTotal()).toComparison();
    }

    public String toString() {
        return this.getConstraintId() + "=" + this.getScoreTotal();
    }
}

