/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.holder;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.drools.core.common.AgendaItem;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.Match;
import org.kie.api.runtime.rule.RuleContext;
import org.kie.api.runtime.rule.RuleRuntime;
import org.kie.internal.event.rule.ActivationUnMatchListener;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.holder.ScoreHolder;

public abstract class AbstractScoreHolder
implements ScoreHolder,
Serializable {
    protected final boolean constraintMatchEnabled;
    protected final Map<String, ConstraintMatchTotal> constraintMatchTotalMap;
    protected final Score zeroScore;

    protected AbstractScoreHolder(boolean constraintMatchEnabled, Score zeroScore) {
        this.constraintMatchEnabled = constraintMatchEnabled;
        this.constraintMatchTotalMap = constraintMatchEnabled ? new LinkedHashMap() : null;
        this.zeroScore = zeroScore;
    }

    @Override
    public boolean isConstraintMatchEnabled() {
        return this.constraintMatchEnabled;
    }

    @Override
    public Collection<ConstraintMatchTotal> getConstraintMatchTotals() {
        if (!this.isConstraintMatchEnabled()) {
            throw new IllegalStateException("When constraintMatchEnabled (" + this.isConstraintMatchEnabled() + ") is disabled in the constructor, this method should not be called.");
        }
        return this.constraintMatchTotalMap.values();
    }

    protected void registerConstraintMatch(RuleContext kcontext, Runnable constraintUndoListener, Supplier<Score> scoreSupplier) {
        ConstraintActivationUnMatchListener constraintActivationUnMatchListener;
        AgendaItem agendaItem = (AgendaItem)kcontext.getMatch();
        ActivationUnMatchListener activationUnMatchListener = agendaItem.getActivationUnMatchListener();
        if (activationUnMatchListener == null) {
            constraintActivationUnMatchListener = new ConstraintActivationUnMatchListener(constraintUndoListener);
            if (this.constraintMatchEnabled) {
                constraintActivationUnMatchListener.constraintMatchTotal = this.findConstraintMatchTotal(kcontext);
            }
            agendaItem.setActivationUnMatchListener((ActivationUnMatchListener)constraintActivationUnMatchListener);
        } else {
            constraintActivationUnMatchListener = (ConstraintActivationUnMatchListener)activationUnMatchListener;
            constraintActivationUnMatchListener.overwriteMatch(constraintUndoListener);
        }
        if (this.constraintMatchEnabled) {
            constraintActivationUnMatchListener.constraintMatch = constraintActivationUnMatchListener.constraintMatchTotal.addConstraintMatch(kcontext, scoreSupplier.get());
        }
    }

    private ConstraintMatchTotal findConstraintMatchTotal(RuleContext kcontext) {
        Rule rule = kcontext.getRule();
        String constraintPackage = rule.getPackageName();
        String constraintName = rule.getName();
        String constraintId = constraintPackage + "/" + constraintName;
        return this.constraintMatchTotalMap.computeIfAbsent(constraintId, k -> new ConstraintMatchTotal(constraintPackage, constraintName, this.zeroScore));
    }

    private class ConstraintActivationUnMatchListener
    implements ActivationUnMatchListener {
        private Runnable constraintUndoListener;
        private ConstraintMatchTotal constraintMatchTotal;
        private ConstraintMatch constraintMatch;

        public ConstraintActivationUnMatchListener(Runnable constraintUndoListener) {
            this.constraintUndoListener = constraintUndoListener;
        }

        public final void unMatch(RuleRuntime ruleRuntime, Match match) {
            this.unMatch();
            this.constraintUndoListener = null;
        }

        public void overwriteMatch(Runnable constraintUndoListener) {
            if (this.constraintUndoListener != null) {
                this.unMatch();
            }
            this.constraintUndoListener = constraintUndoListener;
        }

        public final void unMatch() {
            this.constraintUndoListener.run();
            if (AbstractScoreHolder.this.constraintMatchEnabled) {
                this.constraintMatchTotal.removeConstraintMatch(this.constraintMatch);
            }
        }
    }
}

