/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.swingui;

import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.examples.common.business.SolutionBusiness;
import org.optaplanner.examples.common.swingui.SolverAndPersistenceFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SolutionPanel<Solution_>
extends JPanel
implements Scrollable {
    protected static final String USAGE_EXPLANATION_PATH = "/org/optaplanner/examples/common/swingui/exampleUsageExplanation.png";
    public static final Dimension PREFERRED_SCROLLABLE_VIEWPORT_SIZE = new Dimension(800, 600);
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SolverAndPersistenceFrame solverAndPersistenceFrame;
    protected SolutionBusiness<Solution_> solutionBusiness;

    public SolverAndPersistenceFrame getSolverAndPersistenceFrame() {
        return this.solverAndPersistenceFrame;
    }

    public void setSolverAndPersistenceFrame(SolverAndPersistenceFrame solverAndPersistenceFrame) {
        this.solverAndPersistenceFrame = solverAndPersistenceFrame;
    }

    public SolutionBusiness<Solution_> getSolutionBusiness() {
        return this.solutionBusiness;
    }

    public void setSolutionBusiness(SolutionBusiness<Solution_> solutionBusiness) {
        this.solutionBusiness = solutionBusiness;
    }

    public String getUsageExplanationPath() {
        return USAGE_EXPLANATION_PATH;
    }

    public boolean isWrapInScrollPane() {
        return true;
    }

    public boolean isRefreshScreenDuringSolving() {
        return true;
    }

    public abstract void resetPanel(Solution_ var1);

    public void updatePanel(Solution_ solution) {
        this.resetPanel(solution);
    }

    public Solution_ getSolution() {
        return this.solutionBusiness.getSolution();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return PREFERRED_SCROLLABLE_VIEWPORT_SIZE;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public void doProblemFactChange(ProblemFactChange<Solution_> problemFactChange) {
        this.doProblemFactChange(problemFactChange, false);
    }

    public void doProblemFactChange(ProblemFactChange<Solution_> problemFactChange, boolean reset) {
        this.solutionBusiness.doProblemFactChange(problemFactChange);
        Solution_ solution = this.getSolution();
        Score score = this.solutionBusiness.getScore();
        if (reset) {
            this.resetPanel(solution);
        } else {
            this.updatePanel(solution);
        }
        this.validate();
        this.solverAndPersistenceFrame.refreshScoreField(score);
    }
}

