/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools;

import java.util.Collection;
import java.util.Map;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.api.score.holder.ScoreHolder;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.score.director.AbstractScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.score.director.drools.DroolsScoreDirectorFactory;

public class DroolsScoreDirector<Solution_>
extends AbstractScoreDirector<Solution_, DroolsScoreDirectorFactory<Solution_>> {
    public static final String GLOBAL_SCORE_HOLDER_KEY = "scoreHolder";
    protected KieSession kieSession;
    protected ScoreHolder workingScoreHolder;

    public DroolsScoreDirector(DroolsScoreDirectorFactory<Solution_> scoreDirectorFactory, boolean lookUpEnabled, boolean constraintMatchEnabledPreference) {
        super(scoreDirectorFactory, lookUpEnabled, constraintMatchEnabledPreference);
    }

    public KieSession getKieSession() {
        return this.kieSession;
    }

    @Override
    public void setWorkingSolution(Solution_ workingSolution) {
        super.setWorkingSolution(workingSolution);
        this.resetKieSession();
    }

    private void resetKieSession() {
        if (this.kieSession != null) {
            this.kieSession.dispose();
        }
        this.kieSession = ((DroolsScoreDirectorFactory)this.scoreDirectorFactory).newKieSession();
        this.workingScoreHolder = this.getScoreDefinition().buildScoreHolder(this.constraintMatchEnabledPreference);
        this.kieSession.setGlobal(GLOBAL_SCORE_HOLDER_KEY, (Object)this.workingScoreHolder);
        Collection<Object> workingFacts = this.getWorkingFacts();
        for (Object fact : workingFacts) {
            this.kieSession.insert(fact);
        }
    }

    public Collection<Object> getWorkingFacts() {
        return this.getSolutionDescriptor().getAllFacts(this.workingSolution);
    }

    @Override
    public Score calculateScore() {
        this.variableListenerSupport.assertNotificationQueuesAreEmpty();
        this.kieSession.fireAllRules();
        Score score = this.workingScoreHolder.extractScore(this.workingInitScore);
        this.setCalculatedScore(score);
        return score;
    }

    @Override
    public boolean isConstraintMatchEnabled() {
        return this.workingScoreHolder.isConstraintMatchEnabled();
    }

    @Override
    public Collection<ConstraintMatchTotal> getConstraintMatchTotals() {
        if (this.workingSolution == null) {
            throw new IllegalStateException("The method setWorkingSolution() must be called before the method getConstraintMatchTotals().");
        }
        this.kieSession.fireAllRules();
        return this.workingScoreHolder.getConstraintMatchTotals();
    }

    @Override
    public Map<Object, Indictment> getIndictmentMap() {
        if (this.workingSolution == null) {
            throw new IllegalStateException("The method setWorkingSolution() must be called before the method getConstraintMatchTotals().");
        }
        this.kieSession.fireAllRules();
        return this.workingScoreHolder.getIndictmentMap();
    }

    @Override
    public DroolsScoreDirector<Solution_> clone() {
        return (DroolsScoreDirector)super.clone();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.kieSession != null) {
            this.kieSession.dispose();
            this.kieSession = null;
        }
    }

    @Override
    public void afterEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("The entity (" + entity + ") cannot be added to the ScoreDirector.");
        }
        if (!this.getSolutionDescriptor().hasEntityDescriptor(entity.getClass())) {
            throw new IllegalArgumentException("The entity (" + entity + ") of class (" + entity.getClass() + ") is not a configured @PlanningEntity.");
        }
        if (this.kieSession.getFactHandle(entity) != null) {
            throw new IllegalArgumentException("The entity (" + entity + ") was already added to this ScoreDirector. Usually the cause is that that specific instance was already in your Solution's entities and you probably want to use before/afterVariableChanged() instead.");
        }
        this.kieSession.insert(entity);
        super.afterEntityAdded(entityDescriptor, entity);
    }

    @Override
    public void afterVariableChanged(VariableDescriptor variableDescriptor, Object entity) {
        this.update(entity, variableDescriptor.getVariableName());
        super.afterVariableChanged(variableDescriptor, entity);
    }

    private void update(Object entity, String variableName) {
        FactHandle factHandle = this.kieSession.getFactHandle(entity);
        if (factHandle == null) {
            throw new IllegalArgumentException("The entity (" + entity + ") was never added to this ScoreDirector.\nMaybe that specific instance is not in the return values of the " + PlanningSolution.class.getSimpleName() + "'s entity members (" + this.getSolutionDescriptor().getEntityMemberAndEntityCollectionMemberNames() + ").");
        }
        this.kieSession.update(factHandle, entity, new String[]{variableName});
    }

    @Override
    public void afterEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        FactHandle factHandle = this.kieSession.getFactHandle(entity);
        if (factHandle == null) {
            throw new IllegalArgumentException("The entity (" + entity + ") was never added to this ScoreDirector.\nMaybe that specific instance is not in the return values of the " + PlanningSolution.class.getSimpleName() + "'s entity members (" + this.getSolutionDescriptor().getEntityMemberAndEntityCollectionMemberNames() + ").");
        }
        this.kieSession.delete(factHandle);
        super.afterEntityRemoved(entityDescriptor, entity);
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        if (this.kieSession.getFactHandle(problemFact) != null) {
            throw new IllegalArgumentException("The problemFact (" + problemFact + ") was already added to this ScoreDirector.\nMaybe that specific instance is already in the " + PlanningSolution.class.getSimpleName() + "'s problem fact members (" + this.getSolutionDescriptor().getProblemFactMemberAndProblemFactCollectionMemberNames() + ").\nMaybe use before/afterProblemPropertyChanged() instead of before/afterProblemFactAdded().");
        }
        this.kieSession.insert(problemFact);
        super.afterProblemFactAdded(problemFact);
    }

    @Override
    public void afterProblemPropertyChanged(Object problemFactOrEntity) {
        FactHandle factHandle = this.kieSession.getFactHandle(problemFactOrEntity);
        if (factHandle == null) {
            throw new IllegalArgumentException("The problemFact (" + problemFactOrEntity + ") was never added to this ScoreDirector.\nMaybe that specific instance is not in the " + PlanningSolution.class.getSimpleName() + "'s problem fact members (" + this.getSolutionDescriptor().getProblemFactMemberAndProblemFactCollectionMemberNames() + ").\nMaybe first translate that external instance to the workingSolution's instance with " + ScoreDirector.class.getSimpleName() + ".lookUpWorkingObject().");
        }
        this.kieSession.update(factHandle, problemFactOrEntity);
        super.afterProblemPropertyChanged(problemFactOrEntity);
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        FactHandle factHandle = this.kieSession.getFactHandle(problemFact);
        if (factHandle == null) {
            throw new IllegalArgumentException("The problemFact (" + problemFact + ") was never added to this ScoreDirector.\nMaybe that specific instance is not in the " + PlanningSolution.class.getSimpleName() + "'s problem fact members (" + this.getSolutionDescriptor().getProblemFactMemberAndProblemFactCollectionMemberNames() + ").\nMaybe first translate that external instance to the workingSolution's instance with " + ScoreDirector.class.getSimpleName() + ".lookUpWorkingObject().");
        }
        this.kieSession.delete(factHandle);
        super.afterProblemFactRemoved(problemFact);
    }
}

