/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.scrabble.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Map;
import java.util.Set;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.solution.cloner.DeepPlanningClone;
import org.optaplanner.core.api.domain.variable.CustomShadowVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariableReference;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.scrabble.domain.ScrabbleWordAssignment;
import org.optaplanner.examples.scrabble.domain.ScrabbleWordDirection;
import org.optaplanner.examples.scrabble.domain.solver.CellUpdatingVariableListener;

@PlanningEntity
@XStreamAlias(value="ScrabbleCell")
public class ScrabbleCell
extends AbstractPersistable {
    private int x;
    private int y;
    @CustomShadowVariable(variableListenerClass=CellUpdatingVariableListener.class, sources={@PlanningVariableReference(entityClass=ScrabbleWordAssignment.class, variableName="startCell"), @PlanningVariableReference(entityClass=ScrabbleWordAssignment.class, variableName="direction")})
    @DeepPlanningClone
    private Set<ScrabbleWordAssignment> wordSet;
    @CustomShadowVariable(variableListenerRef=@PlanningVariableReference(variableName="wordSet"))
    @DeepPlanningClone
    private Map<Character, Integer> characterCountMap;

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public Set<ScrabbleWordAssignment> getWordSet() {
        return this.wordSet;
    }

    public void setWordSet(Set<ScrabbleWordAssignment> wordSet) {
        this.wordSet = wordSet;
    }

    public Map<Character, Integer> getCharacterCountMap() {
        return this.characterCountMap;
    }

    public void setCharacterCountMap(Map<Character, Integer> characterCountMap) {
        this.characterCountMap = characterCountMap;
    }

    public String getLabel() {
        return "(" + this.x + "," + this.y + ")";
    }

    public void insertWordAssignment(ScrabbleWordAssignment wordAssignment, char c) {
        boolean added = this.wordSet.add(wordAssignment);
        if (!added) {
            throw new IllegalStateException("The wordAssignment (" + wordAssignment + ") is already in the cell (" + this + ").");
        }
        Integer characterCount = this.characterCountMap.get(Character.valueOf(c));
        if (characterCount == null) {
            characterCount = 0;
        }
        Integer n = characterCount;
        Integer n2 = characterCount = Integer.valueOf(characterCount + 1);
        this.characterCountMap.put(Character.valueOf(c), characterCount);
    }

    public void retractWordAssignment(ScrabbleWordAssignment wordAssignment, char c) {
        Integer characterCount;
        boolean removed = this.wordSet.remove(wordAssignment);
        if (!removed) {
            throw new IllegalStateException("The wordAssignment (" + wordAssignment + ") is not in the cell (" + this + ").");
        }
        Integer n = characterCount = this.characterCountMap.get(Character.valueOf(c));
        Integer n2 = characterCount = Integer.valueOf(characterCount - 1);
        if (characterCount == 0) {
            this.characterCountMap.remove(Character.valueOf(c));
        } else {
            this.characterCountMap.put(Character.valueOf(c), characterCount);
        }
    }

    public Set<Character> getCharacterSet() {
        return this.characterCountMap.keySet();
    }

    public boolean hasMerge() {
        if (this.characterCountMap.containsKey(Character.valueOf(' '))) {
            return false;
        }
        return this.wordSet.size() > 1;
    }

    public boolean hasWordSet(ScrabbleWordDirection direction) {
        for (ScrabbleWordAssignment wordAssignment : this.wordSet) {
            if (wordAssignment.getDirection() != direction) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }
}

