/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.base.BaseEvaluator;
import org.drools.core.base.ValueType;
import org.drools.core.base.evaluators.EvaluatorCache;
import org.drools.core.base.evaluators.EvaluatorDefinition;
import org.drools.core.base.evaluators.Operator;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.rule.VariableRestriction;
import org.drools.core.spi.Evaluator;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;

public class MatchesEvaluatorsDefinition
implements EvaluatorDefinition {
    protected static final String matchesOp = "matches";
    public static Operator MATCHES;
    public static Operator NOT_MATCHES;
    private static String[] SUPPORTED_IDS;
    private EvaluatorCache evaluators;

    public MatchesEvaluatorsDefinition() {
        MatchesEvaluatorsDefinition.init();
        this.evaluators = new EvaluatorCache(){
            private static final long serialVersionUID = 510L;
            {
                this.addEvaluator(ValueType.STRING_TYPE, MATCHES, StringMatchesEvaluator.INSTANCE);
                this.addEvaluator(ValueType.OBJECT_TYPE, MATCHES, StringMatchesEvaluator.INSTANCE);
                this.addEvaluator(ValueType.STRING_TYPE, NOT_MATCHES, StringNotMatchesEvaluator.INSTANCE);
                this.addEvaluator(ValueType.OBJECT_TYPE, NOT_MATCHES, StringNotMatchesEvaluator.INSTANCE);
            }
        };
    }

    static void init() {
        if (SUPPORTED_IDS == null) {
            MATCHES = Operator.addOperatorToRegistry(matchesOp, false);
            NOT_MATCHES = Operator.addOperatorToRegistry(matchesOp, true);
            SUPPORTED_IDS = new String[]{matchesOp};
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.evaluators = (EvaluatorCache)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.evaluators);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.evaluators.getEvaluator(type, operator);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.evaluators.getEvaluator(type, operator);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.FACT, EvaluatorDefinition.Target.FACT);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        return this.evaluators.getEvaluator(type, Operator.determineOperator(operatorId, isNegated));
    }

    @Override
    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.FACT;
    }

    @Override
    public boolean supportsType(ValueType type) {
        return this.evaluators.supportsType(type);
    }

    public static class StringNotMatchesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new StringNotMatchesEvaluator();

        public StringNotMatchesEvaluator() {
            super(ValueType.STRING_TYPE, NOT_MATCHES);
            MatchesEvaluatorsDefinition.init();
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, InternalFactHandle handle1, FieldValue fieldValue) {
            String value1 = (String)extractor.getValue(workingMemory, handle1.getObject());
            String value2 = (String)fieldValue.getValue();
            if (value1 == null) {
                return false;
            }
            return !value1.matches(value2);
        }

        @Override
        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            String value = (String)((VariableRestriction.ObjectVariableContextEntry)context).right;
            if (value == null) {
                return false;
            }
            return !value.matches((String)context.declaration.getExtractor().getValue(workingMemory, left.getObject()));
        }

        @Override
        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            String value = (String)context.extractor.getValue(workingMemory, right.getObject());
            if (value == null) {
                return false;
            }
            return !value.matches((String)((VariableRestriction.ObjectVariableContextEntry)context).left);
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, InternalFactHandle handle1, InternalReadAccessor extractor2, InternalFactHandle handle2) {
            Object value1 = extractor1.getValue(workingMemory, handle1.getObject());
            Object value2 = extractor2.getValue(workingMemory, handle2.getObject());
            if (value1 == null) {
                return false;
            }
            return !((String)value1).matches((String)value2);
        }

        @Override
        public String toString() {
            return "String not matches";
        }
    }

    public static class StringMatchesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new StringMatchesEvaluator();

        public StringMatchesEvaluator() {
            super(ValueType.STRING_TYPE, MATCHES);
            MatchesEvaluatorsDefinition.init();
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, InternalFactHandle handle1, FieldValue fieldValue) {
            String value1 = (String)extractor.getValue(workingMemory, handle1.getObject());
            String value2 = (String)fieldValue.getValue();
            if (value1 == null) {
                return false;
            }
            return value1.matches(value2);
        }

        @Override
        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            String value = (String)((VariableRestriction.ObjectVariableContextEntry)context).right;
            if (value == null) {
                return false;
            }
            return value.matches((String)context.declaration.getExtractor().getValue(workingMemory, left.getObject()));
        }

        @Override
        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            String value = (String)context.extractor.getValue(workingMemory, right.getObject());
            if (value == null) {
                return false;
            }
            return value.matches((String)((VariableRestriction.ObjectVariableContextEntry)context).left);
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, InternalFactHandle handle1, InternalReadAccessor extractor2, InternalFactHandle handle2) {
            Object value1 = extractor1.getValue(workingMemory, handle1.getObject());
            Object value2 = extractor2.getValue(workingMemory, handle2.getObject());
            if (value1 == null) {
                return false;
            }
            return ((String)value1).matches((String)value2);
        }

        @Override
        public String toString() {
            return "String matches";
        }
    }
}

