/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.time.DateTimeException;
import java.time.LocalDate;

public class LocalDateXStreamConverter
implements Converter {
    public void marshal(Object localDateObject, HierarchicalStreamWriter writer, MarshallingContext context) {
        LocalDate localDate = (LocalDate)localDateObject;
        writer.setValue(localDate.toString());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String localDateString = reader.getValue();
        try {
            return LocalDate.parse(localDateString);
        }
        catch (DateTimeException e) {
            throw new IllegalStateException("Failed to convert string (" + localDateString + ") to type (" + LocalDate.class.getName() + ").");
        }
    }

    public boolean canConvert(Class type) {
        return LocalDate.class.isAssignableFrom(type);
    }
}

