/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.compiler.DroolsError;
import org.drools.compiler.compiler.DroolsWarning;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.rule.builder.dialect.mvel.MVELDialect;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.rule.Dialectable;
import org.drools.core.rule.MVELDialectRuntimeData;

public class PackageBuildContext {
    private InternalKnowledgePackage pkg;
    private KnowledgeBuilderImpl kBuilder;
    private BaseDescr parentDescr;
    private List<DroolsError> errors;
    private List<DroolsWarning> warnings;
    private List<String> methods;
    private Map<String, String> invokers;
    private Map<String, Object> invokerLookups;
    private Map<String, BaseDescr> descrLookups;
    private int counter;
    private DialectCompiletimeRegistry dialectRegistry;
    private Dialect dialect;
    private boolean typesafe;

    public void init(KnowledgeBuilderImpl kBuilder, InternalKnowledgePackage pkg, BaseDescr parentDescr, DialectCompiletimeRegistry dialectRegistry, Dialect defaultDialect, Dialectable component) {
        this.kBuilder = kBuilder;
        this.pkg = pkg;
        this.parentDescr = parentDescr;
        this.methods = new ArrayList<String>();
        this.invokers = new HashMap<String, String>();
        this.invokerLookups = new HashMap<String, Object>();
        this.descrLookups = new HashMap<String, BaseDescr>();
        this.errors = new ArrayList<DroolsError>();
        this.warnings = new ArrayList<DroolsWarning>();
        this.dialectRegistry = dialectRegistry;
        this.dialect = component != null && component.getDialect() != null ? this.dialectRegistry.getDialect(component.getDialect()) : defaultDialect;
        this.typesafe = ((MVELDialect)dialectRegistry.getDialect("mvel")).isStrictMode();
        if (this.dialect == null && component != null && component.getDialect() != null) {
            this.errors.add(new DescrBuildError(null, parentDescr, component, "Unable to load Dialect '" + component.getDialect() + "'"));
            this.dialect = defaultDialect;
        }
    }

    public BaseDescr getParentDescr() {
        return this.parentDescr;
    }

    public void setParentDescr(BaseDescr descr) {
        this.parentDescr = descr;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public Dialect getDialect(String dialectName) {
        return this.dialectRegistry.getDialect(dialectName);
    }

    public DialectCompiletimeRegistry getDialectRegistry() {
        return this.dialectRegistry;
    }

    public List<DroolsError> getErrors() {
        return this.errors;
    }

    public void addError(DroolsError error) {
        this.errors.add(error);
    }

    public List<DroolsWarning> getWarnings() {
        return this.warnings;
    }

    public void addWarning(DroolsWarning warning) {
        this.warnings.add(warning);
    }

    public InternalKnowledgePackage getPkg() {
        return this.pkg;
    }

    public BaseDescr getDescrLookup(String className) {
        return this.descrLookups.get(className);
    }

    public void addDescrLookups(String className, BaseDescr baseDescr) {
        this.descrLookups.put(className, baseDescr);
    }

    public Object getInvokerLookup(String className) {
        return this.invokerLookups.get(className);
    }

    public void addInvokerLookup(String className, Object invokerLookup) {
        this.invokerLookups.put(className, invokerLookup);
    }

    public Map<String, String> getInvokers() {
        return this.invokers;
    }

    public void setInvokers(Map<String, String> invokers) {
        this.invokers = invokers;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public void addMethod(String method) {
        this.methods.add(method);
    }

    public int getCurrentId() {
        return this.counter;
    }

    public int getNextId() {
        return this.counter++;
    }

    public KnowledgeBuilderConfigurationImpl getConfiguration() {
        return this.kBuilder.getBuilderConfiguration();
    }

    public KnowledgeBuilderImpl getKnowledgeBuilder() {
        return this.kBuilder;
    }

    public boolean isTypesafe() {
        return this.typesafe;
    }

    public void setTypesafe(boolean stricttype) {
        this.typesafe = stricttype;
    }

    public MVELDialectRuntimeData getMVELDialectRuntimeData() {
        return (MVELDialectRuntimeData)this.pkg.getDialectRuntimeRegistry().getDialectData("mvel");
    }

    public Class<?> resolveVarType(String identifier) {
        return this.getKnowledgeBuilder().getGlobals().get(identifier);
    }
}

