<?xml version="1.0" encoding="UTF-8"?>
<plannerBenchmark>
  <benchmarkDirectory>local/data/general/template</benchmarkDirectory>

  <inheritedSolverBenchmark>
    <problemBenchmarks>
      <problemStatisticType>BEST_SCORE</problemStatisticType>
    </problemBenchmarks>
    <solver>
      <termination>
        <minutesSpentLimit>5</minutesSpentLimit>
      </termination>
    </solver>
  </inheritedSolverBenchmark>


<#list ['JDK', 'MERSENNE_TWISTER', 'WELL512A', 'WELL1024A', 'WELL19937C', 'WELL44497B'] as randomType>
  <solverBenchmark>
    <name>Cloud Balancing Late Acceptance ${randomType}</name>
    <problemBenchmarks>
      <xStreamAnnotatedClass>org.optaplanner.examples.cloudbalancing.domain.CloudBalance</xStreamAnnotatedClass>
      <inputSolutionFile>data/cloudbalancing/unsolved/200computers-600processes.xml</inputSolutionFile>
      <inputSolutionFile>data/cloudbalancing/unsolved/800computers-2400processes.xml</inputSolutionFile>
    </problemBenchmarks>
    <solver>
      <solutionClass>org.optaplanner.examples.cloudbalancing.domain.CloudBalance</solutionClass>
      <entityClass>org.optaplanner.examples.cloudbalancing.domain.CloudProcess</entityClass>
      <randomType>${randomType}</randomType>
      <scoreDirectorFactory>
        <scoreDrl>org/optaplanner/examples/cloudbalancing/solver/cloudBalancingScoreRules.drl</scoreDrl>
        <initializingScoreTrend>ONLY_DOWN</initializingScoreTrend>
      </scoreDirectorFactory>
      <constructionHeuristic>
        <constructionHeuristicType>FIRST_FIT_DECREASING</constructionHeuristicType>
      </constructionHeuristic>
      <localSearch>
        <unionMoveSelector>
          <changeMoveSelector/>
          <swapMoveSelector/>
        </unionMoveSelector>
        <acceptor>
          <lateAcceptanceSize>400</lateAcceptanceSize>
        </acceptor>
        <forager>
          <acceptedCountLimit>4</acceptedCountLimit>
        </forager>
      </localSearch>
    </solver>
  </solverBenchmark>
  <solverBenchmark>
    <name>Machine Reassignment Tabu Search ${randomType}</name>
    <problemBenchmarks>
      <solutionFileIOClass>org.optaplanner.examples.machinereassignment.persistence.MachineReassignmentFileIO</solutionFileIOClass>
      <inputSolutionFile>data/machinereassignment/import/model_b_1.txt</inputSolutionFile>
      <inputSolutionFile>data/machinereassignment/import/model_b_10.txt</inputSolutionFile>
    </problemBenchmarks>
    <solver>
      <solutionClass>org.optaplanner.examples.machinereassignment.domain.MachineReassignment</solutionClass>
      <entityClass>org.optaplanner.examples.machinereassignment.domain.MrProcessAssignment</entityClass>
      <randomType>${randomType}</randomType>
      <scoreDirectorFactory>
        <incrementalScoreCalculatorClass>org.optaplanner.examples.machinereassignment.solver.score.MachineReassignmentIncrementalScoreCalculator</incrementalScoreCalculatorClass>
      </scoreDirectorFactory>
      <customPhase>
        <customPhaseCommandClass>org.optaplanner.examples.machinereassignment.solver.solution.initializer.ToOriginalMachineSolutionInitializer</customPhaseCommandClass>
      </customPhase>
      <localSearch>
        <unionMoveSelector>
          <changeMoveSelector/>
          <swapMoveSelector/>
        </unionMoveSelector>
        <acceptor>
          <entityTabuSize>7</entityTabuSize>
        </acceptor>
        <forager>
          <acceptedCountLimit>2000</acceptedCountLimit>
        </forager>
      </localSearch>
    </solver>
  </solverBenchmark>
  <solverBenchmark>
    <name>Course Scheduling Late Acceptance ${randomType}</name>
    <problemBenchmarks>
      <xStreamAnnotatedClass>org.optaplanner.examples.curriculumcourse.domain.CourseSchedule</xStreamAnnotatedClass>
      <inputSolutionFile>data/curriculumcourse/unsolved/comp07.xml</inputSolutionFile>
      <inputSolutionFile>data/curriculumcourse/unsolved/comp08.xml</inputSolutionFile>
    </problemBenchmarks>
    <solver>
      <solutionClass>org.optaplanner.examples.curriculumcourse.domain.CourseSchedule</solutionClass>
      <entityClass>org.optaplanner.examples.curriculumcourse.domain.Lecture</entityClass>
      <randomType>${randomType}</randomType>
      <scoreDirectorFactory>
        <scoreDrl>org/optaplanner/examples/curriculumcourse/solver/curriculumCourseScoreRules.drl</scoreDrl>
      </scoreDirectorFactory>
      <constructionHeuristic>
        <constructionHeuristicType>FIRST_FIT_DECREASING</constructionHeuristicType>
      </constructionHeuristic>
      <localSearch>
        <unionMoveSelector>
          <changeMoveSelector/>
          <swapMoveSelector>
            <filterClass>org.optaplanner.examples.curriculumcourse.solver.move.DifferentCourseSwapMoveFilter</filterClass>
          </swapMoveSelector>
        </unionMoveSelector>
        <acceptor>
          <lateAcceptanceSize>600</lateAcceptanceSize>
        </acceptor>
        <forager>
          <acceptedCountLimit>4</acceptedCountLimit>
        </forager>
      </localSearch>
    </solver>
  </solverBenchmark>
  <solverBenchmark>
    <name>Examination Tabu Search ${randomType}</name>
    <problemBenchmarks>
      <xStreamAnnotatedClass>org.optaplanner.examples.examination.domain.Examination</xStreamAnnotatedClass>
      <inputSolutionFile>data/examination/unsolved/exam_comp_set2.xml</inputSolutionFile>
      <inputSolutionFile>data/examination/unsolved/exam_comp_set3.xml</inputSolutionFile>
    </problemBenchmarks>
    <solver>
      <solutionClass>org.optaplanner.examples.examination.domain.Examination</solutionClass>
      <entityClass>org.optaplanner.examples.examination.domain.Exam</entityClass>
      <entityClass>org.optaplanner.examples.examination.domain.LeadingExam</entityClass>
      <entityClass>org.optaplanner.examples.examination.domain.FollowingExam</entityClass>
      <randomType>${randomType}</randomType>
      <scoreDirectorFactory>
        <scoreDrl>org/optaplanner/examples/examination/solver/examinationScoreRules.drl</scoreDrl>
      </scoreDirectorFactory>
      <constructionHeuristic>
        <queuedEntityPlacer>
          <entitySelector id="placerEntitySelector">
            <entityClass>org.optaplanner.examples.examination.domain.Exam</entityClass>
            <cacheType>PHASE</cacheType>
            <selectionOrder>SORTED</selectionOrder>
            <sorterManner>DECREASING_DIFFICULTY</sorterManner>
          </entitySelector>
          <cartesianProductMoveSelector>
            <changeMoveSelector>
              <entitySelector mimicSelectorRef="placerEntitySelector"/>
              <valueSelector>
                <downcastEntityClass>org.optaplanner.examples.examination.domain.LeadingExam</downcastEntityClass>
                <variableName>period</variableName>
                <cacheType>PHASE</cacheType>
                <!--<selectionOrder>SORTED</selectionOrder>-->
                <!--<sorterManner>INCREASING_STRENGTH</sorterManner>-->
              </valueSelector>
            </changeMoveSelector>
            <changeMoveSelector>
              <entitySelector mimicSelectorRef="placerEntitySelector"/>
              <valueSelector>
                <variableName>room</variableName>
                <cacheType>PHASE</cacheType>
                <selectionOrder>SORTED</selectionOrder>
                <sorterManner>INCREASING_STRENGTH</sorterManner>
              </valueSelector>
            </changeMoveSelector>
          </cartesianProductMoveSelector>
        </queuedEntityPlacer>
      </constructionHeuristic>
      <localSearch>
        <unionMoveSelector>
          <cartesianProductMoveSelector>
            <changeMoveSelector>
              <entitySelector id="cartesianProductEntitySelector">
                <entityClass>org.optaplanner.examples.examination.domain.Exam</entityClass>
              </entitySelector>
              <valueSelector>
                <variableName>room</variableName>
              </valueSelector>
            </changeMoveSelector>
            <changeMoveSelector>
              <entitySelector mimicSelectorRef="cartesianProductEntitySelector"/>
              <valueSelector>
                <downcastEntityClass>org.optaplanner.examples.examination.domain.LeadingExam</downcastEntityClass>
                <variableName>period</variableName>
              </valueSelector>
            </changeMoveSelector>
          </cartesianProductMoveSelector>
          <swapMoveSelector>
            <entitySelector>
              <entityClass>org.optaplanner.examples.examination.domain.LeadingExam</entityClass>
            </entitySelector>
          </swapMoveSelector>
        </unionMoveSelector>
        <acceptor>
          <entityTabuSize>10</entityTabuSize>
        </acceptor>
        <forager>
          <acceptedCountLimit>2000</acceptedCountLimit>
        </forager>
      </localSearch>
    </solver>
  </solverBenchmark>
  <solverBenchmark>
    <name>Nurse Rostering Tabu Search ${randomType}</name>
    <problemBenchmarks>
      <xStreamAnnotatedClass>org.optaplanner.examples.nurserostering.domain.NurseRoster</xStreamAnnotatedClass>
      <inputSolutionFile>data/nurserostering/unsolved/medium01.xml</inputSolutionFile>
      <inputSolutionFile>data/nurserostering/unsolved/medium_hint01.xml</inputSolutionFile>
    </problemBenchmarks>
    <solver>
      <solutionClass>org.optaplanner.examples.nurserostering.domain.NurseRoster</solutionClass>
      <entityClass>org.optaplanner.examples.nurserostering.domain.ShiftAssignment</entityClass>
      <randomType>${randomType}</randomType>
      <scoreDirectorFactory>
        <scoreDrl>org/optaplanner/examples/nurserostering/solver/nurseRosteringScoreRules.drl</scoreDrl>
      </scoreDirectorFactory>
      <constructionHeuristic>
        <constructionHeuristicType>WEAKEST_FIT</constructionHeuristicType>
      </constructionHeuristic>
      <localSearch>
        <unionMoveSelector>
          <moveListFactory>
            <cacheType>PHASE</cacheType>
            <moveListFactoryClass>org.optaplanner.examples.nurserostering.solver.move.factory.EmployeeChangeMoveFactory</moveListFactoryClass>
          </moveListFactory>
          <moveListFactory>
            <cacheType>PHASE</cacheType>
            <moveListFactoryClass>org.optaplanner.examples.nurserostering.solver.move.factory.ShiftAssignmentSwapMoveFactory</moveListFactoryClass>
          </moveListFactory>
          <moveListFactory>
            <cacheType>STEP</cacheType>
            <moveListFactoryClass>org.optaplanner.examples.nurserostering.solver.move.factory.ShiftAssignmentPillarPartSwapMoveFactory</moveListFactoryClass>
          </moveListFactory>
        </unionMoveSelector>
        <acceptor>
          <entityTabuSize>7</entityTabuSize>
        </acceptor>
        <forager>
          <acceptedCountLimit>800</acceptedCountLimit>
        </forager>
      </localSearch>
    </solver>
  </solverBenchmark>
  <solverBenchmark>
    <name>TravelingTournament Tabu Search ${randomType}</name>
    <problemBenchmarks>
      <xStreamAnnotatedClass>org.optaplanner.examples.travelingtournament.domain.TravelingTournament</xStreamAnnotatedClass>
      <inputSolutionFile>data/travelingtournament/unsolved/1-nl14.xml</inputSolutionFile>
    </problemBenchmarks>
    <solver>
      <solutionClass>org.optaplanner.examples.travelingtournament.domain.TravelingTournament</solutionClass>
      <entityClass>org.optaplanner.examples.travelingtournament.domain.Match</entityClass>
      <randomType>${randomType}</randomType>
      <scoreDirectorFactory>
        <scoreDrl>org/optaplanner/examples/travelingtournament/solver/travelingTournamentScoreRules.drl</scoreDrl>
      </scoreDirectorFactory>
      <localSearch>
        <unionMoveSelector>
          <swapMoveSelector>
            <cacheType>PHASE</cacheType>
            <selectionOrder>SHUFFLED</selectionOrder>
            <filterClass>org.optaplanner.examples.travelingtournament.solver.move.factory.InverseMatchSwapMoveFilter</filterClass>
          </swapMoveSelector>
          <moveListFactory>
            <cacheType>STEP</cacheType>
            <selectionOrder>SHUFFLED</selectionOrder>
            <moveListFactoryClass>org.optaplanner.examples.travelingtournament.solver.move.factory.MatchChainRotationsMoveFactory</moveListFactoryClass>
          </moveListFactory>
        </unionMoveSelector>
        <acceptor>
          <solutionTabuSize>1500</solutionTabuSize>
          <moveTabuSize>7</moveTabuSize>
        </acceptor>
        <forager>
          <!-- Real world problems require to use of <acceptedCountLimit> -->
        </forager>
      </localSearch>
    </solver>
  </solverBenchmark>
</#list>
</plannerBenchmark>
