/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class SubChainChangeMove<Solution_>
extends AbstractMove<Solution_> {
    protected final SubChain subChain;
    protected final GenuineVariableDescriptor<Solution_> variableDescriptor;
    protected final SingletonInverseVariableSupply inverseVariableSupply;
    protected final Object toPlanningValue;

    public SubChainChangeMove(SubChain subChain, GenuineVariableDescriptor<Solution_> variableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, Object toPlanningValue) {
        this.subChain = subChain;
        this.variableDescriptor = variableDescriptor;
        this.inverseVariableSupply = inverseVariableSupply;
        this.toPlanningValue = toPlanningValue;
    }

    public String getVariableName() {
        return this.variableDescriptor.getVariableName();
    }

    public SubChain getSubChain() {
        return this.subChain;
    }

    public Object getToPlanningValue() {
        return this.toPlanningValue;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        if (this.subChain.getEntityList().contains(this.toPlanningValue)) {
            return false;
        }
        Object oldFirstValue = this.variableDescriptor.getValue(this.subChain.getFirstEntity());
        return !Objects.equals(oldFirstValue, this.toPlanningValue);
    }

    @Override
    public SubChainChangeMove<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
        Object oldFirstValue = this.variableDescriptor.getValue(this.subChain.getFirstEntity());
        return new SubChainChangeMove<Solution_>(this.subChain, this.variableDescriptor, this.inverseVariableSupply, oldFirstValue);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        Object newTrailingEntity;
        Object firstEntity = this.subChain.getFirstEntity();
        Object lastEntity = this.subChain.getLastEntity();
        Object oldFirstValue = this.variableDescriptor.getValue(firstEntity);
        Object oldTrailingLastEntity = this.inverseVariableSupply.getInverseSingleton(lastEntity);
        Object object = newTrailingEntity = this.toPlanningValue == null ? null : this.inverseVariableSupply.getInverseSingleton(this.toPlanningValue);
        if (oldTrailingLastEntity != null) {
            scoreDirector.changeVariableFacade(this.variableDescriptor, oldTrailingLastEntity, oldFirstValue);
        }
        scoreDirector.changeVariableFacade(this.variableDescriptor, firstEntity, this.toPlanningValue);
        if (newTrailingEntity != null) {
            scoreDirector.changeVariableFacade(this.variableDescriptor, newTrailingEntity, lastEntity);
        }
    }

    @Override
    public SubChainChangeMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new SubChainChangeMove<Solution_>(this.subChain.rebase(destinationScoreDirector), this.variableDescriptor, this.inverseVariableSupply, destinationScoreDirector.lookUpWorkingObject(this.toPlanningValue));
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return this.subChain.getEntityList();
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toPlanningValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SubChainChangeMove) {
            SubChainChangeMove other = (SubChainChangeMove)o;
            return new EqualsBuilder().append((Object)this.subChain, (Object)other.subChain).append(this.variableDescriptor, other.variableDescriptor).append(this.toPlanningValue, other.toPlanningValue).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.subChain).append(this.variableDescriptor).append(this.toPlanningValue).toHashCode();
    }

    public String toString() {
        Object oldFirstValue = this.variableDescriptor.getValue(this.subChain.getFirstEntity());
        return this.subChain.toDottedString() + " {" + oldFirstValue + " -> " + this.toPlanningValue + "}";
    }
}

