/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.domain;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Set;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.conferencescheduling.domain.TalkType;

public class Timeslot
extends AbstractPersistable {
    private LocalDateTime startDateTime;
    private LocalDateTime endDateTime;
    private Set<TalkType> talkTypeSet;
    private Set<String> tagSet;

    public Timeslot() {
    }

    public Timeslot(long id) {
        super(id);
    }

    public LocalDate getDate() {
        return this.startDateTime.toLocalDate();
    }

    public long getDurationInMinutes() {
        return Duration.between(this.startDateTime, this.endDateTime).toMinutes();
    }

    public boolean overlaps(Timeslot other) {
        if (this == other) {
            return true;
        }
        return this.startDateTime.compareTo(other.endDateTime) < 0 && other.startDateTime.compareTo(this.endDateTime) < 0;
    }

    public boolean startsAfter(Timeslot other) {
        return other.endDateTime.compareTo(this.startDateTime) <= 0;
    }

    public boolean endsBefore(Timeslot other) {
        return this.endDateTime.compareTo(other.startDateTime) <= 0;
    }

    public boolean hasTag(String tag) {
        return this.tagSet.contains(tag);
    }

    @Override
    public String toString() {
        return this.startDateTime + "-" + this.endDateTime.toLocalTime();
    }

    public LocalDateTime getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(LocalDateTime startDateTime) {
        this.startDateTime = startDateTime;
    }

    public LocalDateTime getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(LocalDateTime endDateTime) {
        this.endDateTime = endDateTime;
    }

    public Set<TalkType> getTalkTypeSet() {
        return this.talkTypeSet;
    }

    public void setTalkTypeSet(Set<TalkType> talkTypeSet) {
        this.talkTypeSet = talkTypeSet;
    }

    public Set<String> getTagSet() {
        return this.tagSet;
    }

    public void setTagSet(Set<String> tagSet) {
        this.tagSet = tagSet;
    }

    public Timeslot withTalkTypeSet(Set<TalkType> talkTypeSet) {
        this.talkTypeSet = talkTypeSet;
        return this;
    }

    public Timeslot withStartDateTime(LocalDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    public Timeslot withEndDateTime(LocalDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }
}

