/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.constraint;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;

public final class ConstraintMatchTotal
implements Serializable,
Comparable<ConstraintMatchTotal> {
    private final String constraintPackage;
    private final String constraintName;
    private final Score constraintWeight;
    private final Set<ConstraintMatch> constraintMatchSet;
    private Score score;

    public ConstraintMatchTotal(String constraintPackage, String constraintName, Score zeroScore) {
        this(constraintPackage, constraintName, null, zeroScore);
    }

    public ConstraintMatchTotal(String constraintPackage, String constraintName, Score constraintWeight, Score zeroScore) {
        this.constraintPackage = constraintPackage;
        this.constraintName = constraintName;
        this.constraintMatchSet = new LinkedHashSet<ConstraintMatch>();
        this.constraintWeight = constraintWeight;
        this.score = zeroScore;
    }

    public String getConstraintPackage() {
        return this.constraintPackage;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public Score getConstraintWeight() {
        return this.constraintWeight;
    }

    public Set<ConstraintMatch> getConstraintMatchSet() {
        return this.constraintMatchSet;
    }

    public int getConstraintMatchCount() {
        return this.getConstraintMatchSet().size();
    }

    public Score getScore() {
        return this.score;
    }

    @Deprecated
    public Score getScoreTotal() {
        return this.getScore();
    }

    public ConstraintMatch addConstraintMatch(List<Object> justificationList, Score score) {
        this.score = this.score.add(score);
        ConstraintMatch constraintMatch = new ConstraintMatch(this.constraintPackage, this.constraintName, justificationList, score);
        boolean added = this.constraintMatchSet.add(constraintMatch);
        if (!added) {
            throw new IllegalStateException("The constraintMatchTotal (" + this + ") could not add constraintMatch (" + constraintMatch + ") to its constraintMatchSet (" + this.constraintMatchSet + ").");
        }
        return constraintMatch;
    }

    public void removeConstraintMatch(ConstraintMatch constraintMatch) {
        this.score = this.score.subtract(constraintMatch.getScore());
        boolean removed = this.constraintMatchSet.remove(constraintMatch);
        if (!removed) {
            throw new IllegalStateException("The constraintMatchTotal (" + this + ") could not remove constraintMatch (" + constraintMatch + ") from its constraintMatchSet (" + this.constraintMatchSet + ").");
        }
    }

    public String getConstraintId() {
        return this.constraintPackage + "/" + this.constraintName;
    }

    @Override
    public int compareTo(ConstraintMatchTotal other) {
        if (!this.constraintPackage.equals(other.constraintPackage)) {
            return this.constraintPackage.compareTo(other.constraintPackage);
        }
        if (!this.constraintName.equals(other.constraintName)) {
            return this.constraintName.compareTo(other.constraintName);
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ConstraintMatchTotal) {
            ConstraintMatchTotal other = (ConstraintMatchTotal)o;
            return this.constraintPackage.equals(other.constraintPackage) && this.constraintName.equals(other.constraintName);
        }
        return false;
    }

    public int hashCode() {
        return (629 + this.constraintPackage.hashCode()) * 37 + this.constraintName.hashCode();
    }

    public String toString() {
        return this.getConstraintId() + "=" + this.getScore();
    }
}

