/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.persistence;

import java.io.IOException;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionImporter;
import org.optaplanner.examples.common.persistence.SolutionConverter;
import org.optaplanner.examples.examination.domain.Exam;
import org.optaplanner.examples.examination.domain.Examination;
import org.optaplanner.examples.examination.domain.ExaminationConstraintConfiguration;
import org.optaplanner.examples.examination.domain.FollowingExam;
import org.optaplanner.examples.examination.domain.LeadingExam;
import org.optaplanner.examples.examination.domain.Period;
import org.optaplanner.examples.examination.domain.PeriodPenalty;
import org.optaplanner.examples.examination.domain.PeriodPenaltyType;
import org.optaplanner.examples.examination.domain.Room;
import org.optaplanner.examples.examination.domain.RoomPenalty;
import org.optaplanner.examples.examination.domain.RoomPenaltyType;
import org.optaplanner.examples.examination.domain.Student;
import org.optaplanner.examples.examination.domain.Topic;

public class ExaminationImporter
extends AbstractTxtSolutionImporter<Examination> {
    private static final String INPUT_FILE_SUFFIX = "exam";
    private static final String SPLIT_REGEX = "\\,\\ ?";

    public static void main(String[] args) {
        SolutionConverter<Examination> converter = SolutionConverter.createImportConverter("examination", new ExaminationImporter(), Examination.class);
        converter.convertAll();
    }

    @Override
    public String getInputFileSuffix() {
        return INPUT_FILE_SUFFIX;
    }

    @Override
    public AbstractTxtSolutionImporter.TxtInputBuilder<Examination> createTxtInputBuilder() {
        return new ExaminationInputBuilder();
    }

    public static class ExaminationInputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder<Examination> {
        private Examination examination;
        private Map<Topic, Set<Topic>> coincidenceMap;
        private Map<Topic, Set<Topic>> exclusionMap;
        private Map<Topic, Set<Topic>> afterMap;

        @Override
        public Examination readSolution() throws IOException {
            this.examination = new Examination();
            this.examination.setId(0L);
            this.readTopicListAndStudentList();
            this.readPeriodList();
            this.readRoomList();
            this.readPeriodPenaltyList();
            this.readRoomPenaltyList();
            this.readInstitutionalWeighting();
            this.tagFrontLoadLargeTopics();
            this.tagFrontLoadLastPeriods();
            this.createExamList();
            int possibleForOneExamSize = this.examination.getPeriodList().size() * this.examination.getRoomList().size();
            BigInteger possibleSolutionSize = BigInteger.valueOf(possibleForOneExamSize).pow(this.examination.getExamList().size());
            this.logger.info("Examination {} has {} students, {} exams, {} periods, {} rooms, {} period constraints and {} room constraints with a search space of {}.", new Object[]{this.getInputId(), this.examination.getStudentList().size(), this.examination.getExamList().size(), this.examination.getPeriodList().size(), this.examination.getRoomList().size(), this.examination.getPeriodPenaltyList().size(), this.examination.getRoomPenaltyList().size(), AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
            return this.examination;
        }

        private void readTopicListAndStudentList() throws IOException {
            this.coincidenceMap = new LinkedHashMap<Topic, Set<Topic>>();
            this.exclusionMap = new LinkedHashMap<Topic, Set<Topic>>();
            this.afterMap = new LinkedHashMap<Topic, Set<Topic>>();
            HashMap<Integer, Student> studentMap = new HashMap<Integer, Student>();
            int examSize = this.readHeaderWithNumber("Exams");
            ArrayList<Topic> topicList = new ArrayList<Topic>(examSize);
            for (int i = 0; i < examSize; ++i) {
                Topic topic = new Topic();
                topic.setId(Long.valueOf(i));
                String line = this.bufferedReader.readLine();
                String[] lineTokens = line.split(ExaminationImporter.SPLIT_REGEX);
                topic.setDuration(Integer.parseInt(lineTokens[0]));
                ArrayList<Student> topicStudentList = new ArrayList<Student>(lineTokens.length - 1);
                for (int j = 1; j < lineTokens.length; ++j) {
                    topicStudentList.add(this.findOrCreateStudent(studentMap, Integer.parseInt(lineTokens[j])));
                }
                topic.setStudentList(topicStudentList);
                topic.setFrontLoadLarge(false);
                topicList.add(topic);
                this.coincidenceMap.put(topic, new HashSet());
                this.exclusionMap.put(topic, new HashSet());
                this.afterMap.put(topic, new HashSet());
            }
            this.examination.setTopicList(topicList);
            ArrayList<Student> studentList = new ArrayList<Student>(studentMap.values());
            this.examination.setStudentList(studentList);
        }

        private Student findOrCreateStudent(Map<Integer, Student> studentMap, int id) {
            Student student = studentMap.get(id);
            if (student == null) {
                student = new Student();
                student.setId(Long.valueOf(id));
                studentMap.put(id, student);
            }
            return student;
        }

        private void readPeriodList() throws IOException {
            int periodSize = this.readHeaderWithNumber("Periods");
            ArrayList<Period> periodList = new ArrayList<Period>(periodSize);
            DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("dd:MM:yyyy HH:mm:ss", Locale.UK);
            LocalDateTime referenceDateTime = null;
            for (int i = 0; i < periodSize; ++i) {
                int dayIndex;
                LocalDateTime dateTime;
                Period period = new Period();
                period.setId(Long.valueOf(i));
                String line = this.bufferedReader.readLine();
                String[] lineTokens = line.split(ExaminationImporter.SPLIT_REGEX);
                if (lineTokens.length != 4) {
                    throw new IllegalArgumentException("Read line (" + line + ") is expected to contain 4 tokens.");
                }
                String startDateTimeString = lineTokens[0] + " " + lineTokens[1];
                period.setStartDateTimeString(startDateTimeString);
                period.setPeriodIndex(i);
                try {
                    dateTime = LocalDateTime.parse(startDateTimeString, DATE_FORMAT);
                }
                catch (DateTimeParseException e) {
                    throw new IllegalArgumentException("Illegal startDateTimeString (" + startDateTimeString + ").", e);
                }
                if (referenceDateTime == null) {
                    referenceDateTime = dateTime;
                }
                if ((dayIndex = (int)ChronoUnit.DAYS.between(referenceDateTime, dateTime)) < 0) {
                    throw new IllegalStateException("The periods should be in ascending order.");
                }
                period.setDayIndex(dayIndex);
                period.setDuration(Integer.parseInt(lineTokens[2]));
                period.setPenalty(Integer.parseInt(lineTokens[3]));
                periodList.add(period);
            }
            this.examination.setPeriodList(periodList);
        }

        private void readRoomList() throws IOException {
            int roomSize = this.readHeaderWithNumber("Rooms");
            ArrayList<Room> roomList = new ArrayList<Room>(roomSize);
            for (int i = 0; i < roomSize; ++i) {
                Room room = new Room();
                room.setId(Long.valueOf(i));
                String line = this.bufferedReader.readLine();
                String[] lineTokens = line.split(ExaminationImporter.SPLIT_REGEX);
                if (lineTokens.length != 2) {
                    throw new IllegalArgumentException("Read line (" + line + ") is expected to contain 2 tokens.");
                }
                room.setCapacity(Integer.parseInt(lineTokens[0]));
                room.setPenalty(Integer.parseInt(lineTokens[1]));
                roomList.add(room);
            }
            this.examination.setRoomList(roomList);
        }

        private void readPeriodPenaltyList() throws IOException {
            Topic leftTopic;
            this.readConstantLine("\\[PeriodHardConstraints\\]");
            List<Topic> topicList = this.examination.getTopicList();
            ArrayList<PeriodPenalty> periodPenaltyList = new ArrayList<PeriodPenalty>();
            String line = this.bufferedReader.readLine();
            int id = 0;
            while (!line.equals("[RoomHardConstraints]")) {
                String[] lineTokens = line.split(ExaminationImporter.SPLIT_REGEX);
                if (lineTokens.length != 3) {
                    throw new IllegalArgumentException("Read line (" + line + ") is expected to contain 3 tokens.");
                }
                PeriodPenalty periodPenalty = new PeriodPenalty();
                periodPenalty.setId(Long.valueOf(id));
                ++id;
                leftTopic = topicList.get(Integer.parseInt(lineTokens[0]));
                periodPenalty.setLeftTopic(leftTopic);
                PeriodPenaltyType periodPenaltyType = PeriodPenaltyType.valueOf(lineTokens[1]);
                periodPenalty.setPeriodPenaltyType(periodPenaltyType);
                Topic rightTopic = topicList.get(Integer.parseInt(lineTokens[2]));
                periodPenalty.setRightTopic(rightTopic);
                boolean ignorePenalty = false;
                switch (periodPenaltyType) {
                    case EXAM_COINCIDENCE: {
                        boolean added;
                        if (leftTopic.getId().equals(rightTopic.getId())) {
                            this.logger.warn("  Filtering out periodPenalty (" + periodPenalty + ") because the left and right topic are the same.");
                            ignorePenalty = true;
                            break;
                        }
                        if (!Collections.disjoint(leftTopic.getStudentList(), rightTopic.getStudentList())) {
                            throw new IllegalStateException("PeriodPenalty (" + periodPenalty + ") for leftTopic (" + leftTopic + ") and rightTopic (" + rightTopic + ")'s left and right topic share students.");
                        }
                        if (this.coincidenceMap.get(leftTopic).contains(rightTopic)) {
                            this.logger.trace("  Filtering out periodPenalty (" + periodPenalty + ") for leftTopic (" + leftTopic + ") and rightTopic (" + rightTopic + ") because it is mentioned twice.");
                            ignorePenalty = true;
                            break;
                        }
                        boolean bl = added = this.coincidenceMap.get(leftTopic).add(rightTopic) && this.coincidenceMap.get(rightTopic).add(leftTopic);
                        if (added) break;
                        throw new IllegalStateException("The periodPenaltyType (" + (Object)((Object)periodPenaltyType) + ") for leftTopic (" + leftTopic + ") and rightTopic (" + rightTopic + ") was not successfully added twice.");
                    }
                    case EXCLUSION: {
                        boolean added;
                        if (leftTopic.getId().equals(rightTopic.getId())) {
                            this.logger.warn("  Filtering out periodPenalty (" + periodPenalty + ") for leftTopic (" + leftTopic + ") and rightTopic (" + rightTopic + ") because the left and right topic are the same.");
                            ignorePenalty = true;
                            break;
                        }
                        if (this.exclusionMap.get(leftTopic).contains(rightTopic)) {
                            this.logger.trace("  Filtering out periodPenalty (" + periodPenalty + ") for leftTopic (" + leftTopic + ") and rightTopic (" + rightTopic + ") because it is mentioned twice.");
                            ignorePenalty = true;
                            break;
                        }
                        boolean bl = added = this.exclusionMap.get(leftTopic).add(rightTopic) && this.exclusionMap.get(rightTopic).add(leftTopic);
                        if (added) break;
                        throw new IllegalStateException("The periodPenaltyType (" + (Object)((Object)periodPenaltyType) + ") for leftTopic (" + leftTopic + ") and rightTopic (" + rightTopic + ") was not successfully added twice.");
                    }
                    case AFTER: {
                        if (this.afterMap.get(leftTopic).contains(rightTopic)) {
                            ignorePenalty = true;
                            break;
                        }
                        boolean added = this.afterMap.get(leftTopic).add(rightTopic);
                        if (added) break;
                        throw new IllegalStateException("The periodPenaltyType (" + (Object)((Object)periodPenaltyType) + ") for leftTopic (" + leftTopic + ") and rightTopic (" + rightTopic + ") was not successfully added.");
                    }
                    default: {
                        throw new IllegalStateException("The periodPenaltyType (" + (Object)((Object)periodPenalty.getPeriodPenaltyType()) + ") is not implemented.");
                    }
                }
                if (!ignorePenalty) {
                    periodPenaltyList.add(periodPenalty);
                }
                line = this.bufferedReader.readLine();
            }
            for (Map.Entry<Topic, Set<Topic>> entry : this.coincidenceMap.entrySet()) {
                leftTopic = entry.getKey();
                Set<Topic> middleTopicSet = entry.getValue();
                for (Topic middleTopic : new ArrayList<Topic>(middleTopicSet)) {
                    for (Topic rightTopic : new ArrayList(this.coincidenceMap.get(middleTopic))) {
                        if (rightTopic == leftTopic || middleTopicSet.contains(rightTopic)) continue;
                        PeriodPenalty indirectPeriodPenalty = new PeriodPenalty();
                        indirectPeriodPenalty.setId(Long.valueOf(id));
                        ++id;
                        indirectPeriodPenalty.setPeriodPenaltyType(PeriodPenaltyType.EXAM_COINCIDENCE);
                        indirectPeriodPenalty.setLeftTopic(leftTopic);
                        indirectPeriodPenalty.setRightTopic(rightTopic);
                        periodPenaltyList.add(indirectPeriodPenalty);
                        boolean added = this.coincidenceMap.get(leftTopic).add(rightTopic) && this.coincidenceMap.get(rightTopic).add(leftTopic);
                        if (added) continue;
                        throw new IllegalStateException("The periodPenalty (" + indirectPeriodPenalty + ") for leftTopic (" + leftTopic + ") and rightTopic (" + rightTopic + ") was not successfully added twice.");
                    }
                }
            }
            for (Map.Entry<Topic, Set<Topic>> entry : this.afterMap.entrySet()) {
                leftTopic = entry.getKey();
                Set<Topic> afterLeftSet = entry.getValue();
                ArrayDeque<Topic> queue = new ArrayDeque<Topic>();
                for (Topic topic : this.afterMap.get(leftTopic)) {
                    queue.add(topic);
                    queue.addAll((Collection)this.coincidenceMap.get(topic));
                }
                while (!queue.isEmpty()) {
                    Topic rightTopic = (Topic)queue.poll();
                    if (!afterLeftSet.contains(rightTopic)) {
                        PeriodPenalty indirectPeriodPenalty = new PeriodPenalty();
                        indirectPeriodPenalty.setId(Long.valueOf(id));
                        ++id;
                        indirectPeriodPenalty.setPeriodPenaltyType(PeriodPenaltyType.AFTER);
                        indirectPeriodPenalty.setLeftTopic(leftTopic);
                        indirectPeriodPenalty.setRightTopic(rightTopic);
                        periodPenaltyList.add(indirectPeriodPenalty);
                        boolean added = this.afterMap.get(leftTopic).add(rightTopic);
                        if (!added) {
                            throw new IllegalStateException("The periodPenalty (" + indirectPeriodPenalty + ") for leftTopic (" + leftTopic + ") and rightTopic (" + rightTopic + ") was not successfully added.");
                        }
                    }
                    for (Topic topic : this.afterMap.get(rightTopic)) {
                        queue.add(topic);
                        queue.addAll((Collection)this.coincidenceMap.get(topic));
                    }
                }
            }
            this.examination.setPeriodPenaltyList(periodPenaltyList);
        }

        private void readRoomPenaltyList() throws IOException {
            List<Topic> topicList = this.examination.getTopicList();
            ArrayList<RoomPenalty> roomPenaltyList = new ArrayList<RoomPenalty>();
            String line = this.bufferedReader.readLine();
            int id = 0;
            while (!line.equals("[InstitutionalWeightings]")) {
                String[] lineTokens = line.split(ExaminationImporter.SPLIT_REGEX);
                if (lineTokens.length != 2) {
                    throw new IllegalArgumentException("Read line (" + line + ") is expected to contain 2 tokens.");
                }
                RoomPenalty roomPenalty = new RoomPenalty();
                roomPenalty.setId(Long.valueOf(id));
                roomPenalty.setTopic(topicList.get(Integer.parseInt(lineTokens[0])));
                roomPenalty.setRoomPenaltyType(RoomPenaltyType.valueOf(lineTokens[1]));
                roomPenaltyList.add(roomPenalty);
                line = this.bufferedReader.readLine();
                ++id;
            }
            this.examination.setRoomPenaltyList(roomPenaltyList);
        }

        private int readHeaderWithNumber(String header) throws IOException {
            String line = this.bufferedReader.readLine();
            if (!line.startsWith("[" + header + ":") || !line.endsWith("]")) {
                throw new IllegalStateException("Read line (" + line + " is not the expected header ([" + header + ":number])");
            }
            return Integer.parseInt(line.substring(header.length() + 2, line.length() - 1));
        }

        private void readInstitutionalWeighting() throws IOException {
            ExaminationConstraintConfiguration constraintConfiguration = new ExaminationConstraintConfiguration();
            constraintConfiguration.setId(0L);
            String[] lineTokens = this.readInstitutionalWeightingProperty("TWOINAROW", 2);
            constraintConfiguration.setTwoInARowPenalty(Integer.parseInt(lineTokens[1]));
            lineTokens = this.readInstitutionalWeightingProperty("TWOINADAY", 2);
            constraintConfiguration.setTwoInADayPenalty(Integer.parseInt(lineTokens[1]));
            lineTokens = this.readInstitutionalWeightingProperty("PERIODSPREAD", 2);
            constraintConfiguration.setPeriodSpreadLength(Integer.parseInt(lineTokens[1]));
            constraintConfiguration.setPeriodSpreadPenalty(1);
            lineTokens = this.readInstitutionalWeightingProperty("NONMIXEDDURATIONS", 2);
            constraintConfiguration.setMixedDurationPenalty(Integer.parseInt(lineTokens[1]));
            lineTokens = this.readInstitutionalWeightingProperty("FRONTLOAD", 4);
            constraintConfiguration.setFrontLoadLargeTopicSize(Integer.parseInt(lineTokens[1]));
            constraintConfiguration.setFrontLoadLastPeriodSize(Integer.parseInt(lineTokens[2]));
            constraintConfiguration.setFrontLoadPenalty(Integer.parseInt(lineTokens[3]));
            this.examination.setConstraintConfiguration(constraintConfiguration);
        }

        private String[] readInstitutionalWeightingProperty(String property, int propertySize) throws IOException {
            Object[] lineTokens = this.bufferedReader.readLine().split(ExaminationImporter.SPLIT_REGEX);
            if (!lineTokens[0].equals(property) || lineTokens.length != propertySize) {
                throw new IllegalArgumentException("Read line (" + Arrays.toString(lineTokens) + ") is expected to contain " + propertySize + " tokens and start with " + property + ".");
            }
            return lineTokens;
        }

        private void tagFrontLoadLargeTopics() {
            ArrayList<Topic> sortedTopicList = new ArrayList<Topic>(this.examination.getTopicList());
            Collections.sort(sortedTopicList, new Comparator<Topic>(){

                @Override
                public int compare(Topic a, Topic b) {
                    return new CompareToBuilder().append(a.getStudentSize(), b.getStudentSize()).append((Object)b.getId(), (Object)a.getId()).toComparison();
                }
            });
            int frontLoadLargeTopicSize = this.examination.getConstraintConfiguration().getFrontLoadLargeTopicSize();
            if (frontLoadLargeTopicSize == 0) {
                return;
            }
            int minimumTopicId = sortedTopicList.size() - frontLoadLargeTopicSize;
            if (minimumTopicId < 0) {
                this.logger.warn("The frontLoadLargeTopicSize (" + frontLoadLargeTopicSize + ") is bigger than topicListSize (" + sortedTopicList.size() + "). Tagging all topic as frontLoadLarge...");
                minimumTopicId = 0;
            }
            for (Topic topic : sortedTopicList.subList(minimumTopicId, sortedTopicList.size())) {
                topic.setFrontLoadLarge(true);
            }
        }

        private void tagFrontLoadLastPeriods() {
            List<Period> periodList = this.examination.getPeriodList();
            int frontLoadLastPeriodSize = this.examination.getConstraintConfiguration().getFrontLoadLastPeriodSize();
            if (frontLoadLastPeriodSize == 0) {
                return;
            }
            int minimumPeriodId = periodList.size() - frontLoadLastPeriodSize;
            if (minimumPeriodId < 0) {
                this.logger.warn("The frontLoadLastPeriodSize (" + frontLoadLastPeriodSize + ") is bigger than periodListSize (" + periodList.size() + "). Tagging all periods as frontLoadLast...");
                minimumPeriodId = 0;
            }
            for (Period period : periodList.subList(minimumPeriodId, periodList.size())) {
                period.setFrontLoadLast(true);
            }
        }

        private void createExamList() {
            List<Topic> topicList = this.examination.getTopicList();
            ArrayList<Exam> examList = new ArrayList<Exam>(topicList.size());
            HashMap<Topic, LeadingExam> leadingTopicToExamMap = new HashMap<Topic, LeadingExam>(topicList.size());
            Iterator<Topic> iterator = topicList.iterator();
            while (iterator.hasNext()) {
                Exam exam;
                Topic topic;
                Topic leadingTopic = topic = iterator.next();
                for (Topic coincidenceTopic : this.coincidenceMap.get(topic)) {
                    if (coincidenceTopic.getId() >= leadingTopic.getId()) continue;
                    leadingTopic = coincidenceTopic;
                }
                if (leadingTopic == topic) {
                    LeadingExam leadingExam = new LeadingExam();
                    leadingExam.setFollowingExamList(new ArrayList<FollowingExam>(10));
                    leadingTopicToExamMap.put(topic, leadingExam);
                    exam = leadingExam;
                } else {
                    FollowingExam followingExam = new FollowingExam();
                    LeadingExam leadingExam = (LeadingExam)leadingTopicToExamMap.get(leadingTopic);
                    if (leadingExam == null) {
                        throw new IllegalStateException("The followingExam (" + topic.getId() + ")'s leadingExam (" + leadingExam + ") cannot be null.");
                    }
                    followingExam.setLeadingExam(leadingExam);
                    leadingExam.getFollowingExamList().add(followingExam);
                    exam = followingExam;
                }
                exam.setId(topic.getId());
                exam.setTopic(topic);
                examList.add(exam);
            }
            this.examination.setExamList(examList);
        }
    }
}

