/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.pas.domain.solver;

import org.apache.commons.lang3.builder.CompareToBuilder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.examples.pas.domain.BedDesignation;
import org.optaplanner.examples.pas.domain.PatientAdmissionSchedule;
import org.optaplanner.examples.pas.domain.Room;

public class BedDesignationDifficultyWeightFactory
implements SelectionSorterWeightFactory<PatientAdmissionSchedule, BedDesignation> {
    public BedDesignationDifficultyWeight createSorterWeight(PatientAdmissionSchedule schedule, BedDesignation bedDesignation) {
        int hardDisallowedCount = 0;
        int softDisallowedCount = 0;
        for (Room room : schedule.getRoomList()) {
            hardDisallowedCount += room.countHardDisallowedAdmissionPart(bedDesignation.getAdmissionPart()) * room.getCapacity();
            softDisallowedCount += room.countSoftDisallowedAdmissionPart(bedDesignation.getAdmissionPart()) * room.getCapacity();
        }
        return new BedDesignationDifficultyWeight(bedDesignation, hardDisallowedCount, softDisallowedCount);
    }

    public static class BedDesignationDifficultyWeight
    implements Comparable<BedDesignationDifficultyWeight> {
        private final BedDesignation bedDesignation;
        private int requiredEquipmentCount;
        private int nightCount;
        private int hardDisallowedCount;
        private int softDisallowedCount;

        public BedDesignationDifficultyWeight(BedDesignation bedDesignation, int hardDisallowedCount, int softDisallowedCount) {
            this.bedDesignation = bedDesignation;
            this.requiredEquipmentCount = bedDesignation.getPatient().getRequiredPatientEquipmentList().size();
            this.nightCount = bedDesignation.getAdmissionPart().getNightCount();
            this.hardDisallowedCount = hardDisallowedCount;
            this.softDisallowedCount = softDisallowedCount;
        }

        @Override
        public int compareTo(BedDesignationDifficultyWeight other) {
            return new CompareToBuilder().append(this.requiredEquipmentCount * this.nightCount, other.requiredEquipmentCount * other.nightCount).append(this.hardDisallowedCount * this.nightCount, other.hardDisallowedCount * other.nightCount).append(this.nightCount, other.nightCount).append(this.softDisallowedCount * this.nightCount, other.softDisallowedCount * this.nightCount).append(other.bedDesignation.getAdmissionPart().getFirstNight().getIndex(), this.bedDesignation.getAdmissionPart().getFirstNight().getIndex()).append((Object)this.bedDesignation.getId(), (Object)other.bedDesignation.getId()).toComparison();
        }
    }
}

