/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.util.IoUtils;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;

public class ZipKieModule
extends AbstractKieModule
implements InternalKieModule,
Serializable {
    private File file;
    private Map<String, byte[]> zipEntries;
    private List<String> fileNames;
    private ZipFile zipFile = null;

    public ZipKieModule() {
    }

    public ZipKieModule(ReleaseId releaseId, KieModuleModel kieProject, File file) {
        super(releaseId, kieProject);
        this.file = file;
        this.indexZipFile(file);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isAvailable(String name) {
        return this.zipEntries.containsKey(name);
    }

    @Override
    public byte[] getBytes(String name) {
        return this.zipEntries.get(name);
    }

    @Override
    public Collection<String> getFileNames() {
        return this.fileNames;
    }

    @Override
    public byte[] getBytes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getCreationTimestamp() {
        return this.file.lastModified();
    }

    public String toString() {
        return "ZipKieModule[releaseId=" + this.getReleaseId() + ",file=" + this.file + "]";
    }

    private void indexZipFile(File jarFile) {
        Map<Object, Object> folders = new HashMap();
        this.zipEntries = new HashMap<String, byte[]>();
        this.fileNames = new ArrayList<String>();
        try {
            folders = this.processZipEntries(jarFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get all ZipFile entries: " + jarFile, e);
        }
        finally {
            if (this.zipFile != null) {
                try {
                    this.zipFile.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to get all ZipFile entries: " + jarFile, e);
                }
            }
        }
        for (Map.Entry<Object, Object> folder : folders.entrySet()) {
            StringBuilder sb = new StringBuilder();
            for (String child : (List)folder.getValue()) {
                sb.append(child).append("\n");
            }
            this.zipEntries.put((String)folder.getKey(), sb.toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, List<String>> processZipEntries(File jarFile) throws ZipException, IOException {
        HashMap<String, List<String>> folders = new HashMap<String, List<String>>();
        String urlPath = jarFile.getAbsolutePath();
        if (jarFile.exists()) {
            this.zipFile = new ZipFile(jarFile);
            Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                this.processEntry(entry, folders, true, () -> {
                    try {
                        return this.zipFile.getInputStream(entry);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        } else if (urlPath.indexOf(33) > 0) {
            urlPath = urlPath.substring(urlPath.lastIndexOf(33) + 1).replace("\\", "/");
            ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
            InputStream in = this.getClass().getResourceAsStream(urlPath);
            try (ZipInputStream zipIn = new ZipInputStream(in);){
                ZipEntry entry = zipIn.getNextEntry();
                while (entry != null) {
                    this.processEntry(entry, folders, false, () -> zipIn);
                    zipIn.closeEntry();
                    entries.add(entry);
                    entry = zipIn.getNextEntry();
                }
            }
        } else {
            throw new FileNotFoundException(urlPath);
        }
        return folders;
    }

    protected void processEntry(ZipEntry entry, Map<String, List<String>> folders, boolean closeEntryStream, Supplier<InputStream> stream) throws IOException {
        int lastSlashPos;
        String folderName;
        List<String> folder;
        if (entry.getName().endsWith(".dex")) {
            return;
        }
        String entryName = entry.getName();
        if (entry.isDirectory()) {
            if (entryName.endsWith("/")) {
                entryName = entryName.substring(0, entryName.length() - 1);
            }
        } else {
            byte[] bytes = IoUtils.readBytesFromInputStream((InputStream)stream.get(), (boolean)closeEntryStream);
            this.zipEntries.put(entryName, bytes);
            this.fileNames.add(entryName);
        }
        if ((folder = folders.get(folderName = (lastSlashPos = entryName.lastIndexOf(47)) < 0 ? "" : entryName.substring(0, lastSlashPos))) == null) {
            folder = new ArrayList<String>();
            folders.put(folderName, folder);
        }
        folder.add(lastSlashPos < 0 ? entryName : entryName.substring(lastSlashPos + 1));
    }
}

