/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools.testgen.fact;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.domain.common.accessor.ReflectionBeanPropertyMemberAccessor;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenEnumValueProvider;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenExistingInstanceValueProvider;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenFact;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenFactField;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenListValueProvider;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenMapValueProvider;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenNullValueProvider;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenParsedValueProvider;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenPrimitiveValueProvider;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenSetValueProvider;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenStringValueProvider;

public class TestGenValueFact
implements TestGenFact {
    private final Object instance;
    private final String instanceToString;
    private final String variableName;
    private final List<TestGenFactField> fields = new ArrayList<TestGenFactField>();

    public TestGenValueFact(int id, Object instance) {
        this.instance = instance;
        this.instanceToString = instance.toString();
        this.variableName = instance.getClass().getSimpleName().substring(0, 1).toLowerCase() + instance.getClass().getSimpleName().substring(1) + "_" + id;
    }

    @Override
    public void setUp(Map<Object, TestGenFact> existingInstances) {
        this.fields.clear();
        for (Class<?> clazz = this.instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                this.setUpField(field, existingInstances);
            }
        }
        Collections.sort(this.fields);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setUpField(Field field, Map<Object, TestGenFact> existingInstances) {
        String fieldName = field.getName();
        Method setter = ReflectionHelper.getSetterMethod(this.instance.getClass(), field.getType(), fieldName);
        Method getter = ReflectionHelper.getGetterMethod(this.instance.getClass(), fieldName);
        if (setter == null || getter == null) return;
        ReflectionBeanPropertyMemberAccessor accessor = new ReflectionBeanPropertyMemberAccessor(getter);
        Object value = accessor.executeGetter(this.instance);
        if (value != null) {
            if (field.getType().equals(String.class)) {
                this.fields.add(new TestGenFactField(this, fieldName, new TestGenStringValueProvider((String)value)));
                return;
            } else if (field.getType().isPrimitive()) {
                this.fields.add(new TestGenFactField(this, fieldName, new TestGenPrimitiveValueProvider(value)));
                return;
            } else if (field.getType().isEnum()) {
                this.fields.add(new TestGenFactField(this, fieldName, new TestGenEnumValueProvider((Enum)value)));
                return;
            } else if (existingInstances.containsKey(value)) {
                String id = existingInstances.get(value).toString();
                TestGenExistingInstanceValueProvider instanceProvider = new TestGenExistingInstanceValueProvider(value, id, existingInstances.get(value));
                this.fields.add(new TestGenFactField(this, fieldName, instanceProvider));
                return;
            } else if (field.getType().equals(List.class)) {
                String id = this.variableName + "_" + field.getName();
                Type[] typeArgs = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
                TestGenListValueProvider listValueProvider = new TestGenListValueProvider((List)value, id, typeArgs[0], existingInstances);
                this.fields.add(new TestGenFactField(this, fieldName, listValueProvider));
                return;
            } else if (field.getType().equals(Set.class)) {
                String id = this.variableName + "_" + field.getName();
                Type[] typeArgs = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
                TestGenSetValueProvider setValueProvider = new TestGenSetValueProvider((Set)value, id, typeArgs[0], existingInstances);
                this.fields.add(new TestGenFactField(this, fieldName, setValueProvider));
                return;
            } else if (field.getType().equals(Map.class)) {
                String id = this.variableName + "_" + field.getName();
                Type[] typeArgs = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
                TestGenMapValueProvider mapValueProvider = new TestGenMapValueProvider((Map)value, id, typeArgs, existingInstances);
                this.fields.add(new TestGenFactField(this, fieldName, mapValueProvider));
                return;
            } else {
                Method parseMethod = TestGenValueFact.getParseMethod(field);
                if (parseMethod == null) throw new IllegalStateException("Unsupported type: " + field);
                this.fields.add(new TestGenFactField(this, fieldName, new TestGenParsedValueProvider(parseMethod, value)));
            }
            return;
        } else {
            this.fields.add(new TestGenFactField(this, fieldName, new TestGenNullValueProvider()));
        }
    }

    static Method getParseMethod(Field f) {
        for (Method m : f.getType().getMethods()) {
            if (!Modifier.isStatic(m.getModifiers()) || !f.getType().equals(m.getReturnType()) || m.getParameters().length != 1 || !CharSequence.class.isAssignableFrom(m.getParameters()[0].getType()) || !m.getName().startsWith("parse") && !m.getName().startsWith("valueOf")) continue;
            return m;
        }
        return null;
    }

    @Override
    public Object getInstance() {
        return this.instance;
    }

    public String getVariableName() {
        return this.variableName;
    }

    @Override
    public List<TestGenFactField> getFields() {
        return this.fields;
    }

    @Override
    public List<TestGenFact> getDependencies() {
        return this.fields.stream().filter(TestGenFactField::isActive).flatMap(f -> f.getRequiredFacts().stream()).collect(Collectors.toList());
    }

    @Override
    public List<Class<?>> getImports() {
        List<Class<?>> imports = this.fields.stream().filter(TestGenFactField::isActive).flatMap(f -> f.getImports().stream()).collect(Collectors.toList());
        imports.add(this.instance.getClass());
        return imports;
    }

    @Override
    public void reset() {
        this.fields.forEach(TestGenFactField::reset);
    }

    @Override
    public void printInitialization(StringBuilder sb) {
        if (this.instance.getClass().isEnum()) {
            sb.append(String.format("        %s %s = %s.%s;\n", this.instance.getClass().getSimpleName(), this.variableName, this.instance.getClass().getSimpleName(), ((Enum)this.instance).name()));
        } else {
            sb.append(String.format("        %s %s = new %s();\n", this.instance.getClass().getSimpleName(), this.variableName, this.instance.getClass().getSimpleName()));
        }
    }

    @Override
    public void printSetup(StringBuilder sb) {
        sb.append(String.format("        //%s\n", this.instanceToString));
        this.fields.forEach(f -> f.print(sb));
    }

    public String toString() {
        return this.variableName;
    }
}

