/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NetworkNode;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.TupleSets;
import org.drools.core.common.TupleSetsImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.phreak.PhreakRuleTerminalNode;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.phreak.SegmentUtilities;
import org.drools.core.phreak.StackEntry;
import org.drools.core.reteoo.AbstractTerminalNode;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.SegmentNodeMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.drools.core.util.FastIterator;
import org.drools.core.util.LinkedList;
import org.kie.api.definition.rule.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddRemoveRule {
    private static final Logger log = LoggerFactory.getLogger(AddRemoveRule.class);

    public static void addRule(TerminalNode tn, Collection<InternalWorkingMemory> wms, InternalKnowledgeBase kBase) {
        boolean hasWms;
        if (log.isTraceEnabled()) {
            log.trace("Adding Rule {}", (Object)tn.getRule().getName());
        }
        boolean hasProtos = kBase.hasSegmentPrototypes();
        boolean bl = hasWms = !wms.isEmpty();
        if (!hasProtos && !hasWms) {
            return;
        }
        RuleImpl rule = tn.getRule();
        LeftTupleNode firstSplit = AddRemoveRule.getNetworkSplitPoint(tn);
        PathEndNodes pathEndNodes = AddRemoveRule.getPathEndNodes(kBase, firstSplit, tn, (Rule)rule, hasProtos, hasWms);
        for (InternalWorkingMemory wm : wms) {
            wm.flushPropagations();
            if (120 == firstSplit.getType() && firstSplit.getAssociationsSize() == 1) {
                AddRemoveRule.insertLiaFacts(firstSplit, wm);
                continue;
            }
            PathEndNodeMemories tnms = AddRemoveRule.getPathEndMemories(wm, pathEndNodes);
            if (tnms.subjectPmem == null) continue;
            Map<PathMemory, SegmentMemory[]> prevSmemsLookup = AddRemoveRule.reInitPathMemories(tnms.otherPmems, null);
            Set<SegmentMemory> smemsToNotify = AddRemoveRule.handleExistingPaths(tn, prevSmemsLookup, tnms.otherPmems, wm, ExistingPathStrategy.ADD_STRATEGY);
            AddRemoveRule.addNewPaths(wm, smemsToNotify, tnms.subjectPmems);
            AddRemoveRule.processLeftTuples(firstSplit, wm, true, (Rule)rule);
            AddRemoveRule.notifySegments(smemsToNotify, wm);
        }
        if (hasWms) {
            AddRemoveRule.insertFacts(pathEndNodes, wms);
        } else {
            for (PathEndNode node : pathEndNodes.otherEndNodes) {
                node.resetPathMemSpec(null);
            }
        }
    }

    public static void removeRule(TerminalNode tn, Collection<InternalWorkingMemory> wms, InternalKnowledgeBase kBase) {
        boolean hasWms;
        if (log.isTraceEnabled()) {
            log.trace("Removing Rule {}", (Object)tn.getRule().getName());
        }
        boolean hasProtos = kBase.hasSegmentPrototypes();
        boolean bl = hasWms = !wms.isEmpty();
        if (!hasProtos && !hasWms) {
            return;
        }
        RuleImpl rule = tn.getRule();
        LeftTupleNode firstSplit = AddRemoveRule.getNetworkSplitPoint(tn);
        PathEndNodes pathEndNodes = AddRemoveRule.getPathEndNodes(kBase, firstSplit, tn, (Rule)rule, hasProtos, hasWms);
        for (InternalWorkingMemory wm : wms) {
            wm.flushPropagations();
            PathEndNodeMemories tnms = AddRemoveRule.getPathEndMemories(wm, pathEndNodes);
            if (!tnms.subjectPmems.isEmpty()) {
                if (120 == firstSplit.getType() && firstSplit.getAssociationsSize() == 1) {
                    if (tnms.subjectPmem != null) {
                        AddRemoveRule.flushStagedTuples(firstSplit, tnms.subjectPmem, wm);
                    }
                    AddRemoveRule.processLeftTuples(firstSplit, wm, false, (Rule)tn.getRule());
                    AddRemoveRule.removeNewPaths(wm, tnms.subjectPmems);
                } else {
                    AddRemoveRule.flushStagedTuples(tn, tnms.subjectPmem, pathEndNodes, wm);
                    AddRemoveRule.processLeftTuples(firstSplit, wm, false, (Rule)tn.getRule());
                    AddRemoveRule.removeNewPaths(wm, tnms.subjectPmems);
                    Map<PathMemory, SegmentMemory[]> prevSmemsLookup = AddRemoveRule.reInitPathMemories(tnms.otherPmems, tn);
                    Set<SegmentMemory> smemsToNotify = AddRemoveRule.handleExistingPaths(tn, prevSmemsLookup, tnms.otherPmems, wm, ExistingPathStrategy.REMOVE_STRATEGY);
                    AddRemoveRule.notifySegments(smemsToNotify, wm);
                }
            }
            if (tnms.subjectPmem == null || !tnms.subjectPmem.isInitialized() || !tnms.subjectPmem.getRuleAgendaItem().isQueued()) continue;
            tnms.subjectPmem.getRuleAgendaItem().dequeue();
        }
    }

    private static Set<SegmentMemory> handleExistingPaths(TerminalNode tn, Map<PathMemory, SegmentMemory[]> prevSmemsLookup, List<PathMemory> pmems, InternalWorkingMemory wm, ExistingPathStrategy strategy) {
        HashSet<SegmentMemory> smemsToNotify = new HashSet<SegmentMemory>();
        HashSet<SegmentMemory> visitedSegments = new HashSet<SegmentMemory>();
        HashSet<LeftTupleNode> visitedNodes = new HashSet<LeftTupleNode>();
        HashMap<LeftTupleNode, SegmentMemory> nodeToSegmentMap = new HashMap<LeftTupleNode, SegmentMemory>();
        for (PathMemory pmem : pmems) {
            LeftTupleNode node;
            LeftTupleNode[] nodes = pmem.getPathEndNode().getPathNodes();
            SegmentMemory[] prevSmems = prevSmemsLookup.get(pmem);
            SegmentMemory[] smems = strategy.getSegmenMemories(pmem);
            int prevSmemIndex = 0;
            int smemIndex = 0;
            int smemSplitAdjustAmount = 0;
            int nodeIndex = 0;
            int nodeTypesInSegment = 0;
            smems[smemIndex] = prevSmems[prevSmemIndex];
            do {
                node = nodes[nodeIndex++];
                LeftTupleSource parentNode = node.getLeftTupleSource();
                nodeTypesInSegment = SegmentUtilities.updateNodeTypesMask(parentNode, nodeTypesInSegment);
                if (!AddRemoveRule.isSplit(parentNode)) continue;
                smemIndex = strategy.incSmemIndex1(smemIndex);
                prevSmemIndex = strategy.incPrevSmemIndex1(prevSmemIndex);
                if (AddRemoveRule.isSplit(parentNode, tn)) {
                    smemIndex = strategy.incSmemIndex2(smemIndex);
                    prevSmemIndex = strategy.incPrevSmemIndex2(prevSmemIndex);
                    smems[smemIndex] = prevSmems[prevSmemIndex];
                    if (smems[smemIndex] != null && smemSplitAdjustAmount > 0 && visitedSegments.add(smems[smemIndex])) {
                        strategy.adjustSegment(wm, smemsToNotify, smems[smemIndex], smemSplitAdjustAmount);
                    }
                } else {
                    strategy.handleSplit(pmem, prevSmems, smems, smemIndex, prevSmemIndex, parentNode, node, tn, visitedNodes, smemsToNotify, nodeToSegmentMap, wm);
                    ++smemSplitAdjustAmount;
                }
                SegmentUtilities.checkEagerSegmentCreation(parentNode, wm, nodeTypesInSegment);
                nodeTypesInSegment = 0;
            } while (!NodeTypeEnums.isEndNode(node));
            strategy.processSegmentMemories(smems, pmem);
        }
        return smemsToNotify;
    }

    private static void addNewPaths(InternalWorkingMemory wm, Set<SegmentMemory> smemsToNotify, List<PathMemory> pmems) {
        HashSet<LeftTupleSink> visited = new HashSet<LeftTupleSink>();
        block0: for (PathMemory pmem : pmems) {
            LeftTupleSink tipNode;
            LeftTupleNode child = tipNode = (LeftTupleSink)((Object)pmem.getPathEndNode());
            LeftTupleSource parent = tipNode.getLeftTupleSource();
            while (true) {
                Memory mem;
                if (visited.add((LeftTupleSink)child)) {
                    SegmentMemory sm;
                    if (parent != null && parent.getAssociationsSize() != 1 && child.getAssociationsSize() == 1) {
                        mem = wm.getNodeMemories().peekNodeMemory(parent);
                        if (mem != null && mem.getSegmentMemory() != null) {
                            sm = mem.getSegmentMemory();
                            if (sm.getFirst() != null && sm.size() < parent.getSinkPropagator().size()) {
                                LeftTupleSink[] sinks = parent.getSinkPropagator().getSinks();
                                for (int i = sm.size(); i < sinks.length; ++i) {
                                    SegmentMemory childSmem = SegmentUtilities.createChildSegment(wm, sinks[i]);
                                    sm.add(childSmem);
                                    pmem.setSegmentMemory(childSmem.getPos(), childSmem);
                                    smemsToNotify.add(childSmem);
                                }
                            }
                            AddRemoveRule.correctMemoryOnSplitsChanged(parent, null, wm);
                        }
                    } else {
                        mem = wm.getNodeMemories().peekNodeMemory(child);
                        if (mem != null && (sm = mem.getSegmentMemory()) != null && !sm.getPathMemories().contains(pmem)) {
                            sm.addPathMemory(pmem);
                            pmem.setSegmentMemory(sm.getPos(), sm);
                            sm.notifyRuleLinkSegment(wm, pmem);
                        }
                    }
                } else {
                    mem = wm.getNodeMemories().peekNodeMemory(child);
                    if (mem != null) {
                        mem.getSegmentMemory().notifyRuleLinkSegment(wm, pmem);
                    }
                }
                if (parent == null) continue block0;
                child = parent;
                parent = parent.getLeftTupleSource();
            }
        }
    }

    private static void removeNewPaths(InternalWorkingMemory wm, List<PathMemory> pmems) {
        HashSet<Integer> visitedNodes = new HashSet<Integer>();
        block0: for (PathMemory pmem : pmems) {
            LeftTupleSink tipNode;
            LeftTupleNode child = tipNode = (LeftTupleSink)((Object)pmem.getPathEndNode());
            LeftTupleSource parent = tipNode.getLeftTupleSource();
            while (true) {
                SegmentMemory sm;
                Memory mem;
                if (child.getAssociationsSize() == 1 && NodeTypeEnums.isBetaNode(child)) {
                    AddRemoveRule.deleteRightInputData(child, wm);
                }
                if (parent != null && parent.getAssociationsSize() != 1 && child.getAssociationsSize() == 1) {
                    if (!visitedNodes.contains(child.getId()) && (mem = wm.getNodeMemories().peekNodeMemory(parent)) != null && mem.getSegmentMemory() != null && (sm = mem.getSegmentMemory()).getFirst() != null) {
                        SegmentMemory childSm = wm.getNodeMemories().peekNodeMemory(child).getSegmentMemory();
                        sm.remove(childSm);
                    }
                } else {
                    mem = wm.getNodeMemories().peekNodeMemory(child);
                    if (mem != null && (sm = mem.getSegmentMemory()) != null && sm.getPathMemories().contains(pmem)) {
                        mem.getSegmentMemory().removePathMemory(pmem);
                    }
                }
                if (parent == null) continue block0;
                visitedNodes.add(child.getId());
                child = parent;
                parent = parent.getLeftTupleSource();
            }
        }
    }

    private static boolean isSplit(LeftTupleNode node) {
        return AddRemoveRule.isSplit(node, null);
    }

    private static boolean isSplit(LeftTupleNode node, TerminalNode removingTN) {
        return node != null && SegmentUtilities.isTipNode(node, removingTN);
    }

    private static void flushStagedTuples(TerminalNode tn, PathMemory pmem, PathEndNodes pathEndNodes, InternalWorkingMemory wm) {
        if (pmem.isInitialized()) {
            RuleNetworkEvaluator.INSTANCE.evaluateNetwork(pmem, pmem.getRuleAgendaItem().getRuleExecutor(), wm);
        }
        ArrayList<Flushed> flushed = new ArrayList<Flushed>();
        for (LeftTupleNode node : pathEndNodes.subjectSplits) {
            SegmentMemory smem;
            Memory mem;
            if (AddRemoveRule.isSplit(node, tn) || (mem = wm.getNodeMemories().peekNodeMemory(node)) == null || (smem = mem.getSegmentMemory()).isEmpty()) continue;
            for (SegmentMemory childSmem = (SegmentMemory)smem.getFirst(); childSmem != null; childSmem = childSmem.getNext()) {
                if (childSmem.getStagedLeftTuples().isEmpty()) continue;
                PathMemory childPmem = childSmem.getPathMemories().get(0);
                flushed.add(new Flushed(childSmem, childPmem));
                AddRemoveRule.forceFlushLeftTuple(childPmem, childSmem, wm, childSmem.getStagedLeftTuples().takeAll());
            }
        }
        int flushCount = 1;
        while (!flushed.isEmpty() && flushCount != 0) {
            flushCount = 0;
            for (Flushed path : flushed) {
                if (path.segmentMemory.getStagedLeftTuples().isEmpty()) continue;
                ++flushCount;
                AddRemoveRule.forceFlushLeftTuple(pmem, path.segmentMemory, wm, path.segmentMemory.getStagedLeftTuples().takeAll());
            }
        }
    }

    private static void flushStagedTuples(LeftTupleNode splitStartNode, PathMemory pmem, InternalWorkingMemory wm) {
        if (!pmem.isInitialized()) {
            return;
        }
        int smemIndex = AddRemoveRule.getSegmentPos(splitStartNode);
        SegmentMemory[] smems = pmem.getSegmentMemories();
        SegmentMemory sm = null;
        int length = smems.length;
        if (splitStartNode.getAssociationsSize() == 1) {
            length = 1;
        }
        while (smemIndex < length && ((sm = smems[smemIndex]) == null || sm.getStagedLeftTuples().isEmpty())) {
            ++smemIndex;
        }
        if (smemIndex < length) {
            AddRemoveRule.forceFlushLeftTuple(pmem, sm, wm, sm.getStagedLeftTuples().takeAll());
        }
    }

    public static boolean flushLeftTupleIfNecessary(InternalWorkingMemory wm, SegmentMemory sm, boolean streamMode) {
        return AddRemoveRule.flushLeftTupleIfNecessary(wm, sm, null, streamMode, (short)0);
    }

    public static boolean flushLeftTupleIfNecessary(InternalWorkingMemory wm, SegmentMemory sm, LeftTuple leftTuple, boolean streamMode, short stagedType) {
        PathMemory pmem;
        PathMemory pathMemory = pmem = streamMode ? sm.getPathMemories().get(0) : sm.getFirstDataDrivenPathMemory();
        if (pmem == null) {
            return false;
        }
        TupleSetsImpl<LeftTuple> leftTupleSets = new TupleSetsImpl<LeftTuple>();
        if (leftTuple != null) {
            switch (stagedType) {
                case 1: {
                    leftTupleSets.addInsert(leftTuple);
                    break;
                }
                case 3: {
                    leftTupleSets.addDelete(leftTuple);
                    break;
                }
                case 2: {
                    leftTupleSets.addUpdate(leftTuple);
                }
            }
        }
        AddRemoveRule.forceFlushLeftTuple(pmem, sm, wm, leftTupleSets);
        if (pmem.isDataDriven() && pmem.getNodeType() == 71) {
            for (PathEndNode pnode : pmem.getPathEndNode().getPathEndNodes()) {
                SegmentMemory outSmem;
                PathMemory outPmem;
                if (!(pnode instanceof TerminalNode) || !(outPmem = wm.getNodeMemory((TerminalNode)((Object)pnode))).isDataDriven() || (outSmem = outPmem.getSegmentMemories()[0]) == null) continue;
                AddRemoveRule.forceFlushLeftTuple(outPmem, outSmem, wm, new TupleSetsImpl<LeftTuple>());
            }
        }
        return true;
    }

    public static void forceFlushLeftTuple(PathMemory pmem, SegmentMemory sm, InternalWorkingMemory wm, TupleSets<LeftTuple> leftTupleSets) {
        Memory mem;
        LeftTupleNode node;
        SegmentMemory[] smems = pmem.getSegmentMemories();
        long bit = 1L;
        if (sm.getRootNode().getType() == 120 && sm.getTipNode().getType() != 120) {
            node = sm.getRootNode().getSinkPropagator().getFirstLeftTupleSink();
            mem = sm.getNodeMemories().get(1);
            bit = 2L;
        } else {
            node = sm.getRootNode();
            mem = sm.getNodeMemories().get(0);
        }
        PathMemory rtnPmem = NodeTypeEnums.isTerminalNode(pmem.getPathEndNode()) ? pmem : wm.getNodeMemory((AbstractTerminalNode)pmem.getPathEndNode().getPathEndNodes()[0]);
        InternalAgenda agenda = pmem.getActualAgenda(wm);
        RuleNetworkEvaluator.INSTANCE.outerEval(pmem, node, bit, mem, smems, sm.getPos(), leftTupleSets, agenda, new LinkedList<StackEntry>(), true, rtnPmem.getOrCreateRuleAgendaItem(agenda).getRuleExecutor());
    }

    private static Map<PathMemory, SegmentMemory[]> reInitPathMemories(List<PathMemory> pathMems, TerminalNode removingTN) {
        HashMap<PathMemory, SegmentMemory[]> previousSmems = new HashMap<PathMemory, SegmentMemory[]>();
        for (PathMemory pmem : pathMems) {
            previousSmems.put(pmem, pmem.getSegmentMemories());
            LeftTupleSource startRianLts = null;
            if (!NodeTypeEnums.isTerminalNode(pmem.getPathEndNode())) {
                RightInputAdapterNode rian = (RightInputAdapterNode)pmem.getPathEndNode();
                startRianLts = rian.getStartTupleSource();
            }
            PathEndNode pathEndNode = pmem.getPathEndNode();
            pathEndNode.resetPathMemSpec(removingTN);
            AbstractTerminalNode.initPathMemory(pathEndNode, pmem);
        }
        return previousSmems;
    }

    private static void notifySegments(Set<SegmentMemory> smems, InternalWorkingMemory wm) {
        for (SegmentMemory sm : smems) {
            sm.notifyRuleLinkSegment(wm);
        }
    }

    private static void correctMemoryOnSplitsChanged(LeftTupleNode splitStart, TerminalNode removingTN, InternalWorkingMemory wm) {
        QueryElementNode.QueryElementNodeMemory mem;
        if (splitStart.getType() == 165 && (mem = (QueryElementNode.QueryElementNodeMemory)wm.getNodeMemories().peekNodeMemory(splitStart)) != null) {
            mem.correctMemoryOnSinksChanged(removingTN);
        }
    }

    public static void correctSegmentMemoryAfterSplitOnAdd(SegmentMemory sm) {
        AddRemoveRule.correctSegmentMemoryAfterSplitOnAdd(sm, 1);
    }

    public static void correctSegmentMemoryAfterSplitOnAdd(SegmentMemory sm, int i) {
        sm.setPos(sm.getPos() + i);
        sm.setSegmentPosMaskBit(sm.getSegmentPosMaskBit() << i);
    }

    public static void correctSegmentMemoryAfterSplitOnRemove(SegmentMemory sm, int i) {
        sm.setPos(sm.getPos() - i);
        sm.setSegmentPosMaskBit(sm.getSegmentPosMaskBit() >> i);
    }

    private static int getSegmentPos(LeftTupleNode lts) {
        int counter = 0;
        while (lts.getType() != 120) {
            if (!SegmentUtilities.isTipNode(lts = lts.getLeftTupleSource(), null)) continue;
            ++counter;
        }
        return counter;
    }

    private static void insertLiaFacts(LeftTupleNode startNode, InternalWorkingMemory wm) {
        PropagationContextFactory pctxFactory = wm.getKnowledgeBase().getConfiguration().getComponentFactory().getPropagationContextFactory();
        PropagationContext pctx = pctxFactory.createPropagationContext(wm.getNextPropagationIdCounter(), PropagationContext.Type.RULE_ADDITION, null, null, null);
        LeftInputAdapterNode lian = (LeftInputAdapterNode)startNode;
        LeftInputAdapterNode.RightTupleSinkAdapter liaAdapter = new LeftInputAdapterNode.RightTupleSinkAdapter(lian);
        lian.getObjectSource().updateSink(liaAdapter, pctx, wm);
    }

    private static void insertFacts(PathEndNodes endNodes, Collection<InternalWorkingMemory> wms) {
        HashSet<LeftTupleNode> visited = new HashSet<LeftTupleNode>();
        for (PathEndNode endNode : endNodes.subjectEndNodes) {
            LeftTupleNode[] nodes = endNode.getPathNodes();
            for (int i = 0; i < nodes.length; ++i) {
                BetaNode bn;
                LeftTupleNode node = nodes[i];
                if (!NodeTypeEnums.isBetaNode(node) || node.getAssociationsSize() != 1 || !visited.add(node) || (bn = (BetaNode)node).isRightInputIsRiaNode()) continue;
                for (InternalWorkingMemory wm : wms) {
                    PropagationContextFactory pctxFactory = wm.getKnowledgeBase().getConfiguration().getComponentFactory().getPropagationContextFactory();
                    PropagationContext pctx = pctxFactory.createPropagationContext(wm.getNextPropagationIdCounter(), PropagationContext.Type.RULE_ADDITION, null, null, null);
                    bn.getRightInput().updateSink(bn, pctx, wm);
                }
            }
        }
    }

    private static void deleteRightInputData(LeftTupleSink node, InternalWorkingMemory wm) {
        if (wm.getNodeMemories().peekNodeMemory(node) != null) {
            BetaNode bn = (BetaNode)node;
            BetaMemory bm = bn.getType() == 211 ? ((AccumulateNode.AccumulateMemory)wm.getNodeMemory(bn)).getBetaMemory() : (BetaMemory)wm.getNodeMemory(bn);
            TupleMemory rtm = bm.getRightTupleMemory();
            FastIterator it = rtm.fullFastIterator();
            Tuple rightTuple = BetaNode.getFirstTuple(rtm, it);
            while (rightTuple != null) {
                Tuple next = (Tuple)it.next(rightTuple);
                rtm.remove(rightTuple);
                rightTuple.unlinkFromRightParent();
                rightTuple = next;
            }
            if (!bm.getStagedRightTuples().isEmpty()) {
                bm.setNodeDirtyWithoutNotify();
            }
            TupleSets<RightTuple> srcRightTuples = bm.getStagedRightTuples().takeAll();
            AddRemoveRule.unlinkRightTuples(srcRightTuples.getInsertFirst());
            AddRemoveRule.unlinkRightTuples(srcRightTuples.getUpdateFirst());
            AddRemoveRule.unlinkRightTuples(srcRightTuples.getDeleteFirst());
            AddRemoveRule.deleteFactsFromRightInput(bn, wm);
        }
    }

    private static void deleteFactsFromRightInput(BetaNode bn, InternalWorkingMemory wm) {
        ObjectSource source = bn.getRightInput();
        if (source instanceof WindowNode) {
            WindowNode.WindowMemory memory = wm.getNodeMemory((WindowNode)source);
            for (EventFactHandle factHandle : memory.getFactHandles()) {
                factHandle.forEachRightTuple(rt -> {
                    if (source.equals(rt.getTupleSink())) {
                        rt.unlinkFromRightParent();
                    }
                });
            }
        }
    }

    private static void unlinkRightTuples(RightTuple rightTuple) {
        RightTuple rt = rightTuple;
        while (rt != null) {
            RightTuple next = (RightTuple)rt.getStagedNext();
            if (rt.getFactHandle() != null) {
                rt.unlinkFromRightParent();
            }
            rt = next;
        }
    }

    private static void processLeftTuples(LeftTupleNode node, InternalWorkingMemory wm, boolean insert, Rule rule) {
        Memory memory = wm.getNodeMemories().peekNodeMemory(node);
        if (memory == null || memory.getSegmentMemory() == null) {
            return;
        }
        SegmentMemory sm = memory.getSegmentMemory();
        while (120 != node.getType()) {
            if (NodeTypeEnums.isBetaNode(node)) {
                if (211 == node.getType()) {
                    AccumulateNode.AccumulateMemory am = (AccumulateNode.AccumulateMemory)memory;
                    BetaMemory bm = am.getBetaMemory();
                    FastIterator it = bm.getLeftTupleMemory().fullFastIterator();
                    Tuple lt2 = BetaNode.getFirstTuple(bm.getLeftTupleMemory(), it);
                    while (lt2 != null) {
                        AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)lt2.getContextObject();
                        AddRemoveRule.visitChild(accctx.getResultLeftTuple(), insert, wm, rule);
                        lt2 = (LeftTuple)it.next(lt2);
                    }
                } else if (201 == node.getType()) {
                    BetaMemory bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)((Object)node));
                    FastIterator it = bm.getRightTupleMemory().fullFastIterator();
                    RightTuple rt = (RightTuple)BetaNode.getFirstTuple(bm.getRightTupleMemory(), it);
                    while (rt != null) {
                        for (LeftTuple lt3 = rt.getBlocked(); lt3 != null; lt3 = lt3.getBlockedNext()) {
                            AddRemoveRule.visitChild(wm, insert, rule, it, lt3);
                        }
                        rt = (RightTuple)it.next(rt);
                    }
                } else {
                    BetaMemory bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)((Object)node));
                    FastIterator it = bm.getLeftTupleMemory().fullFastIterator();
                    Tuple lt4 = BetaNode.getFirstTuple(bm.getLeftTupleMemory(), it);
                    AddRemoveRule.visitChild(wm, insert, rule, it, lt4);
                }
                return;
            }
            if (151 == node.getType()) {
                FromNode.FromMemory fm = (FromNode.FromMemory)wm.getNodeMemory((MemoryFactory)((Object)node));
                TupleMemory ltm = fm.getBetaMemory().getLeftTupleMemory();
                FastIterator it = ltm.fullFastIterator();
                LeftTuple lt5 = (LeftTuple)ltm.getFirst(null);
                while (lt5 != null) {
                    AddRemoveRule.visitChild(lt5, insert, wm, rule);
                    lt5 = (LeftTuple)it.next(lt5);
                }
                return;
            }
            if (sm.getRootNode() == node) {
                sm = wm.getNodeMemory((MemoryFactory)((Object)node.getLeftTupleSource())).getSegmentMemory();
            }
            node = node.getLeftTupleSource();
        }
        LeftInputAdapterNode lian = (LeftInputAdapterNode)node;
        ObjectSource os = lian.getObjectSource();
        while (os.getType() != 30) {
            os = os.getParentObjectSource();
        }
        ObjectTypeNode otn = (ObjectTypeNode)os;
        ObjectTypeNode.ObjectTypeNodeMemory omem = wm.getNodeMemory(otn);
        if (omem == null) {
            return;
        }
        Iterator<InternalFactHandle> it = omem.iterator();
        while (it.hasNext()) {
            InternalFactHandle fh = it.next();
            fh.forEachLeftTuple(lt -> {
                LeftTuple nextLt = (LeftTuple)lt.getHandleNext();
                if (lt.getTupleSource().isAssociatedWith(rule)) {
                    AddRemoveRule.visitChild(lt, insert, wm, rule);
                    if (lt.getHandlePrevious() != null) {
                        lt.getHandlePrevious().setHandleNext(nextLt);
                        if (nextLt != null) {
                            nextLt.setHandlePrevious((Tuple)lt.getHandlePrevious());
                        }
                    }
                }
            });
        }
    }

    private static void visitChild(InternalWorkingMemory wm, boolean insert, Rule rule, FastIterator it, Tuple lt) {
        while (lt != null) {
            LeftTuple childLt = lt.getFirstChild();
            while (childLt != null) {
                LeftTuple nextLt = (LeftTuple)childLt.getHandleNext();
                AddRemoveRule.visitChild(childLt, insert, wm, rule);
                childLt = nextLt;
            }
            lt = (LeftTuple)it.next(lt);
        }
    }

    private static void visitChild(LeftTuple lt, boolean insert, InternalWorkingMemory wm, Rule rule) {
        LeftTuple prevLt = null;
        for (LeftTupleSinkNode sink = (LeftTupleSinkNode)lt.getTupleSink(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            block4: {
                block5: {
                    block6: {
                        block7: {
                            if (lt == null) break block4;
                            if (!lt.getTupleSink().isAssociatedWith(rule)) break block5;
                            if (lt.getTupleSink().getAssociationsSize() <= 1) break block6;
                            if (lt.getFirstChild() == null) break block7;
                            for (LeftTuple child = lt.getFirstChild(); child != null; child = (LeftTuple)child.getHandleNext()) {
                                AddRemoveRule.visitChild(child, insert, wm, rule);
                            }
                            break block5;
                        }
                        if (lt.getTupleSink().getType() != 71) break block5;
                        AddRemoveRule.insertPeerRightTuple(lt, wm, rule, insert);
                        break block5;
                    }
                    if (!insert) {
                        AddRemoveRule.iterateLeftTuple(lt, wm);
                        LeftTuple lt2 = null;
                        for (LeftTuple peerLt = lt.getPeer(); peerLt != null && peerLt.getTupleSink().isAssociatedWith(rule) && peerLt.getTupleSink().getAssociationsSize() == 1; peerLt = peerLt.getPeer()) {
                            AddRemoveRule.iterateLeftTuple(peerLt, wm);
                            lt2 = peerLt;
                        }
                        AddRemoveRule.deleteLeftTuple(lt, lt2, prevLt);
                        break;
                    }
                }
                prevLt = lt;
                lt = lt.getPeer();
                continue;
            }
            prevLt = AddRemoveRule.insertPeerLeftTuple(prevLt, sink, wm);
        }
    }

    private static void insertPeerRightTuple(LeftTuple lt, InternalWorkingMemory wm, Rule rule, boolean insert) {
        LeftTuple prevLt = null;
        RightInputAdapterNode rian = (RightInputAdapterNode)lt.getTupleSink();
        for (ObjectSink sink : rian.getObjectSinkPropagator().getSinks()) {
            if (lt != null) {
                if (prevLt != null && !insert && sink.isAssociatedWith(rule) && sink.getAssociationsSize() == 1) {
                    prevLt.setPeer(null);
                }
                prevLt = lt;
                lt = lt.getPeer();
                continue;
            }
            if (!insert) continue;
            BetaMemory bm = (BetaMemory)wm.getNodeMemory((BetaNode)sink);
            prevLt = rian.createPeer(prevLt);
            bm.linkNode((BetaNode)sink, wm);
            bm.getStagedRightTuples().addInsert((RightTuple)((Object)prevLt));
        }
    }

    private static LeftTuple insertPeerLeftTuple(LeftTuple lt, LeftTupleSinkNode node, InternalWorkingMemory wm) {
        LeftInputAdapterNode.LiaNodeMemory liaMem = null;
        if (node.getLeftTupleSource().getType() == 120) {
            liaMem = wm.getNodeMemory((LeftInputAdapterNode)node.getLeftTupleSource());
        }
        LeftTuple peer = node.createPeer(lt);
        Memory memory = wm.getNodeMemories().peekNodeMemory(node);
        if (memory == null || memory.getSegmentMemory() == null) {
            throw new IllegalStateException("Defensive Programming: this should not be possilbe, as the addRule code should init child segments if they are needed ");
        }
        if (liaMem == null) {
            memory.getSegmentMemory().getStagedLeftTuples().addInsert(peer);
        } else {
            LeftInputAdapterNode.doInsertSegmentMemory(wm, true, liaMem, memory.getSegmentMemory(), peer, node.getLeftTupleSource().isStreamMode());
        }
        return peer;
    }

    private static void iterateLeftTuple(LeftTuple lt, InternalWorkingMemory wm) {
        if (NodeTypeEnums.isTerminalNode(lt.getTupleSink())) {
            PathMemory pmem = (PathMemory)wm.getNodeMemories().peekNodeMemory((NetworkNode)lt.getTupleSink());
            if (pmem != null) {
                PhreakRuleTerminalNode.doLeftDelete(pmem.getActualAgenda(wm), pmem.getRuleAgendaItem().getRuleExecutor(), lt);
            }
        } else {
            if (lt.getContextObject() instanceof AccumulateNode.AccumulateContext) {
                AddRemoveRule.iterateLeftTuple(((AccumulateNode.AccumulateContext)lt.getContextObject()).getResultLeftTuple(), wm);
            }
            for (LeftTuple child = lt.getFirstChild(); child != null; child = (LeftTuple)child.getHandleNext()) {
                for (LeftTuple peer = child; peer != null; peer = peer.getPeer()) {
                    if (peer.getPeer() != null) continue;
                    AddRemoveRule.iterateLeftTuple(peer, wm);
                }
            }
        }
    }

    private static void deleteLeftTuple(LeftTuple removingLt, LeftTuple removingLt2, LeftTuple prevLt) {
        LeftTuple nextPeerLt;
        boolean isFirstLt = prevLt == null;
        LeftTuple leftTuple = nextPeerLt = removingLt2 == null ? removingLt.getPeer() : removingLt2.getPeer();
        if (!isFirstLt) {
            prevLt.setPeer(nextPeerLt);
        } else {
            if (nextPeerLt == null) {
                removingLt.unlinkFromLeftParent();
                removingLt.unlinkFromRightParent();
                return;
            }
            InternalFactHandle fh = removingLt.getFactHandle();
            LeftTuple leftPrevious = (LeftTuple)removingLt.getHandlePrevious();
            LeftTuple leftNext = (LeftTuple)removingLt.getHandleNext();
            LeftTuple rightPrevious = removingLt.getRightParentPrevious();
            LeftTuple rightNext = removingLt.getRightParentNext();
            LeftTuple leftParent = removingLt.getLeftParent();
            RightTuple rightParent = removingLt.getRightParent();
            nextPeerLt.setFactHandle(removingLt.getFactHandle());
            if (leftPrevious != null) {
                nextPeerLt.setHandlePrevious(leftPrevious);
                leftPrevious.setHandleNext(nextPeerLt);
            }
            if (leftNext != null) {
                nextPeerLt.setHandleNext(leftNext);
                leftNext.setHandlePrevious(nextPeerLt);
            }
            if (rightPrevious != null) {
                nextPeerLt.setRightParentPrevious(rightPrevious);
                rightPrevious.setRightParentNext(nextPeerLt);
            }
            if (rightNext != null) {
                nextPeerLt.setRightParentNext(rightNext);
                rightNext.setRightParentPrevious(nextPeerLt);
            }
            if (leftParent != null) {
                nextPeerLt.setLeftParent(leftParent);
                if (leftParent.getFirstChild() == removingLt) {
                    leftParent.setFirstChild(nextPeerLt);
                }
                if (leftParent.getLastChild() == removingLt) {
                    leftParent.setLastChild(nextPeerLt);
                }
            } else {
                fh.removeLeftTuple(removingLt);
                if (leftPrevious == null) {
                    fh.addFirstLeftTuple(nextPeerLt);
                }
            }
            if (rightParent != null) {
                nextPeerLt.setRightParent(rightParent);
                if (rightParent.getFirstChild() == removingLt) {
                    rightParent.setFirstChild(nextPeerLt);
                }
                if (rightParent.getLastChild() == removingLt) {
                    rightParent.setLastChild(nextPeerLt);
                }
            }
        }
    }

    private static LeftTupleNode getNetworkSplitPoint(LeftTupleNode node) {
        while (node.getType() != 120 && node.getAssociationsSize() == 1) {
            node = node.getLeftTupleSource();
        }
        return node;
    }

    public static SegmentMemory splitSegment(InternalWorkingMemory wm, SegmentMemory sm1, LeftTupleNode splitNode) {
        LeftTupleSinkNode childNode = splitNode.getSinkPropagator().getFirstLeftTupleSink();
        SegmentMemory sm2 = new SegmentMemory(childNode);
        wm.getNodeMemories().peekNodeMemory(childNode).setSegmentMemory(sm2);
        if (sm1.getFirst() != null) {
            SegmentMemory sm = (SegmentMemory)sm1.getFirst();
            while (sm != null) {
                SegmentMemory next = sm.getNext();
                sm1.remove(sm);
                sm2.add(sm);
                sm = next;
            }
        }
        sm1.add(sm2);
        sm2.setPos(sm1.getPos());
        sm2.setSegmentPosMaskBit(sm1.getSegmentPosMaskBit());
        sm2.setLinkedNodeMask(sm1.getLinkedNodeMask());
        sm2.mergePathMemories(sm1);
        sm2.setTipNode(sm1.getTipNode());
        sm1.setTipNode(splitNode);
        if (sm1.getTipNode().getType() == 120 && !sm1.getStagedLeftTuples().isEmpty()) {
            sm2.getStagedLeftTuples().addAll(sm1.getStagedLeftTuples());
        }
        int pos = AddRemoveRule.nodeSegmentPosition(sm1, splitNode);
        AddRemoveRule.splitNodeMemories(sm1, sm2, pos);
        AddRemoveRule.splitBitMasks(sm1, sm2, pos);
        AddRemoveRule.correctSegmentMemoryAfterSplitOnAdd(sm2);
        return sm2;
    }

    private static void mergeSegment(SegmentMemory sm1, SegmentMemory sm2) {
        if (sm1.getTipNode().getType() == 120 && !sm2.getStagedLeftTuples().isEmpty()) {
            sm1.getStagedLeftTuples().addAll(sm2.getStagedLeftTuples());
        }
        if (sm1.contains(sm2)) {
            sm1.remove(sm2);
        }
        if (sm2.getFirst() != null) {
            SegmentMemory sm = (SegmentMemory)sm2.getFirst();
            while (sm != null) {
                SegmentMemory next = sm.getNext();
                sm2.remove(sm);
                sm1.add(sm);
                sm = next;
            }
        }
        sm1.setTipNode(sm2.getTipNode());
        AddRemoveRule.mergeNodeMemories(sm1, sm2);
        AddRemoveRule.mergeBitMasks(sm1, sm2);
    }

    private static void splitBitMasks(SegmentMemory sm1, SegmentMemory sm2, int pos) {
        int splitPos = pos + 1;
        long currentAllLinkedMaskTest = sm1.getAllLinkedMaskTest();
        long currentLinkedNodeMask = sm1.getLinkedNodeMask();
        long mask = (1L << splitPos) - 1L;
        sm1.setAllLinkedMaskTest(mask & currentAllLinkedMaskTest);
        sm1.setLinkedNodeMask(sm1.getLinkedNodeMask() & sm1.getAllLinkedMaskTest());
        mask = currentAllLinkedMaskTest >> splitPos;
        sm2.setAllLinkedMaskTest(mask);
        sm2.setLinkedNodeMask(mask & currentLinkedNodeMask >> splitPos);
    }

    private static void mergeBitMasks(SegmentMemory sm1, SegmentMemory sm2) {
        LinkedList<Memory> smNodeMemories2 = sm2.getNodeMemories();
        long mask = sm2.getAllLinkedMaskTest() << smNodeMemories2.size();
        sm1.setAllLinkedMaskTest(mask & sm1.getAllLinkedMaskTest());
        mask = sm2.getAllLinkedMaskTest() << smNodeMemories2.size();
        sm1.setLinkedNodeMask(mask & sm1.getLinkedNodeMask());
    }

    private static void splitNodeMemories(SegmentMemory sm1, SegmentMemory sm2, int pos) {
        LinkedList<Memory> smNodeMemories1 = sm1.getNodeMemories();
        LinkedList<Memory> smNodeMemories2 = sm2.getNodeMemories();
        Memory mem = smNodeMemories1.getFirst();
        int nodePosMask = 1;
        int length = smNodeMemories1.size();
        for (int i = 0; i < length; ++i) {
            Memory next = (Memory)mem.getNext();
            if (i > pos) {
                smNodeMemories1.remove(mem);
                smNodeMemories2.add(mem);
                mem.setSegmentMemory(sm2);
                if (mem instanceof SegmentNodeMemory) {
                    ((SegmentNodeMemory)mem).setNodePosMaskBit(nodePosMask);
                }
                nodePosMask <<= 1;
            }
            mem = next;
        }
    }

    private static void mergeNodeMemories(SegmentMemory sm1, SegmentMemory sm2) {
        LinkedList<Memory> smNodeMemories1 = sm1.getNodeMemories();
        LinkedList<Memory> smNodeMemories2 = sm2.getNodeMemories();
        int nodePosMask = 1;
        int length = smNodeMemories1.size();
        for (int i = 0; i < length; ++i) {
            nodePosMask >>= 1;
        }
        Memory mem = smNodeMemories2.getFirst();
        while (mem != null) {
            Memory next = (Memory)mem.getNext();
            smNodeMemories2.remove(mem);
            smNodeMemories1.add(mem);
            mem.setSegmentMemory(sm1);
            if (mem instanceof SegmentNodeMemory) {
                ((SegmentNodeMemory)mem).setNodePosMaskBit(nodePosMask);
            }
            nodePosMask >>= 1;
            mem = next;
        }
    }

    private static int nodeSegmentPosition(SegmentMemory sm1, LeftTupleNode splitNode) {
        LeftTupleNode lt = splitNode;
        int nodePos = 0;
        while (lt != sm1.getRootNode()) {
            lt = lt.getLeftTupleSource();
            ++nodePos;
        }
        return nodePos;
    }

    private static PathEndNodeMemories getPathEndMemories(InternalWorkingMemory wm, PathEndNodes pathEndNodes) {
        PathMemory pmem;
        RightInputAdapterNode.RiaNodeMemory riaMem;
        PathEndNodeMemories tnMems = new PathEndNodeMemories();
        for (LeftTupleNode leftTupleNode : pathEndNodes.otherEndNodes) {
            if (leftTupleNode.getType() == 71) {
                riaMem = (RightInputAdapterNode.RiaNodeMemory)wm.getNodeMemories().peekNodeMemory(leftTupleNode);
                if (riaMem == null) continue;
                tnMems.otherPmems.add(riaMem.getRiaPathMemory());
                continue;
            }
            pmem = (PathMemory)wm.getNodeMemories().peekNodeMemory(leftTupleNode);
            if (pmem == null) continue;
            tnMems.otherPmems.add(pmem);
        }
        tnMems.subjectPmem = (PathMemory)wm.getNodeMemories().peekNodeMemory(pathEndNodes.subjectEndNode);
        if (tnMems.subjectPmem == null && !tnMems.otherPmems.isEmpty()) {
            tnMems.subjectPmem = (PathMemory)wm.getNodeMemory((MemoryFactory)((Object)pathEndNodes.subjectEndNode));
        }
        for (LeftTupleNode leftTupleNode : pathEndNodes.subjectEndNodes) {
            if (leftTupleNode.getType() == 71) {
                riaMem = (RightInputAdapterNode.RiaNodeMemory)wm.getNodeMemories().peekNodeMemory(leftTupleNode);
                if (riaMem == null && !tnMems.otherPmems.isEmpty()) {
                    riaMem = (RightInputAdapterNode.RiaNodeMemory)wm.getNodeMemory((MemoryFactory)((Object)leftTupleNode));
                }
                if (riaMem == null) continue;
                tnMems.subjectPmems.add(riaMem.getRiaPathMemory());
                continue;
            }
            pmem = (PathMemory)wm.getNodeMemories().peekNodeMemory(leftTupleNode);
            if (pmem == null) continue;
            tnMems.subjectPmems.add(pmem);
        }
        return tnMems;
    }

    private static PathEndNodes getPathEndNodes(InternalKnowledgeBase kBase, LeftTupleNode lt, TerminalNode tn, Rule processedRule, boolean hasProtos, boolean hasWms) {
        PathEndNodes endNodes = new PathEndNodes();
        endNodes.subjectEndNode = (PathEndNode)((Object)tn);
        endNodes.subjectEndNodes.add((PathEndNode)((Object)tn));
        if (hasWms && SegmentUtilities.isTipNode(lt, null)) {
            endNodes.subjectSplit = lt;
            endNodes.subjectSplits.add(lt);
        }
        if (hasProtos) {
            AddRemoveRule.invalidateRootNode(kBase, lt);
        }
        AddRemoveRule.collectPathEndNodes(kBase, lt, endNodes, tn, processedRule, hasProtos, hasWms, hasProtos && AddRemoveRule.isSplit(lt));
        return endNodes;
    }

    private static void collectPathEndNodes(InternalKnowledgeBase kBase, LeftTupleNode lt, PathEndNodes endNodes, TerminalNode tn, Rule processedRule, boolean hasProtos, boolean hasWms, boolean isBelowNewSplit) {
        for (LeftTupleSinkNode sink = lt.getSinkPropagator().getLastLeftTupleSink(); sink != null; sink = sink.getPreviousLeftTupleSinkNode()) {
            if (sink == tn) continue;
            if (hasProtos) {
                if (isBelowNewSplit) {
                    if (SegmentUtilities.isRootNode(sink, null)) {
                        kBase.invalidateSegmentPrototype(sink);
                    }
                } else {
                    isBelowNewSplit = AddRemoveRule.isSplit(sink);
                    if (isBelowNewSplit) {
                        AddRemoveRule.invalidateRootNode(kBase, sink);
                    }
                }
            }
            if (NodeTypeEnums.isLeftTupleSource(sink)) {
                if (hasWms && SegmentUtilities.isTipNode(sink, null) && !SegmentUtilities.isTipNode(sink, tn)) {
                    endNodes.subjectSplits.add(sink);
                }
                AddRemoveRule.collectPathEndNodes(kBase, sink, endNodes, tn, processedRule, hasProtos, hasWms, isBelowNewSplit);
                continue;
            }
            if (NodeTypeEnums.isTerminalNode(sink)) {
                endNodes.otherEndNodes.add((PathEndNode)((Object)sink));
                continue;
            }
            if (71 == sink.getType()) {
                if (sink.isAssociatedWith(processedRule)) {
                    endNodes.subjectEndNodes.add((PathEndNode)((Object)sink));
                }
                if (sink.getAssociationsSize() <= 1 && sink.isAssociatedWith(processedRule)) continue;
                endNodes.otherEndNodes.add((PathEndNode)((Object)sink));
                continue;
            }
            throw new RuntimeException("Error: Unknown Node. Defensive programming test..");
        }
    }

    private static void invalidateRootNode(InternalKnowledgeBase kBase, LeftTupleNode lt) {
        while (!SegmentUtilities.isRootNode(lt, null)) {
            lt = lt.getLeftTupleSource();
        }
        kBase.invalidateSegmentPrototype(lt);
    }

    private static class PathEndNodes {
        PathEndNode subjectEndNode;
        LeftTupleNode subjectSplit;
        List<PathEndNode> subjectEndNodes = new ArrayList<PathEndNode>();
        List<LeftTupleNode> subjectSplits = new ArrayList<LeftTupleNode>();
        List<PathEndNode> otherEndNodes = new ArrayList<PathEndNode>();

        private PathEndNodes() {
        }
    }

    private static class PathEndNodeMemories {
        PathMemory subjectPmem;
        List<PathMemory> subjectPmems = new ArrayList<PathMemory>();
        List<PathMemory> otherPmems = new ArrayList<PathMemory>();

        private PathEndNodeMemories() {
        }
    }

    public static class Flushed {
        SegmentMemory segmentMemory;
        PathMemory pathMemory;

        public Flushed(SegmentMemory segmentMemory, PathMemory pathMemory) {
            this.segmentMemory = segmentMemory;
            this.pathMemory = pathMemory;
        }
    }

    public static class RemoveExistingPaths
    implements ExistingPathStrategy {
        @Override
        public SegmentMemory[] getSegmenMemories(PathMemory pmem) {
            return new SegmentMemory[pmem.getSegmentMemories().length];
        }

        @Override
        public void adjustSegment(InternalWorkingMemory wm, Set<SegmentMemory> smemsToNotify, SegmentMemory smem, int smemSplitAdjustAmount) {
            smemsToNotify.add(smem);
            smem.unlinkSegment(wm);
            AddRemoveRule.correctSegmentMemoryAfterSplitOnRemove(smem, smemSplitAdjustAmount);
        }

        @Override
        public void handleSplit(PathMemory pmem, SegmentMemory[] prevSmems, SegmentMemory[] smems, int smemIndex, int prevSmemIndex, LeftTupleNode parentNode, LeftTupleNode node, TerminalNode tn, Set<LeftTupleNode> visited, Set<SegmentMemory> smemsToNotify, Map<LeftTupleNode, SegmentMemory> nodeToSegmentMap, InternalWorkingMemory wm) {
            if (visited.contains(node)) {
                return;
            }
            AddRemoveRule.correctMemoryOnSplitsChanged(parentNode, tn, wm);
            SegmentMemory sm1 = smems[smemIndex];
            SegmentMemory sm2 = prevSmems[prevSmemIndex];
            if (sm1 != null && sm2 == null) {
                prevSmems[prevSmemIndex] = sm2 = SegmentUtilities.createChildSegment(wm, node);
                sm1.add(sm2);
            } else if (sm1 == null && sm2 != null) {
                smems[smemIndex] = sm1 = SegmentUtilities.createChildSegment(wm, parentNode);
                sm1.add(sm2);
            }
            if (sm1 != null && sm2 != null) {
                AddRemoveRule.mergeSegment(sm1, sm2);
                smemsToNotify.add(sm1);
                sm1.unlinkSegment(wm);
                sm2.unlinkSegment(wm);
                visited.add(node);
            }
        }

        @Override
        public void processSegmentMemories(SegmentMemory[] smems, PathMemory pmem) {
            for (int i = 0; i < smems.length; ++i) {
                if (smems[i] == null) continue;
                pmem.setSegmentMemory(smems[i].getPos(), smems[i]);
            }
        }

        @Override
        public int incSmemIndex1(int smemIndex) {
            return smemIndex;
        }

        @Override
        public int incPrevSmemIndex1(int prevSmemIndex) {
            return prevSmemIndex + 1;
        }

        @Override
        public int incSmemIndex2(int smemIndex) {
            return smemIndex + 1;
        }

        @Override
        public int incPrevSmemIndex2(int prevSmemIndex) {
            return prevSmemIndex;
        }
    }

    public static class AddExistingPaths
    implements ExistingPathStrategy {
        @Override
        public SegmentMemory[] getSegmenMemories(PathMemory pmem) {
            return pmem.getSegmentMemories();
        }

        @Override
        public void adjustSegment(InternalWorkingMemory wm, Set<SegmentMemory> smemsToNotify, SegmentMemory smem, int smemSplitAdjustAmount) {
            smemsToNotify.add(smem);
            smem.unlinkSegment(wm);
            AddRemoveRule.correctSegmentMemoryAfterSplitOnAdd(smem, smemSplitAdjustAmount);
        }

        @Override
        public void handleSplit(PathMemory pmem, SegmentMemory[] prevSmems, SegmentMemory[] smems, int smemIndex, int prevSmemIndex, LeftTupleNode parentNode, LeftTupleNode node, TerminalNode tn, Set<LeftTupleNode> visited, Set<SegmentMemory> smemsToNotify, Map<LeftTupleNode, SegmentMemory> nodeToSegmentMap, InternalWorkingMemory wm) {
            if (smems[smemIndex - 1] != null) {
                SegmentMemory sm2 = nodeToSegmentMap.get(node);
                if (sm2 == null) {
                    SegmentMemory sm1 = smems[smemIndex - 1];
                    AddRemoveRule.correctMemoryOnSplitsChanged(parentNode, null, wm);
                    sm2 = AddRemoveRule.splitSegment(wm, sm1, parentNode);
                    nodeToSegmentMap.put(node, sm2);
                    smemsToNotify.add(sm1);
                    smemsToNotify.add(sm2);
                }
                smems[smemIndex] = sm2;
            }
        }

        @Override
        public void processSegmentMemories(SegmentMemory[] smems, PathMemory pmem) {
        }

        @Override
        public int incSmemIndex1(int smemIndex) {
            return smemIndex + 1;
        }

        @Override
        public int incPrevSmemIndex1(int prevSmemIndex) {
            return prevSmemIndex;
        }

        @Override
        public int incSmemIndex2(int smemIndex) {
            return smemIndex;
        }

        @Override
        public int incPrevSmemIndex2(int prevSmemIndex) {
            return prevSmemIndex + 1;
        }
    }

    public static interface ExistingPathStrategy {
        public static final ExistingPathStrategy ADD_STRATEGY = new AddExistingPaths();
        public static final ExistingPathStrategy REMOVE_STRATEGY = new RemoveExistingPaths();

        public SegmentMemory[] getSegmenMemories(PathMemory var1);

        public void adjustSegment(InternalWorkingMemory var1, Set<SegmentMemory> var2, SegmentMemory var3, int var4);

        public void handleSplit(PathMemory var1, SegmentMemory[] var2, SegmentMemory[] var3, int var4, int var5, LeftTupleNode var6, LeftTupleNode var7, TerminalNode var8, Set<LeftTupleNode> var9, Set<SegmentMemory> var10, Map<LeftTupleNode, SegmentMemory> var11, InternalWorkingMemory var12);

        public void processSegmentMemories(SegmentMemory[] var1, PathMemory var2);

        public int incSmemIndex1(int var1);

        public int incSmemIndex2(int var1);

        public int incPrevSmemIndex1(int var1);

        public int incPrevSmemIndex2(int var1);
    }
}

