/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.simple;

import org.optaplanner.core.api.score.AbstractScore;
import org.optaplanner.core.api.score.Score;

public final class SimpleScore
extends AbstractScore<SimpleScore> {
    public static final SimpleScore ZERO = new SimpleScore(0, 0);
    public static final SimpleScore ONE = new SimpleScore(0, 1);
    private final int score;

    public static SimpleScore parseScore(String scoreString) {
        String[] scoreTokens = SimpleScore.parseScoreTokens(SimpleScore.class, scoreString, "");
        int initScore = SimpleScore.parseInitScore(SimpleScore.class, scoreString, scoreTokens[0]);
        int score = SimpleScore.parseLevelAsInt(SimpleScore.class, scoreString, scoreTokens[1]);
        return SimpleScore.ofUninitialized(initScore, score);
    }

    public static SimpleScore ofUninitialized(int initScore, int score) {
        return new SimpleScore(initScore, score);
    }

    @Deprecated
    public static SimpleScore valueOfUninitialized(int initScore, int score) {
        return new SimpleScore(initScore, score);
    }

    public static SimpleScore of(int score) {
        return new SimpleScore(0, score);
    }

    @Deprecated
    public static SimpleScore valueOf(int score) {
        return new SimpleScore(0, score);
    }

    private SimpleScore() {
        super(Integer.MIN_VALUE);
        this.score = Integer.MIN_VALUE;
    }

    private SimpleScore(int initScore, int score) {
        super(initScore);
        this.score = score;
    }

    public int getScore() {
        return this.score;
    }

    @Override
    public SimpleScore toInitializedScore() {
        return this.initScore == 0 ? this : new SimpleScore(0, this.score);
    }

    @Override
    public SimpleScore withInitScore(int newInitScore) {
        this.assertNoInitScore();
        return new SimpleScore(newInitScore, this.score);
    }

    @Override
    public SimpleScore add(SimpleScore addend) {
        return new SimpleScore(this.initScore + addend.getInitScore(), this.score + addend.getScore());
    }

    @Override
    public SimpleScore subtract(SimpleScore subtrahend) {
        return new SimpleScore(this.initScore - subtrahend.getInitScore(), this.score - subtrahend.getScore());
    }

    @Override
    public SimpleScore multiply(double multiplicand) {
        return new SimpleScore((int)Math.floor((double)this.initScore * multiplicand), (int)Math.floor((double)this.score * multiplicand));
    }

    @Override
    public SimpleScore divide(double divisor) {
        return new SimpleScore((int)Math.floor((double)this.initScore / divisor), (int)Math.floor((double)this.score / divisor));
    }

    @Override
    public SimpleScore power(double exponent) {
        return new SimpleScore((int)Math.floor(Math.pow(this.initScore, exponent)), (int)Math.floor(Math.pow(this.score, exponent)));
    }

    @Override
    public SimpleScore negate() {
        return new SimpleScore(-this.initScore, -this.score);
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.score};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleScore) {
            SimpleScore other = (SimpleScore)o;
            return this.initScore == other.getInitScore() && this.score == other.getScore();
        }
        return false;
    }

    public int hashCode() {
        return (629 + this.initScore) * 37 + this.score;
    }

    @Override
    public int compareTo(SimpleScore other) {
        if (this.initScore != other.getInitScore()) {
            return this.initScore < other.getInitScore() ? -1 : 1;
        }
        return Integer.compare(this.score, other.getScore());
    }

    @Override
    public String toShortString() {
        return this.buildShortString(n -> (Integer)n != 0, "");
    }

    public String toString() {
        return this.getInitPrefix() + this.score;
    }

    @Override
    public boolean isCompatibleArithmeticArgument(Score otherScore) {
        return otherScore instanceof SimpleScore;
    }
}

