/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.uni;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintSession;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetGroupBiNode;
import org.optaplanner.core.impl.score.stream.bavet.bi.BavetGroupBiTuple;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetTupleState;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetAbstractUniNode;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetAbstractUniTuple;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetGroupBridgeUniTuple;

public final class BavetGroupBridgeUniNode<A, GroupKey_, ResultContainer_, Result_>
extends BavetAbstractUniNode<A> {
    private final BavetAbstractUniNode<A> parentNode;
    private final Function<A, GroupKey_> groupKeyMapping;
    private final UniConstraintCollector<A, ResultContainer_, Result_> collector;
    private final BavetGroupBiNode<GroupKey_, ResultContainer_, Result_> groupNode;
    private final Map<GroupKey_, BavetGroupBiTuple<GroupKey_, ResultContainer_, Result_>> tupleMap;

    public BavetGroupBridgeUniNode(BavetConstraintSession session, int nodeOrder, BavetAbstractUniNode<A> parentNode, Function<A, GroupKey_> groupKeyMapping, UniConstraintCollector<A, ResultContainer_, Result_> collector, BavetGroupBiNode<GroupKey_, ResultContainer_, Result_> groupNode) {
        super(session, nodeOrder);
        this.parentNode = parentNode;
        this.groupKeyMapping = groupKeyMapping;
        this.collector = collector;
        this.groupNode = groupNode;
        this.tupleMap = new HashMap<GroupKey_, BavetGroupBiTuple<GroupKey_, ResultContainer_, Result_>>();
    }

    public BavetGroupBridgeUniTuple<A, GroupKey_, ResultContainer_, Result_> createTuple(BavetAbstractUniTuple<A> parentTuple) {
        return new BavetGroupBridgeUniTuple(this, parentTuple);
    }

    public void refresh(BavetGroupBridgeUniTuple<A, GroupKey_, ResultContainer_, Result_> tuple) {
        if (tuple.getChildTuple() != null) {
            BavetGroupBiTuple<GroupKey_, ResultContainer_, Result_> childTuple = tuple.getChildTuple();
            GroupKey_ oldGroupKey = childTuple.getGroupKey();
            int parentCount = childTuple.decreaseParentCount();
            tuple.getUndoAccumulator().run();
            childTuple.clearResult();
            tuple.setChildTuple(null);
            tuple.setUndoAccumulator(null);
            if (parentCount == 0) {
                this.tupleMap.remove(oldGroupKey);
                this.session.transitionTuple(childTuple, BavetTupleState.DYING);
            } else {
                this.session.transitionTuple(childTuple, BavetTupleState.UPDATING);
            }
        }
        if (tuple.isActive()) {
            A a = tuple.getFactA();
            GroupKey_ groupKey = this.groupKeyMapping.apply(a);
            BavetGroupBiTuple childTuple = this.tupleMap.computeIfAbsent(groupKey, k -> this.groupNode.createTuple(groupKey, this.collector.supplier().get()));
            int parentCount = childTuple.increaseParentCount();
            Runnable undoAccumulator = this.collector.accumulator().apply(childTuple.getResultContainer(), a);
            tuple.setUndoAccumulator(undoAccumulator);
            childTuple.clearResult();
            tuple.setChildTuple(childTuple);
            if (parentCount == 1) {
                this.session.transitionTuple(childTuple, BavetTupleState.CREATING);
            } else if (childTuple.getState() != BavetTupleState.CREATING) {
                this.session.transitionTuple(childTuple, BavetTupleState.UPDATING);
            }
        }
        tuple.refreshed();
    }

    public String toString() {
        return "GroupBridge()";
    }
}

