/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.optional.score;

import java.util.HashMap;
import java.util.Map;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.impl.score.director.incremental.AbstractIncrementalScoreCalculator;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;

public class CloudBalancingIncrementalScoreCalculator
extends AbstractIncrementalScoreCalculator<CloudBalance> {
    private Map<CloudComputer, Integer> cpuPowerUsageMap;
    private Map<CloudComputer, Integer> memoryUsageMap;
    private Map<CloudComputer, Integer> networkBandwidthUsageMap;
    private Map<CloudComputer, Integer> processCountMap;
    private int hardScore;
    private int softScore;

    public void resetWorkingSolution(CloudBalance cloudBalance) {
        int computerListSize = cloudBalance.getComputerList().size();
        this.cpuPowerUsageMap = new HashMap<CloudComputer, Integer>(computerListSize);
        this.memoryUsageMap = new HashMap<CloudComputer, Integer>(computerListSize);
        this.networkBandwidthUsageMap = new HashMap<CloudComputer, Integer>(computerListSize);
        this.processCountMap = new HashMap<CloudComputer, Integer>(computerListSize);
        for (CloudComputer computer : cloudBalance.getComputerList()) {
            this.cpuPowerUsageMap.put(computer, 0);
            this.memoryUsageMap.put(computer, 0);
            this.networkBandwidthUsageMap.put(computer, 0);
            this.processCountMap.put(computer, 0);
        }
        this.hardScore = 0;
        this.softScore = 0;
        for (CloudProcess process : cloudBalance.getProcessList()) {
            this.insert(process);
        }
    }

    public void beforeEntityAdded(Object entity) {
    }

    public void afterEntityAdded(Object entity) {
        this.insert((CloudProcess)entity);
    }

    public void beforeVariableChanged(Object entity, String variableName) {
        this.retract((CloudProcess)entity);
    }

    public void afterVariableChanged(Object entity, String variableName) {
        this.insert((CloudProcess)entity);
    }

    public void beforeEntityRemoved(Object entity) {
        this.retract((CloudProcess)entity);
    }

    public void afterEntityRemoved(Object entity) {
    }

    private void insert(CloudProcess process) {
        CloudComputer computer = process.getComputer();
        if (computer != null) {
            int cpuPower = computer.getCpuPower();
            int oldCpuPowerUsage = this.cpuPowerUsageMap.get(computer);
            int oldCpuPowerAvailable = cpuPower - oldCpuPowerUsage;
            int newCpuPowerUsage = oldCpuPowerUsage + process.getRequiredCpuPower();
            int newCpuPowerAvailable = cpuPower - newCpuPowerUsage;
            this.hardScore += Math.min(newCpuPowerAvailable, 0) - Math.min(oldCpuPowerAvailable, 0);
            this.cpuPowerUsageMap.put(computer, newCpuPowerUsage);
            int memory = computer.getMemory();
            int oldMemoryUsage = this.memoryUsageMap.get(computer);
            int oldMemoryAvailable = memory - oldMemoryUsage;
            int newMemoryUsage = oldMemoryUsage + process.getRequiredMemory();
            int newMemoryAvailable = memory - newMemoryUsage;
            this.hardScore += Math.min(newMemoryAvailable, 0) - Math.min(oldMemoryAvailable, 0);
            this.memoryUsageMap.put(computer, newMemoryUsage);
            int networkBandwidth = computer.getNetworkBandwidth();
            int oldNetworkBandwidthUsage = this.networkBandwidthUsageMap.get(computer);
            int oldNetworkBandwidthAvailable = networkBandwidth - oldNetworkBandwidthUsage;
            int newNetworkBandwidthUsage = oldNetworkBandwidthUsage + process.getRequiredNetworkBandwidth();
            int newNetworkBandwidthAvailable = networkBandwidth - newNetworkBandwidthUsage;
            this.hardScore += Math.min(newNetworkBandwidthAvailable, 0) - Math.min(oldNetworkBandwidthAvailable, 0);
            this.networkBandwidthUsageMap.put(computer, newNetworkBandwidthUsage);
            int oldProcessCount = this.processCountMap.get(computer);
            if (oldProcessCount == 0) {
                this.softScore -= computer.getCost();
            }
            int newProcessCount = oldProcessCount + 1;
            this.processCountMap.put(computer, newProcessCount);
        }
    }

    private void retract(CloudProcess process) {
        CloudComputer computer = process.getComputer();
        if (computer != null) {
            int cpuPower = computer.getCpuPower();
            int oldCpuPowerUsage = this.cpuPowerUsageMap.get(computer);
            int oldCpuPowerAvailable = cpuPower - oldCpuPowerUsage;
            int newCpuPowerUsage = oldCpuPowerUsage - process.getRequiredCpuPower();
            int newCpuPowerAvailable = cpuPower - newCpuPowerUsage;
            this.hardScore += Math.min(newCpuPowerAvailable, 0) - Math.min(oldCpuPowerAvailable, 0);
            this.cpuPowerUsageMap.put(computer, newCpuPowerUsage);
            int memory = computer.getMemory();
            int oldMemoryUsage = this.memoryUsageMap.get(computer);
            int oldMemoryAvailable = memory - oldMemoryUsage;
            int newMemoryUsage = oldMemoryUsage - process.getRequiredMemory();
            int newMemoryAvailable = memory - newMemoryUsage;
            this.hardScore += Math.min(newMemoryAvailable, 0) - Math.min(oldMemoryAvailable, 0);
            this.memoryUsageMap.put(computer, newMemoryUsage);
            int networkBandwidth = computer.getNetworkBandwidth();
            int oldNetworkBandwidthUsage = this.networkBandwidthUsageMap.get(computer);
            int oldNetworkBandwidthAvailable = networkBandwidth - oldNetworkBandwidthUsage;
            int newNetworkBandwidthUsage = oldNetworkBandwidthUsage - process.getRequiredNetworkBandwidth();
            int newNetworkBandwidthAvailable = networkBandwidth - newNetworkBandwidthUsage;
            this.hardScore += Math.min(newNetworkBandwidthAvailable, 0) - Math.min(oldNetworkBandwidthAvailable, 0);
            this.networkBandwidthUsageMap.put(computer, newNetworkBandwidthUsage);
            int oldProcessCount = this.processCountMap.get(computer);
            int newProcessCount = oldProcessCount - 1;
            if (newProcessCount == 0) {
                this.softScore += computer.getCost();
            }
            this.processCountMap.put(computer, newProcessCount);
        }
    }

    public HardSoftScore calculateScore() {
        return HardSoftScore.of((int)this.hardScore, (int)this.softScore);
    }
}

