/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.bi;

import org.optaplanner.core.api.score.stream.bi.BiJoiner;
import org.optaplanner.core.impl.score.stream.bi.AbstractBiJoiner;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsAbstractBiConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsBiCondition;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsAbstractUniConstraintStream;

public class DroolsJoinBiConstraintStream<Solution_, A, B>
extends DroolsAbstractBiConstraintStream<Solution_, A, B> {
    private final DroolsAbstractUniConstraintStream<Solution_, A> leftParentStream;
    private final DroolsAbstractUniConstraintStream<Solution_, B> rightParentStream;
    private final DroolsBiCondition<A, B> condition;

    public DroolsJoinBiConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractUniConstraintStream<Solution_, A> parent, DroolsAbstractUniConstraintStream<Solution_, B> otherStream, BiJoiner<A, B> biJoiner) {
        super(constraintFactory);
        this.leftParentStream = parent;
        this.rightParentStream = otherStream;
        this.condition = parent.getCondition().andJoin(otherStream.getCondition(), (AbstractBiJoiner)biJoiner);
    }

    @Override
    public DroolsBiCondition<A, B> getCondition() {
        return this.condition;
    }

    public DroolsAbstractUniConstraintStream<Solution_, A> getLeftParentStream() {
        return this.leftParentStream;
    }

    public DroolsAbstractUniConstraintStream<Solution_, B> getRightParentStream() {
        return this.rightParentStream;
    }

    @Override
    protected DroolsAbstractConstraintStream<Solution_> getParent() {
        return null;
    }

    public String toString() {
        return "BiJoin() with " + this.getChildStreams().size() + " children";
    }
}

