/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.uni;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.core.common.InternalFactHandle;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsGroupByAccumulator;

public class DroolsGroupBy<A, B, ResultContainer, NewB>
implements Serializable {
    private static final long serialVersionUID = 510L;
    private final Map<Long, Runnable> undoMap = new HashMap<Long, Runnable>(0);
    private final UniConstraintCollector<B, ResultContainer, NewB> collector;
    private DroolsGroupByAccumulator<A, B, ResultContainer, NewB> acc;

    public DroolsGroupBy(UniConstraintCollector<B, ResultContainer, NewB> collector) {
        this.collector = collector;
    }

    public void init() {
        this.acc = new DroolsGroupByAccumulator(this.collector);
        this.undoMap.clear();
    }

    public void accumulate(InternalFactHandle handle, A groupKey, B collected) {
        Runnable undo = this.acc.accumulate(groupKey, collected);
        Runnable previousUndo = this.undoMap.put(handle.getId(), undo);
        if (previousUndo != null) {
            throw new IllegalStateException("Undo for fact handle (" + handle.getId() + ") already exists.");
        }
    }

    public void reverse(InternalFactHandle handle) {
        Runnable undo = this.undoMap.remove(handle.getId());
        if (undo == null) {
            throw new IllegalStateException("No undo for fact handle (" + handle.getId() + ")");
        }
        undo.run();
    }

    public Set<DroolsGroupByAccumulator.Pair<A, NewB>> getResult() {
        return this.acc.finish();
    }
}

