/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.quad;

import java.util.ArrayList;
import java.util.function.Function;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.stream.quad.QuadJoiner;
import org.optaplanner.core.impl.score.stream.common.AbstractJoiner;
import org.optaplanner.core.impl.score.stream.quad.CompositeQuadJoiner;
import org.optaplanner.core.impl.score.stream.quad.NoneQuadJoiner;
import org.optaplanner.core.impl.score.stream.quad.SingleQuadJoiner;

public abstract class AbstractQuadJoiner<A, B, C, D>
extends AbstractJoiner
implements QuadJoiner<A, B, C, D> {
    @SafeVarargs
    public static final <A, B, C, D> QuadJoiner<A, B, C, D> merge(QuadJoiner<A, B, C, D> ... joiners) {
        ArrayList joinerList = new ArrayList();
        for (QuadJoiner<A, B, C, D> joiner : joiners) {
            if (joiner instanceof NoneQuadJoiner) continue;
            if (joiner instanceof SingleQuadJoiner) {
                joinerList.add((SingleQuadJoiner)joiner);
                continue;
            }
            if (joiner instanceof CompositeQuadJoiner) {
                joinerList.addAll(((CompositeQuadJoiner)joiner).getJoinerList());
                continue;
            }
            throw new IllegalArgumentException("The joiner class (" + joiner.getClass() + ") is not supported.");
        }
        if (joinerList.isEmpty()) {
            return new NoneQuadJoiner();
        }
        if (joinerList.size() == 1) {
            return (QuadJoiner)joinerList.get(0);
        }
        return new CompositeQuadJoiner(joinerList);
    }

    public abstract TriFunction<A, B, C, Object> getLeftMapping(int var1);

    public abstract TriFunction<A, B, C, Object[]> getLeftCombinedMapping();

    public abstract Function<D, Object> getRightMapping(int var1);

    public abstract Function<D, Object[]> getRightCombinedMapping();
}

