/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.quad;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.drools.model.DSL;
import org.drools.model.Drools;
import org.drools.model.Global;
import org.drools.model.PatternDSL;
import org.drools.model.RuleItemBuilder;
import org.drools.model.Variable;
import org.drools.model.consequences.ConsequenceBuilder;
import org.drools.model.functions.Block6;
import org.drools.model.functions.Function4;
import org.drools.model.functions.Predicate5;
import org.optaplanner.core.api.function.PentaPredicate;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.QuadPredicate;
import org.optaplanner.core.api.function.ToIntQuadFunction;
import org.optaplanner.core.api.function.ToLongQuadFunction;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.api.score.stream.penta.PentaJoiner;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintCollector;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsBiCondition;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsCondition;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsPatternBuilder;
import org.optaplanner.core.impl.score.stream.drools.common.QuadTuple;
import org.optaplanner.core.impl.score.stream.drools.common.TriTuple;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsQuadAccumulateFunctionBridge;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsQuadGroupByInvoker;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsQuadRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsQuadToBiGroupByInvoker;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsQuadToTriGroupByInvoker;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsTriCondition;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniCondition;
import org.optaplanner.core.impl.score.stream.penta.AbstractPentaJoiner;
import org.optaplanner.core.impl.score.stream.penta.FilteringPentaJoiner;
import org.optaplanner.core.impl.score.stream.penta.NonePentaJoiner;
import org.optaplanner.core.impl.score.stream.tri.NoneTriJoiner;

public final class DroolsQuadCondition<A, B, C, D, PatternVar>
extends DroolsCondition<PatternVar, DroolsQuadRuleStructure<A, B, C, D, PatternVar>> {
    public DroolsQuadCondition(DroolsQuadRuleStructure<A, B, C, D, PatternVar> ruleStructure) {
        super(ruleStructure);
    }

    public DroolsQuadCondition<A, B, C, D, PatternVar> andFilter(QuadPredicate<A, B, C, D> predicate) {
        Predicate5 & Serializable filter = (Predicate5 & Serializable)(__, a, b, c, d) -> predicate.test(a, b, c, d);
        Variable aVariable = ((DroolsQuadRuleStructure)this.ruleStructure).getA();
        Variable bVariable = ((DroolsQuadRuleStructure)this.ruleStructure).getB();
        Variable cVariable = ((DroolsQuadRuleStructure)this.ruleStructure).getC();
        Variable dVariable = ((DroolsQuadRuleStructure)this.ruleStructure).getD();
        DroolsPatternBuilder newTargetPattern = ((DroolsQuadRuleStructure)this.ruleStructure).getPrimaryPatternBuilder().expand(p -> p.expr("Filter using " + predicate, aVariable, bVariable, cVariable, dVariable, filter));
        DroolsQuadRuleStructure newRuleStructure = new DroolsQuadRuleStructure(aVariable, bVariable, cVariable, dVariable, newTargetPattern, ((DroolsQuadRuleStructure)this.ruleStructure).getShelvedRuleItems(), ((DroolsQuadRuleStructure)this.ruleStructure).getPrerequisites(), ((DroolsQuadRuleStructure)this.ruleStructure).getDependents(), ((DroolsQuadRuleStructure)this.ruleStructure).getVariableIdSupplier());
        return new DroolsQuadCondition(newRuleStructure);
    }

    @SafeVarargs
    public final <E> DroolsQuadCondition<A, B, C, D, PatternVar> andIfExists(Class<E> otherClass, PentaJoiner<A, B, C, D, E> ... joiners) {
        return this.andIfExistsOrNot(true, otherClass, joiners);
    }

    @SafeVarargs
    public final <E> DroolsQuadCondition<A, B, C, D, PatternVar> andIfNotExists(Class<E> otherClass, PentaJoiner<A, B, C, D, E> ... joiners) {
        return this.andIfExistsOrNot(false, otherClass, joiners);
    }

    @SafeVarargs
    private final <E> DroolsQuadCondition<A, B, C, D, PatternVar> andIfExistsOrNot(boolean shouldExist, Class<E> otherClass, PentaJoiner<A, B, C, D, E> ... joiners) {
        int indexOfFirstFilter = -1;
        AbstractPentaJoiner finalJoiner = null;
        PentaPredicate finalFilter = null;
        for (int i = 0; i < joiners.length; ++i) {
            boolean hasAFilter;
            AbstractPentaJoiner joiner = (AbstractPentaJoiner)joiners[i];
            boolean bl = hasAFilter = indexOfFirstFilter >= 0;
            if (joiner instanceof NonePentaJoiner && joiners.length > 1) {
                throw new IllegalStateException("If present, " + NoneTriJoiner.class + " must be the only joiner, got " + Arrays.toString(joiners) + " instead.");
            }
            if (!(joiner instanceof FilteringPentaJoiner)) {
                if (hasAFilter) {
                    throw new IllegalStateException("Indexing joiner (" + joiner + ") must not follow a filtering joiner (" + joiners[indexOfFirstFilter] + ").");
                }
                finalJoiner = finalJoiner == null ? joiner : AbstractPentaJoiner.merge(finalJoiner, joiner);
                continue;
            }
            if (!hasAFilter) {
                indexOfFirstFilter = i;
            }
            finalFilter = finalFilter == null ? joiner.getFilter() : finalFilter.and(joiner.getFilter());
        }
        return this.applyJoiners(otherClass, finalJoiner, finalFilter, shouldExist);
    }

    private <E> DroolsQuadCondition<A, B, C, D, PatternVar> applyJoiners(Class<E> otherClass, AbstractPentaJoiner<A, B, C, D, E> joiner, PentaPredicate<A, B, C, D, E> predicate, boolean shouldExist) {
        Variable<E> toExist = ((DroolsQuadRuleStructure)this.ruleStructure).createVariable(otherClass, "quadToExist");
        PatternDSL.PatternDef existencePattern = PatternDSL.pattern(toExist);
        if (joiner == null) {
            return this.applyFilters(existencePattern, predicate, shouldExist);
        }
        PentaPredicate<Object, Object, Object, Object, Object> joinFilter = joiner::matches;
        PentaPredicate<Object, Object, Object, Object, Object> result = predicate == null ? joinFilter : joinFilter.and(predicate);
        return this.applyFilters(existencePattern, result, shouldExist);
    }

    private <E> DroolsQuadCondition<A, B, C, D, PatternVar> applyFilters(PatternDSL.PatternDef<E> existencePattern, PentaPredicate<A, B, C, D, E> predicate, boolean shouldExist) {
        PatternDSL.PatternDef possiblyFilteredExistencePattern = predicate == null ? existencePattern : existencePattern.expr("Filter using " + predicate, ((DroolsQuadRuleStructure)this.ruleStructure).getA(), ((DroolsQuadRuleStructure)this.ruleStructure).getB(), ((DroolsQuadRuleStructure)this.ruleStructure).getC(), ((DroolsQuadRuleStructure)this.ruleStructure).getD(), (Predicate5 & Serializable)(e, a, b, c, d) -> predicate.test(a, b, c, d, e));
        return new DroolsQuadCondition(((DroolsQuadRuleStructure)this.ruleStructure).existsOrNot(possiblyFilteredExistencePattern, shouldExist));
    }

    public <NewA, __> DroolsUniCondition<NewA, NewA> andCollect(QuadConstraintCollector<A, B, C, D, __, NewA> collector) {
        DroolsQuadAccumulateFunctionBridge<A, B, C, D, __, NewA> bridge = new DroolsQuadAccumulateFunctionBridge<A, B, C, D, __, NewA>(collector);
        return this.collect(bridge, (pattern, tuple) -> pattern.bind(tuple, ((DroolsQuadRuleStructure)this.ruleStructure).getA(), ((DroolsQuadRuleStructure)this.ruleStructure).getB(), ((DroolsQuadRuleStructure)this.ruleStructure).getC(), (Function4 & Serializable)(d, a, b, c) -> new QuadTuple<Object, Object, Object, Object>(a, b, c, d)));
    }

    public <NewA> DroolsUniCondition<NewA, NewA> andGroup(QuadFunction<A, B, C, D, NewA> groupKeyMapping) {
        return super.group((pattern, tuple) -> pattern.bind(tuple, ((DroolsQuadRuleStructure)this.ruleStructure).getA(), ((DroolsQuadRuleStructure)this.ruleStructure).getB(), ((DroolsQuadRuleStructure)this.ruleStructure).getC(), (Function4 & Serializable)(d, a, b, c) -> groupKeyMapping.apply(a, b, c, d)));
    }

    public <NewA, NewB, __> DroolsBiCondition<NewA, NewB, BiTuple<NewA, NewB>> andGroupWithCollect(QuadFunction<A, B, C, D, NewA> groupKeyMapping, QuadConstraintCollector<A, B, C, D, __, NewB> collector) {
        return this.groupWithCollect(() -> new DroolsQuadToBiGroupByInvoker(groupKeyMapping, collector, ((DroolsQuadRuleStructure)this.getRuleStructure()).getA(), ((DroolsQuadRuleStructure)this.getRuleStructure()).getB(), ((DroolsQuadRuleStructure)this.getRuleStructure()).getC(), ((DroolsQuadRuleStructure)this.getRuleStructure()).getD()));
    }

    public <NewA, NewB> DroolsBiCondition<NewA, NewB, BiTuple<NewA, NewB>> andGroupBi(QuadFunction<A, B, C, D, NewA> groupKeyAMapping, QuadFunction<A, B, C, D, NewB> groupKeyBMapping) {
        return this.groupBi((pattern, tuple) -> pattern.bind(tuple, ((DroolsQuadRuleStructure)this.ruleStructure).getA(), ((DroolsQuadRuleStructure)this.ruleStructure).getB(), ((DroolsQuadRuleStructure)this.ruleStructure).getC(), (Function4 & Serializable)(d, a, b, c) -> {
            Object newA = groupKeyAMapping.apply(a, b, c, d);
            Object newB = groupKeyBMapping.apply(a, b, c, d);
            return new BiTuple(newA, newB);
        }));
    }

    public <NewA, NewB, NewC, __> DroolsTriCondition<NewA, NewB, NewC, TriTuple<NewA, NewB, NewC>> andGroupBiWithCollect(QuadFunction<A, B, C, D, NewA> groupKeyAMapping, QuadFunction<A, B, C, D, NewB> groupKeyBMapping, QuadConstraintCollector<A, B, C, D, __, NewC> collector) {
        return this.groupBiWithCollect(() -> new DroolsQuadToTriGroupByInvoker(groupKeyAMapping, groupKeyBMapping, collector, ((DroolsQuadRuleStructure)this.getRuleStructure()).getA(), ((DroolsQuadRuleStructure)this.getRuleStructure()).getB(), ((DroolsQuadRuleStructure)this.getRuleStructure()).getC(), ((DroolsQuadRuleStructure)this.getRuleStructure()).getD()));
    }

    public <NewA, NewB, NewC, NewD> DroolsQuadCondition<NewA, NewB, NewC, NewD, QuadTuple<NewA, NewB, NewC, NewD>> andGroupBiWithCollectBi(QuadFunction<A, B, C, D, NewA> groupKeyAMapping, QuadFunction<A, B, C, D, NewB> groupKeyBMapping, QuadConstraintCollector<A, B, C, D, ?, NewC> collectorC, QuadConstraintCollector<A, B, C, D, ?, NewD> collectorD) {
        return this.groupBiWithCollectBi(() -> new DroolsQuadGroupByInvoker(groupKeyAMapping, groupKeyBMapping, collectorC, collectorD, ((DroolsQuadRuleStructure)this.getRuleStructure()).getA(), ((DroolsQuadRuleStructure)this.getRuleStructure()).getB(), ((DroolsQuadRuleStructure)this.getRuleStructure()).getC(), ((DroolsQuadRuleStructure)this.getRuleStructure()).getD()));
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal) {
        return this.completeWithScoring(scoreHolderGlobal, (Block6 & Serializable)(drools, scoreHolder, a, b, c, d) -> this.impactScore((Drools)drools, scoreHolder));
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, ToIntQuadFunction<A, B, C, D> matchWeighter) {
        return this.completeWithScoring(scoreHolderGlobal, (Block6 & Serializable)(drools, scoreHolder, a, b, c, d) -> this.impactScore((Drools)drools, scoreHolder, matchWeighter.applyAsInt(a, b, c, d)));
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, ToLongQuadFunction<A, B, C, D> matchWeighter) {
        return this.completeWithScoring(scoreHolderGlobal, (Block6 & Serializable)(drools, scoreHolder, a, b, c, d) -> this.impactScore((Drools)drools, scoreHolder, matchWeighter.applyAsLong(a, b, c, d)));
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, QuadFunction<A, B, C, D, BigDecimal> matchWeighter) {
        return this.completeWithScoring(scoreHolderGlobal, (Block6 & Serializable)(drools, scoreHolder, a, b, c, d) -> this.impactScore((Drools)drools, scoreHolder, (BigDecimal)matchWeighter.apply(a, b, c, d)));
    }

    private <ScoreHolder extends AbstractScoreHolder<?>> List<RuleItemBuilder<?>> completeWithScoring(Global<ScoreHolder> scoreHolderGlobal, Block6<Drools, ScoreHolder, A, B, C, D> consequenceImpl) {
        ConsequenceBuilder._5 consequence = DSL.on(scoreHolderGlobal, ((DroolsQuadRuleStructure)this.ruleStructure).getA(), ((DroolsQuadRuleStructure)this.ruleStructure).getB(), ((DroolsQuadRuleStructure)this.ruleStructure).getC(), ((DroolsQuadRuleStructure)this.ruleStructure).getD()).execute(consequenceImpl);
        return ((DroolsQuadRuleStructure)this.ruleStructure).finish((ConsequenceBuilder.AbstractValidBuilder<?>)consequence);
    }
}

