/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Serializable;
import org.drools.core.common.ActivationsFilter;
import org.drools.core.common.CompositeDefaultAgenda;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.kie.api.definition.rule.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathMemory
extends AbstractBaseLinkedListNode<Memory>
implements Serializable,
Memory {
    protected static final Logger log = LoggerFactory.getLogger(PathMemory.class);
    protected static final boolean isLogTraceEnabled = log.isTraceEnabled();
    private long linkedSegmentMask;
    private long allLinkedMaskTest;
    private final PathEndNode pathEndNode;
    private RuleAgendaItem agendaItem;
    private SegmentMemory[] segmentMemories;
    private SegmentMemory segmentMemory;
    public final boolean dataDriven;

    public PathMemory(PathEndNode pathEndNode, InternalWorkingMemory wm) {
        this.pathEndNode = pathEndNode;
        this.linkedSegmentMask = 0L;
        this.dataDriven = this.initDataDriven(wm);
    }

    protected boolean initDataDriven(InternalWorkingMemory wm) {
        return this.isRuleDataDriven(wm, this.getRule());
    }

    protected boolean isRuleDataDriven(InternalWorkingMemory wm, RuleImpl rule) {
        return rule != null && (rule.isDataDriven() || wm != null && wm.getSessionConfiguration().getForceEagerActivationFilter().accept((Rule)rule));
    }

    public PathEndNode getPathEndNode() {
        return this.pathEndNode;
    }

    public RuleImpl getRule() {
        return this.pathEndNode instanceof TerminalNode ? ((TerminalNode)((Object)this.pathEndNode)).getRule() : null;
    }

    public RuleAgendaItem getRuleAgendaItem() {
        return this.agendaItem;
    }

    public long getLinkedSegmentMask() {
        return this.linkedSegmentMask;
    }

    public long getAllLinkedMaskTest() {
        return this.allLinkedMaskTest;
    }

    public void setAllLinkedMaskTest(long allLinkedTestMask) {
        this.allLinkedMaskTest = allLinkedTestMask;
    }

    public void linkNodeWithoutRuleNotify(long mask) {
        this.linkedSegmentMask |= mask;
    }

    public void linkSegment(long mask, InternalWorkingMemory wm) {
        this.linkedSegmentMask |= mask;
        if (isLogTraceEnabled) {
            if (NodeTypeEnums.isTerminalNode(this.getPathEndNode())) {
                TerminalNode rtn = (TerminalNode)((Object)this.getPathEndNode());
                log.trace("  LinkSegment smask={} rmask={} name={}", new Object[]{mask, this.linkedSegmentMask, rtn.getRule().getName()});
            } else {
                log.trace("  LinkSegment smask={} rmask={}", (Object)mask, (Object)"RiaNode");
            }
        }
        if (this.isRuleLinked()) {
            this.doLinkRule(wm);
        }
    }

    public RuleAgendaItem getOrCreateRuleAgendaItem(InternalAgenda agenda) {
        this.ensureAgendaItemCreated(agenda);
        return this.agendaItem;
    }

    private TerminalNode ensureAgendaItemCreated(InternalAgenda agenda) {
        TerminalNode rtn = (TerminalNode)((Object)this.getPathEndNode());
        if (this.agendaItem == null) {
            int salience = rtn.getRule().getSalience().isDynamic() ? 0 : rtn.getRule().getSalience().getValue();
            this.agendaItem = agenda.createRuleAgendaItem(salience, this, rtn);
        }
        return rtn;
    }

    public void doLinkRule(InternalWorkingMemory wm) {
        this.doLinkRule(this.getActualAgenda(wm));
    }

    public void doLinkRule(InternalAgenda agenda) {
        TerminalNode rtn = this.ensureAgendaItemCreated(agenda);
        if (isLogTraceEnabled) {
            log.trace(" LinkRule name={}", (Object)rtn.getRule().getName());
        }
        this.queueRuleAgendaItem(agenda);
    }

    public void doUnlinkRule(InternalWorkingMemory wm) {
        this.doUnlinkRule(this.getActualAgenda(wm));
    }

    public void doUnlinkRule(InternalAgenda agenda) {
        TerminalNode rtn = this.ensureAgendaItemCreated(agenda);
        if (isLogTraceEnabled) {
            log.trace("    UnlinkRule name={}", (Object)rtn.getRule().getName());
        }
        this.agendaItem.getRuleExecutor().setDirty(true);
        if (!this.agendaItem.isQueued()) {
            if (isLogTraceEnabled) {
                log.trace("Queue RuleAgendaItem {}", (Object)this.agendaItem);
            }
            InternalAgendaGroup ag = this.agendaItem.getAgendaGroup();
            ag.add(this.agendaItem);
        }
    }

    public void queueRuleAgendaItem(InternalAgenda agenda) {
        this.agendaItem.getRuleExecutor().setDirty(true);
        ActivationsFilter activationFilter = agenda.getActivationsFilter();
        if (activationFilter != null && !activationFilter.accept(this.agendaItem, agenda.getWorkingMemory(), this.agendaItem.getTerminalNode())) {
            return;
        }
        if (!this.agendaItem.isQueued()) {
            if (isLogTraceEnabled) {
                log.trace("Queue RuleAgendaItem {}", (Object)this.agendaItem);
            }
            InternalAgendaGroup ag = this.agendaItem.getAgendaGroup();
            ag.add(this.agendaItem);
        }
        if (this.agendaItem.getRule().isQuery()) {
            agenda.addQueryAgendaItem(this.agendaItem);
        } else if (this.agendaItem.getRule().isEager()) {
            agenda.addEagerRuleAgendaItem(this.agendaItem);
        }
    }

    public void unlinkedSegment(long mask, InternalWorkingMemory wm) {
        boolean linkedRule = this.isRuleLinked();
        this.linkedSegmentMask ^= mask;
        if (isLogTraceEnabled) {
            log.trace("  UnlinkSegment smask={} rmask={} name={}", new Object[]{mask, this.linkedSegmentMask, this});
        }
        if (linkedRule && !this.isRuleLinked()) {
            this.doUnlinkRule(wm);
        }
    }

    public boolean isRuleLinked() {
        return (this.linkedSegmentMask & this.allLinkedMaskTest) == this.allLinkedMaskTest;
    }

    public boolean isDataDriven() {
        return this.dataDriven;
    }

    @Override
    public short getNodeType() {
        return 101;
    }

    public boolean isInitialized() {
        return this.agendaItem != null && this.segmentMemories[0] != null;
    }

    public SegmentMemory[] getSegmentMemories() {
        return this.segmentMemories;
    }

    public void setSegmentMemory(int index, SegmentMemory sm) {
        this.segmentMemories[index] = sm;
    }

    public void setSegmentMemories(SegmentMemory[] segmentMemories) {
        this.segmentMemories = segmentMemories;
    }

    @Override
    public SegmentMemory getSegmentMemory() {
        return this.segmentMemory;
    }

    @Override
    public void setSegmentMemory(SegmentMemory sm) {
        this.segmentMemory = sm;
    }

    public String toString() {
        return "[RuleMem " + this.getRule().getName() + "]";
    }

    @Override
    public void reset() {
        this.linkedSegmentMask = 0L;
        this.agendaItem = null;
    }

    public InternalAgenda getActualAgenda(InternalWorkingMemory wm) {
        InternalAgenda agenda = wm.getAgenda();
        return agenda instanceof CompositeDefaultAgenda ? ((CompositeDefaultAgenda)agenda).getPartitionedAgendaForNode(this.getPathEndNode()) : agenda;
    }
}

