/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.core.beliefsystem.ModedAssertion;
import org.drools.core.beliefsystem.simple.SimpleMode;
import org.drools.core.common.ActivationGroupNode;
import org.drools.core.common.ActivationNode;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.LogicalDependency;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.GroupElement;
import org.drools.core.spi.Consequence;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.LinkedList;
import org.kie.api.runtime.rule.FactHandle;

public class RuleTerminalNodeLeftTuple<T extends ModedAssertion<T>>
extends BaseLeftTuple
implements AgendaItem<T> {
    private static final long serialVersionUID = 540L;
    private int salience;
    private long activationNumber;
    private int queueIndex;
    private boolean queued;
    private LinkedList<LogicalDependency<T>> justified;
    private LinkedList<LogicalDependency<SimpleMode>> blocked;
    private LinkedList<SimpleMode> blockers;
    private transient InternalAgendaGroup agendaGroup;
    private ActivationGroupNode activationGroupNode;
    private ActivationNode activationNode;
    private InternalFactHandle activationFactHandle;
    private transient boolean canceled;
    private boolean matched;
    private boolean active;
    private RuleAgendaItem ruleAgendaItem;
    private Runnable callback;

    public RuleTerminalNodeLeftTuple() {
    }

    public RuleTerminalNodeLeftTuple(InternalFactHandle factHandle, Sink sink, boolean leftTupleMemoryEnabled) {
        super(factHandle, sink, leftTupleMemoryEnabled);
    }

    public RuleTerminalNodeLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
        super(factHandle, leftTuple, sink);
    }

    public RuleTerminalNodeLeftTuple(LeftTuple leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        super(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    public RuleTerminalNodeLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink) {
        super(leftTuple, rightTuple, sink);
    }

    public RuleTerminalNodeLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink, boolean leftTupleMemoryEnabled) {
        this(leftTuple, rightTuple, null, null, sink, leftTupleMemoryEnabled);
    }

    public RuleTerminalNodeLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        super(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    public void init(long activationNumber, int salience, PropagationContext pctx, RuleAgendaItem ruleAgendaItem, InternalAgendaGroup agendaGroup) {
        this.setPropagationContext(pctx);
        this.salience = salience;
        this.activationNumber = activationNumber;
        this.queueIndex = -1;
        this.matched = true;
        this.ruleAgendaItem = ruleAgendaItem;
        this.agendaGroup = agendaGroup;
    }

    public void update(int salience, PropagationContext pctx) {
        this.setPropagationContext(pctx);
        this.salience = salience;
        this.matched = true;
    }

    @Override
    public RuleImpl getRule() {
        return this.getTerminalNode().getRule();
    }

    @Override
    public Consequence getConsequence() {
        String consequenceName = ((RuleTerminalNode)this.getTerminalNode()).getConsequenceName();
        return consequenceName.equals("default") ? this.getTerminalNode().getRule().getConsequence() : this.getTerminalNode().getRule().getNamedConsequence(consequenceName);
    }

    @Override
    public LeftTuple getTuple() {
        return this;
    }

    @Override
    public int getSalience() {
        return this.salience;
    }

    @Override
    public void setSalience(int salience) {
        this.salience = salience;
    }

    @Override
    public InternalFactHandle getActivationFactHandle() {
        return this.activationFactHandle;
    }

    @Override
    public void setActivationFactHandle(InternalFactHandle factHandle) {
        this.activationFactHandle = factHandle;
    }

    @Override
    public RuleAgendaItem getRuleAgendaItem() {
        return this.ruleAgendaItem;
    }

    @Override
    public long getActivationNumber() {
        return this.activationNumber;
    }

    @Override
    public void addBlocked(LogicalDependency<SimpleMode> dep) {
        if (this.blocked == null) {
            this.blocked = new LinkedList();
        }
        this.blocked.add(dep);
        RuleTerminalNodeLeftTuple blocked = (RuleTerminalNodeLeftTuple)dep.getJustified();
        if (blocked.blockers == null) {
            blocked.blockers = new LinkedList();
            blocked.blockers.add(dep.getMode());
        } else if (dep.getMode().getNext() == null && dep.getMode().getPrevious() == null && blocked.getBlockers().getFirst() != dep.getMode()) {
            blocked.blockers.add(dep.getMode());
        }
    }

    @Override
    public void removeAllBlockersAndBlocked(InternalAgenda agenda) {
        if (this.blockers != null) {
            for (SimpleMode node = this.blockers.getFirst(); node != null; node = (SimpleMode)node.getNext()) {
                LogicalDependency dep = (LogicalDependency)node.getObject();
                dep.getJustifier().getBlocked().remove(dep);
            }
        }
        this.blockers = null;
        if (this.blocked != null) {
            LogicalDependency dep = this.blocked.getFirst();
            while (dep != null) {
                LogicalDependency tmp = (LogicalDependency)dep.getNext();
                this.removeBlocked(dep);
                RuleTerminalNodeLeftTuple justified = (RuleTerminalNodeLeftTuple)dep.getJustified();
                if (justified.getBlockers().isEmpty() && justified.isActive()) {
                    agenda.stageLeftTuple(this.ruleAgendaItem, justified);
                }
                dep = tmp;
            }
        }
        this.blocked = null;
    }

    @Override
    public void removeBlocked(LogicalDependency<SimpleMode> dep) {
        this.blocked.remove(dep);
        RuleTerminalNodeLeftTuple blocked = (RuleTerminalNodeLeftTuple)dep.getJustified();
        blocked.blockers.remove(dep.getMode());
    }

    @Override
    public LinkedList<LogicalDependency<SimpleMode>> getBlocked() {
        return this.blocked;
    }

    @Override
    public void setBlocked(LinkedList<LogicalDependency<SimpleMode>> justified) {
        this.blocked = justified;
    }

    @Override
    public LinkedList<SimpleMode> getBlockers() {
        return this.blockers;
    }

    @Override
    public void addLogicalDependency(LogicalDependency<T> node) {
        if (this.justified == null) {
            this.justified = new LinkedList();
        }
        this.justified.add(node);
    }

    @Override
    public LinkedList<LogicalDependency<T>> getLogicalDependencies() {
        return this.justified;
    }

    @Override
    public void setLogicalDependencies(LinkedList<LogicalDependency<T>> justified) {
        this.justified = justified;
    }

    @Override
    public boolean isQueued() {
        return this.queued;
    }

    @Override
    public void setQueued(boolean queued) {
        this.queued = queued;
        if (queued) {
            this.setActive(true);
        }
    }

    @Override
    public void setQueueIndex(int queueIndex) {
        this.queueIndex = queueIndex;
    }

    @Override
    public void dequeue() {
        if (this.agendaGroup != null) {
            this.agendaGroup.remove(this);
        }
        this.setQueued(false);
    }

    @Override
    public int getQueueIndex() {
        return this.queueIndex;
    }

    @Override
    public void remove() {
        this.dequeue();
    }

    @Override
    public ActivationGroupNode getActivationGroupNode() {
        return this.activationGroupNode;
    }

    @Override
    public void setActivationGroupNode(ActivationGroupNode activationNode) {
        this.activationGroupNode = activationNode;
    }

    @Override
    public InternalAgendaGroup getAgendaGroup() {
        return this.agendaGroup;
    }

    @Override
    public ActivationNode getActivationNode() {
        return this.activationNode;
    }

    @Override
    public void setActivationNode(ActivationNode activationNode) {
        this.activationNode = activationNode;
    }

    @Override
    public GroupElement getSubRule() {
        return this.getTerminalNode().getSubRule();
    }

    @Override
    public TerminalNode getTerminalNode() {
        return (TerminalNode)this.getTupleSink();
    }

    @Override
    public List<FactHandle> getFactHandles() {
        return this.getFactHandles(this);
    }

    @Override
    public String toExternalForm() {
        return "[ " + this.getRule().getName() + " active=" + this.queued + " ]";
    }

    public List<Object> getObjects() {
        return this.getObjects(this);
    }

    @Override
    public List<Object> getObjectsDeep() {
        return this.getObjectsDeep(this);
    }

    public Object getDeclarationValue(String variableName) {
        Declaration decl = this.getTerminalNode().getSubRule().getOuterDeclarations().get(variableName);
        InternalFactHandle handle = this.get(decl);
        return decl.getValue(null, handle.getObject());
    }

    public List<String> getDeclarationIds() {
        Declaration[] declArray = ((RuleTerminalNode)this.getTupleSink()).getAllDeclarations();
        ArrayList<String> declarations = new ArrayList<String>();
        for (Declaration decl : declArray) {
            declarations.add(decl.getIdentifier());
        }
        return Collections.unmodifiableList(declarations);
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public boolean isMatched() {
        return this.matched;
    }

    @Override
    public void setMatched(boolean matched) {
        this.matched = matched;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isRuleAgendaItem() {
        return false;
    }

    @Override
    public Runnable getCallback() {
        return this.callback;
    }

    @Override
    public void setCallback(Runnable callback) {
        this.callback = callback;
    }

    @Override
    public String toString() {
        return "[" + this.toExternalForm() + " [ " + super.toString() + " ] ]";
    }
}

