/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.drools.core.base.accumulators.CollectSetAccumulateFunction;
import org.drools.model.DSL;
import org.drools.model.Drools;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Predicate1;
import org.drools.model.functions.accumulate.AccumulateFunction;
import org.drools.model.view.ExprViewItem;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsBiCondition;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsBiRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractAccumulateFunctionBridge;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractGroupByInvoker;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.common.FactTuple;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsQuadCondition;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsQuadRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsTriCondition;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsTriRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniCondition;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniRuleStructure;

public abstract class DroolsCondition<PatternVar, T extends DroolsRuleStructure<PatternVar>> {
    protected final T ruleStructure;

    protected DroolsCondition(T ruleStructure) {
        this.ruleStructure = ruleStructure;
    }

    protected abstract <InTuple> PatternDSL.PatternDef<PatternVar> bindTupleVariableOnFirstGrouping(PatternDSL.PatternDef<PatternVar> var1, Variable<InTuple> var2);

    protected <NewA, InTuple, OutTuple, __> DroolsUniCondition<NewA, NewA> collect(DroolsAbstractAccumulateFunctionBridge<__, InTuple, OutTuple> accumulateFunctionBridge) {
        Variable tupleVariable;
        PatternDSL.PatternDef mainAccumulatePattern = ((DroolsRuleStructure)this.ruleStructure).getPrimaryPatternBuilder().build();
        Variable baseVariable = ((DroolsRuleStructure)this.ruleStructure).getPrimaryPatternBuilder().getBaseVariable();
        boolean isRegrouping = FactTuple.class.isAssignableFrom(baseVariable.getType());
        if (isRegrouping) {
            tupleVariable = mainAccumulatePattern.getFirstVariable();
        } else {
            tupleVariable = ((DroolsRuleStructure)this.ruleStructure).createVariable("tuple");
            mainAccumulatePattern = this.bindTupleVariableOnFirstGrouping(mainAccumulatePattern, tupleVariable);
        }
        ViewItem<?> innerAccumulatePattern = this.getInnerAccumulatePattern(mainAccumulatePattern);
        Variable outputVariable = ((DroolsRuleStructure)this.ruleStructure).createVariable("collected");
        ExprViewItem outerAccumulatePattern = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)DSL.accFunction(() -> accumulateFunctionBridge, tupleVariable).as(outputVariable), (AccumulateFunction[])new AccumulateFunction[0]);
        DroolsUniRuleStructure newRuleStructure = ((DroolsRuleStructure)this.ruleStructure).recollect(outputVariable, (ViewItem<?>)outerAccumulatePattern);
        return new DroolsUniCondition(newRuleStructure);
    }

    protected <NewA> DroolsUniCondition<NewA, NewA> group(BiFunction<PatternDSL.PatternDef<PatternVar>, Variable<NewA>, PatternDSL.PatternDef<PatternVar>> bindFunction) {
        return (DroolsUniCondition)this.universalGroup(bindFunction, (var, pattern, accumulate) -> {
            DroolsUniRuleStructure newRuleStructure = ((DroolsRuleStructure)this.ruleStructure).regroup(var, pattern, (ViewItem<?>)accumulate);
            return new DroolsUniCondition(newRuleStructure);
        });
    }

    public <NewA, NewB> DroolsBiCondition<NewA, NewB, BiTuple<NewA, NewB>> groupBi(BiFunction<PatternDSL.PatternDef<PatternVar>, Variable<BiTuple<NewA, NewB>>, PatternDSL.PatternDef<PatternVar>> bindFunction) {
        return (DroolsBiCondition)this.universalGroup(bindFunction, (var, pattern, accumulate) -> {
            DroolsBiRuleStructure newRuleStructure = ((DroolsRuleStructure)this.ruleStructure).regroupBi(var, pattern, (ViewItem<?>)accumulate);
            return new DroolsBiCondition(newRuleStructure);
        });
    }

    private <InTuple, OutPatternVar, R extends DroolsRuleStructure<OutPatternVar>, C extends DroolsCondition<OutPatternVar, R>> C universalGroup(BiFunction<PatternDSL.PatternDef<PatternVar>, Variable<InTuple>, PatternDSL.PatternDef<PatternVar>> bindFunction, Mutator<InTuple, OutPatternVar, R, C> mutator) {
        Variable mappedVariable = ((DroolsRuleStructure)this.ruleStructure).createVariable("biMapped");
        PatternDSL.PatternDef mainAccumulatePattern = ((DroolsRuleStructure)this.ruleStructure).getPrimaryPatternBuilder().expand(p -> (PatternDSL.PatternDef)bindFunction.apply((PatternDSL.PatternDef)p, (Variable)mappedVariable)).build();
        ViewItem<?> innerAccumulatePattern = this.getInnerAccumulatePattern(mainAccumulatePattern);
        Variable<Collection> tupleCollection = ((DroolsRuleStructure)this.ruleStructure).createVariable(Collection.class, "tupleCollection");
        PatternDSL.PatternDef pattern = PatternDSL.pattern(tupleCollection).expr("Non-empty", (Predicate1 & Serializable)collection -> !collection.isEmpty(), PatternDSL.alphaIndexedBy(Integer.class, (Index.ConstraintType)Index.ConstraintType.GREATER_THAN, (int)-1, Collection::size, (Object)0));
        ExprViewItem accumulate = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)DSL.accFunction(CollectSetAccumulateFunction.class, mappedVariable).as(tupleCollection), (AccumulateFunction[])new AccumulateFunction[0]);
        return (C)((DroolsCondition)mutator.apply(tupleCollection, pattern, accumulate));
    }

    protected <NewA, NewB, InTuple, OutPatternVar> DroolsBiCondition<NewA, NewB, OutPatternVar> groupWithCollect(Supplier<? extends DroolsAbstractGroupByInvoker<InTuple>> invokerSupplier) {
        return (DroolsBiCondition)this.universalGroupWithCollect(invokerSupplier, (var, pattern, accumulate) -> {
            DroolsBiRuleStructure newRuleStructure = ((DroolsRuleStructure)this.ruleStructure).regroupBi(var, pattern, (ViewItem<?>)accumulate);
            return new DroolsBiCondition(newRuleStructure);
        });
    }

    protected <NewA, NewB, NewC, InTuple, OutPatternVar> DroolsTriCondition<NewA, NewB, NewC, OutPatternVar> groupBiWithCollect(Supplier<? extends DroolsAbstractGroupByInvoker<InTuple>> invokerSupplier) {
        return (DroolsTriCondition)this.universalGroupWithCollect(invokerSupplier, (var, pattern, accumulate) -> {
            DroolsTriRuleStructure newRuleStructure = ((DroolsRuleStructure)this.ruleStructure).regroupBiToTri(var, pattern, (ViewItem<?>)accumulate);
            return new DroolsTriCondition(newRuleStructure);
        });
    }

    protected <NewA, NewB, NewC, NewD, InTuple, OutPatternVar> DroolsQuadCondition<NewA, NewB, NewC, NewD, OutPatternVar> groupBiWithCollectBi(Supplier<? extends DroolsAbstractGroupByInvoker<InTuple>> invokerSupplier) {
        return (DroolsQuadCondition)this.universalGroupWithCollect(invokerSupplier, (var, pattern, accumulate) -> {
            DroolsQuadRuleStructure newRuleStructure = ((DroolsRuleStructure)this.ruleStructure).regroupBiToQuad(var, pattern, (ViewItem<?>)accumulate);
            return new DroolsQuadCondition(newRuleStructure);
        });
    }

    private <InTuple, OutPatternVar, R extends DroolsRuleStructure<OutPatternVar>, C extends DroolsCondition<OutPatternVar, R>> C universalGroupWithCollect(Supplier<? extends DroolsAbstractGroupByInvoker<InTuple>> invokerSupplier, Mutator<InTuple, OutPatternVar, R, C> mutator) {
        Variable<Collection> tupleCollection = ((DroolsRuleStructure)this.ruleStructure).createVariable(Collection.class, "tupleCollection");
        PatternDSL.PatternDef pattern = PatternDSL.pattern(tupleCollection).expr("Non-empty", (Predicate1 & Serializable)collection -> !collection.isEmpty(), PatternDSL.alphaIndexedBy(Integer.class, (Index.ConstraintType)Index.ConstraintType.GREATER_THAN, (int)-1, Collection::size, (Object)0));
        PatternDSL.PatternDef innerCollectingPattern = ((DroolsRuleStructure)this.ruleStructure).getPrimaryPatternBuilder().build();
        ViewItem<?> innerAccumulatePattern = this.getInnerAccumulatePattern(innerCollectingPattern);
        ExprViewItem accumulate = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)DSL.accFunction(invokerSupplier).as(tupleCollection), (AccumulateFunction[])new AccumulateFunction[0]);
        return (C)((DroolsCondition)mutator.apply(tupleCollection, pattern, accumulate));
    }

    protected <S extends Score<S>, H extends AbstractScoreHolder<S>> void impactScore(Drools drools, H scoreHolder) {
        RuleContext kcontext = (RuleContext)drools;
        scoreHolder.impactScore(kcontext);
    }

    protected <S extends Score<S>, H extends AbstractScoreHolder<S>> void impactScore(DroolsConstraint<?> constraint, Drools drools, H scoreHolder, int impact) {
        RuleContext kcontext = (RuleContext)drools;
        constraint.assertCorrectImpact(impact);
        scoreHolder.impactScore(kcontext, impact);
    }

    protected <S extends Score<S>, H extends AbstractScoreHolder<S>> void impactScore(DroolsConstraint<?> constraint, Drools drools, H scoreHolder, long impact) {
        RuleContext kcontext = (RuleContext)drools;
        constraint.assertCorrectImpact(impact);
        scoreHolder.impactScore(kcontext, impact);
    }

    protected <S extends Score<S>, H extends AbstractScoreHolder<S>> void impactScore(DroolsConstraint<?> constraint, Drools drools, H scoreHolder, BigDecimal impact) {
        RuleContext kcontext = (RuleContext)drools;
        constraint.assertCorrectImpact(impact);
        scoreHolder.impactScore(kcontext, impact);
    }

    protected ViewItem<?> getInnerAccumulatePattern(PatternDSL.PatternDef<PatternVar> mainAccumulatePattern) {
        Stream<PatternDSL.PatternDef<PatternVar>> primaryAndPrerequisites = Stream.concat(((DroolsRuleStructure)this.ruleStructure).getPrerequisites().stream(), Stream.of(mainAccumulatePattern));
        Stream<PatternDSL.PatternDef<PatternVar>> all = Stream.concat(primaryAndPrerequisites, ((DroolsRuleStructure)this.ruleStructure).getDependents().stream());
        ViewItem[] items = (ViewItem[])all.toArray(ViewItem[]::new);
        return PatternDSL.and((ViewItemBuilder)items[0], (ViewItemBuilder[])((ViewItemBuilder[])Arrays.copyOfRange(items, 1, items.length)));
    }

    public T getRuleStructure() {
        return this.ruleStructure;
    }

    public Class[] getExpectedJustificationTypes() {
        return ((DroolsRuleStructure)this.ruleStructure).getExpectedJustificationTypes();
    }

    public static final class ImmediatelyPreviousFilter<PredicateType> {
        public final T ruleStructure;
        public final PredicateType predicate;
        final /* synthetic */ DroolsCondition this$0;

        public ImmediatelyPreviousFilter(T ruleStructure, PredicateType predicate) {
            this.this$0 = this$0;
            this.ruleStructure = ruleStructure;
            this.predicate = predicate;
        }
    }

    @FunctionalInterface
    private static interface Mutator<InTuple, OutPatternVar, R extends DroolsRuleStructure<OutPatternVar>, C extends DroolsCondition<OutPatternVar, R>>
    extends TriFunction<Variable<Collection<InTuple>>, PatternDSL.PatternDef<Collection<InTuple>>, ViewItem<?>, C> {
    }
}

