/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.optional.score;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedCustomer;

public class VehicleRoutingConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory factory) {
        return new Constraint[]{this.vehicleCapacity(factory), this.distanceToPreviousStandstill(factory), this.distanceFromLastCustomerToDepot(factory), this.arrivalAfterDueTime(factory)};
    }

    protected Constraint vehicleCapacity(ConstraintFactory factory) {
        return factory.from(Customer.class).groupBy(Customer::getVehicle, ConstraintCollectors.sum(Customer::getDemand)).filter((vehicle, demand) -> demand > vehicle.getCapacity()).penalizeLong("vehicleCapacity", (Score)HardSoftLongScore.ONE_HARD, (vehicle, demand) -> demand - vehicle.getCapacity());
    }

    protected Constraint distanceToPreviousStandstill(ConstraintFactory factory) {
        return factory.from(Customer.class).penalizeLong("distanceToPreviousStandstill", (Score)HardSoftLongScore.ONE_SOFT, Customer::getDistanceFromPreviousStandstill);
    }

    protected Constraint distanceFromLastCustomerToDepot(ConstraintFactory factory) {
        return factory.from(Customer.class).filter(customer -> customer.getNextCustomer() == null).penalizeLong("distanceFromLastCustomerToDepot", (Score)HardSoftLongScore.ONE_SOFT, customer -> customer.getDistanceTo(customer.getVehicle()));
    }

    protected Constraint arrivalAfterDueTime(ConstraintFactory factory) {
        return factory.from(TimeWindowedCustomer.class).filter(customer -> customer.getArrivalTime() > customer.getDueTime()).penalizeLong("arrivalAfterDueTime", (Score)HardSoftLongScore.ONE_HARD, customer -> customer.getArrivalTime() - customer.getDueTime());
    }
}

