/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.config.ProblemBenchmarksConfig;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.core.config.AbstractConfig;
import org.optaplanner.core.config.SolverConfigContext;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;

@XStreamAlias(value="solverBenchmark")
public class SolverBenchmarkConfig<Solution_>
extends AbstractConfig<SolverBenchmarkConfig> {
    private String name = null;
    @XStreamAlias(value="solver")
    private SolverConfig solverConfig = null;
    @XStreamAlias(value="problemBenchmarks")
    private ProblemBenchmarksConfig problemBenchmarksConfig = null;
    private Integer subSingleCount = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SolverConfig getSolverConfig() {
        return this.solverConfig;
    }

    public void setSolverConfig(SolverConfig solverConfig) {
        this.solverConfig = solverConfig;
    }

    public ProblemBenchmarksConfig getProblemBenchmarksConfig() {
        return this.problemBenchmarksConfig;
    }

    public void setProblemBenchmarksConfig(ProblemBenchmarksConfig problemBenchmarksConfig) {
        this.problemBenchmarksConfig = problemBenchmarksConfig;
    }

    public Integer getSubSingleCount() {
        return this.subSingleCount;
    }

    public void setSubSingleCount(Integer subSingleCount) {
        this.subSingleCount = subSingleCount;
    }

    public void buildSolverBenchmark(SolverConfigContext solverConfigContext, ClassLoader classLoader, PlannerBenchmarkResult plannerBenchmark, Solution_[] extraProblems) {
        this.validate();
        SolverBenchmarkResult solverBenchmarkResult = new SolverBenchmarkResult(plannerBenchmark);
        solverBenchmarkResult.setName(this.name);
        solverBenchmarkResult.setSubSingleCount((Integer)ConfigUtils.inheritOverwritableProperty((Object)this.subSingleCount, (Object)1));
        if (this.solverConfig.getClassLoader() == null) {
            this.solverConfig.setClassLoader(classLoader);
        }
        solverBenchmarkResult.setSolverConfig(this.solverConfig);
        SolutionDescriptor solutionDescriptor = this.solverConfig.buildSolutionDescriptor(solverConfigContext);
        for (Solution_ extraProblem : extraProblems) {
            if (solutionDescriptor.getSolutionClass().isInstance(extraProblem)) continue;
            throw new IllegalArgumentException("The solverBenchmark name (" + this.name + ") for solution class (" + solutionDescriptor.getSolutionClass() + ") cannot solve a problem (" + extraProblem + ") of class (" + (extraProblem == null ? null : extraProblem.getClass()) + ").");
        }
        solverBenchmarkResult.setScoreDefinition(solutionDescriptor.getScoreDefinition());
        solverBenchmarkResult.setSingleBenchmarkResultList(new ArrayList<SingleBenchmarkResult>());
        ProblemBenchmarksConfig problemBenchmarksConfig_ = this.problemBenchmarksConfig == null ? new ProblemBenchmarksConfig() : this.problemBenchmarksConfig;
        plannerBenchmark.getSolverBenchmarkResultList().add(solverBenchmarkResult);
        problemBenchmarksConfig_.buildProblemBenchmarkList(solverConfigContext, solverBenchmarkResult, extraProblems);
    }

    protected void validate() {
        if (!PlannerBenchmarkConfig.VALID_NAME_PATTERN.matcher(this.name).matches()) {
            throw new IllegalStateException("The solverBenchmark name (" + this.name + ") is invalid because it does not follow the nameRegex (" + PlannerBenchmarkConfig.VALID_NAME_PATTERN.pattern() + ") which might cause an illegal filename.");
        }
        if (!this.name.trim().equals(this.name)) {
            throw new IllegalStateException("The solverBenchmark name (" + this.name + ") is invalid because it starts or ends with whitespace.");
        }
        if (this.subSingleCount != null && this.subSingleCount < 1) {
            throw new IllegalStateException("The solverBenchmark name (" + this.name + ") is invalid because the subSingleCount (" + this.subSingleCount + ") must be greater than 1.");
        }
    }

    public SolverBenchmarkConfig inherit(SolverBenchmarkConfig inheritedConfig) {
        this.solverConfig = (SolverConfig)ConfigUtils.inheritConfig((AbstractConfig)this.solverConfig, (AbstractConfig)inheritedConfig.getSolverConfig());
        this.problemBenchmarksConfig = (ProblemBenchmarksConfig)ConfigUtils.inheritConfig((AbstractConfig)this.problemBenchmarksConfig, (AbstractConfig)inheritedConfig.getProblemBenchmarksConfig());
        this.subSingleCount = (Integer)ConfigUtils.inheritOverwritableProperty((Object)this.subSingleCount, (Object)inheritedConfig.getSubSingleCount());
        return this;
    }

    public SolverBenchmarkConfig copyConfig() {
        return new SolverBenchmarkConfig<Solution_>().inherit(this);
    }
}

