/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.springframework.hateoas.StringLinkRelation;
import org.springframework.util.Assert;

public interface LinkRelation {
    @JsonValue
    public String value();

    @JsonCreator
    public static LinkRelation of(String relation) {
        return StringLinkRelation.of(relation);
    }

    public static Iterable<LinkRelation> manyOf(String ... others) {
        return Arrays.stream(others).map(LinkRelation::of).collect(Collectors.toList());
    }

    default public boolean isSameAs(LinkRelation relation) {
        Assert.notNull((Object)relation, (String)"LinkRelation must not be null!");
        return this.value().equalsIgnoreCase(relation.value());
    }
}

