/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.fastzipfilereader;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import nonapi.io.github.classgraph.fastzipfilereader.LogicalZipFile;
import nonapi.io.github.classgraph.fastzipfilereader.NestedJarHandler;
import nonapi.io.github.classgraph.fastzipfilereader.RecyclableInflater;
import nonapi.io.github.classgraph.fastzipfilereader.ZipFileSliceReader;
import nonapi.io.github.classgraph.recycler.RecycleOnClose;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.VersionFinder;

public class FastZipEntry
implements Comparable<FastZipEntry> {
    final LogicalZipFile parentLogicalZipFile;
    private final long locHeaderPos;
    private long entryDataStartOffsetWithinPhysicalZipFile = -1L;
    public final String entryName;
    final boolean isDeflated;
    public final long compressedSize;
    public final long uncompressedSize;
    public final long lastModified;
    public final Set<PosixFilePermission> posixFilePermissions;
    final int version;
    public final String entryNameUnversioned;
    private final NestedJarHandler nestedJarHandler;
    private RecyclableInflater recyclableInflaterInstance;

    FastZipEntry(LogicalZipFile parentLogicalZipFile, long locHeaderPos, String entryName, boolean isDeflated, long compressedSize, long uncompressedSize, NestedJarHandler nestedJarHandler, long lastModified, Set<PosixFilePermission> posixFilePermissions) {
        int nextSlashIdx;
        this.parentLogicalZipFile = parentLogicalZipFile;
        this.locHeaderPos = locHeaderPos;
        this.entryName = entryName;
        this.isDeflated = isDeflated;
        this.compressedSize = compressedSize;
        this.uncompressedSize = !isDeflated && uncompressedSize < 0L ? compressedSize : uncompressedSize;
        this.nestedJarHandler = nestedJarHandler;
        this.lastModified = lastModified;
        this.posixFilePermissions = posixFilePermissions;
        int entryVersion = 8;
        String entryNameWithoutVersionPrefix = entryName;
        if (entryName.startsWith("META-INF/versions/") && entryName.length() > "META-INF/versions/".length() + 1 && (nextSlashIdx = entryName.indexOf(47, "META-INF/versions/".length())) > 0) {
            String versionStr = entryName.substring("META-INF/versions/".length(), nextSlashIdx);
            int versionInt = 0;
            if (versionStr.length() < 6 && !versionStr.isEmpty()) {
                for (int i = 0; i < versionStr.length(); ++i) {
                    char c = versionStr.charAt(i);
                    if (c < '0' || c > '9') {
                        versionInt = 0;
                        break;
                    }
                    versionInt = versionInt == 0 ? c - 48 : versionInt * 10 + c - 48;
                }
            }
            if (versionInt != 0) {
                entryVersion = versionInt;
            }
            if (entryVersion < 9 || entryVersion > VersionFinder.JAVA_MAJOR_VERSION) {
                entryVersion = 8;
            }
            if (entryVersion > 8 && (entryNameWithoutVersionPrefix = entryName.substring(nextSlashIdx + 1)).startsWith("META-INF/")) {
                entryVersion = 8;
                entryNameWithoutVersionPrefix = entryName;
            }
        }
        this.version = entryVersion;
        this.entryNameUnversioned = entryNameWithoutVersionPrefix;
    }

    long getEntryDataStartOffsetWithinPhysicalZipFile() throws IOException, InterruptedException {
        if (this.entryDataStartOffsetWithinPhysicalZipFile == -1L) {
            try (RecycleOnClose zipFileSliceReaderRecycleOnClose = this.parentLogicalZipFile.zipFileSliceReaderRecycler.acquireRecycleOnClose();){
                ZipFileSliceReader headerReader = (ZipFileSliceReader)zipFileSliceReaderRecycleOnClose.get();
                if (headerReader.getInt(this.locHeaderPos) != 67324752) {
                    throw new IOException("Zip entry has bad LOC header: " + this.entryName);
                }
                long dataStartPos = this.locHeaderPos + 30L + (long)headerReader.getShort(this.locHeaderPos + 26L) + (long)headerReader.getShort(this.locHeaderPos + 28L);
                if (dataStartPos > this.parentLogicalZipFile.len) {
                    throw new IOException("Unexpected EOF when trying to read zip entry data: " + this.entryName);
                }
                this.entryDataStartOffsetWithinPhysicalZipFile = this.parentLogicalZipFile.startOffsetWithinPhysicalZipFile + dataStartPos;
            }
        }
        return this.entryDataStartOffsetWithinPhysicalZipFile;
    }

    public boolean canGetAsSlice() throws IOException, InterruptedException {
        long dataStartOffsetWithinPhysicalZipFile = this.getEntryDataStartOffsetWithinPhysicalZipFile();
        return !this.isDeflated && dataStartOffsetWithinPhysicalZipFile / 0x7FFFFFF7L == (dataStartOffsetWithinPhysicalZipFile + this.uncompressedSize) / 0x7FFFFFF7L;
    }

    public ByteBuffer getAsSlice() throws IOException, InterruptedException {
        if (!this.canGetAsSlice()) {
            throw new IllegalArgumentException("Cannot open zip entry as a slice");
        }
        long dataStartOffsetWithinPhysicalZipFile = this.getEntryDataStartOffsetWithinPhysicalZipFile();
        int chunkIdx = (int)(dataStartOffsetWithinPhysicalZipFile / 0x7FFFFFF7L);
        long chunkStart = (long)chunkIdx * 0x7FFFFFF7L;
        ByteBuffer dupdBuf = this.parentLogicalZipFile.physicalZipFile.getByteBuffer(chunkIdx).duplicate();
        ((Buffer)dupdBuf).position((int)(dataStartOffsetWithinPhysicalZipFile - chunkStart));
        ((Buffer)dupdBuf).limit((int)(dataStartOffsetWithinPhysicalZipFile + this.uncompressedSize - chunkStart));
        return dupdBuf.slice();
    }

    public InputStream open() throws IOException, InterruptedException {
        if (this.recyclableInflaterInstance != null) {
            throw new IOException("Zip entry already open");
        }
        if (this.isDeflated) {
            this.recyclableInflaterInstance = this.nestedJarHandler.inflaterRecycler.acquire();
        }
        return new InputStream(){
            private final long dataStartOffsetWithinPhysicalZipFile;
            private final byte[] scratch;
            private ByteBuffer currChunkByteBuf;
            private boolean isLastChunk;
            private int currChunkIdx;
            private boolean eof;
            private final Inflater inflater;
            private final AtomicBoolean closed;
            private static final int INFLATE_BUF_SIZE = 1024;
            {
                this.dataStartOffsetWithinPhysicalZipFile = FastZipEntry.this.getEntryDataStartOffsetWithinPhysicalZipFile();
                this.scratch = new byte[8192];
                this.inflater = FastZipEntry.this.isDeflated ? FastZipEntry.this.recyclableInflaterInstance.getInflater() : null;
                this.closed = new AtomicBoolean(false);
                this.currChunkIdx = (int)(this.dataStartOffsetWithinPhysicalZipFile / 0x7FFFFFF7L);
                this.currChunkByteBuf = FastZipEntry.this.parentLogicalZipFile.physicalZipFile.getByteBuffer(this.currChunkIdx).duplicate();
                int chunkPos = (int)(this.dataStartOffsetWithinPhysicalZipFile - (long)this.currChunkIdx * 0x7FFFFFF7L);
                ((Buffer)this.currChunkByteBuf).position(chunkPos);
                long endPos = (long)chunkPos + FastZipEntry.this.compressedSize;
                ((Buffer)this.currChunkByteBuf).limit((int)Math.min(0x7FFFFFF7L, endPos));
                this.isLastChunk = endPos <= 0x7FFFFFF7L;
            }

            private boolean readNextChunk() throws IOException, InterruptedException {
                ++this.currChunkIdx;
                if (this.currChunkIdx >= FastZipEntry.this.parentLogicalZipFile.physicalZipFile.numMappedByteBuffers) {
                    return false;
                }
                long chunkStartOff = (long)this.currChunkIdx * 0x7FFFFFF7L;
                long priorBytes = chunkStartOff - this.dataStartOffsetWithinPhysicalZipFile;
                long remainingBytes = FastZipEntry.this.compressedSize - priorBytes;
                if (remainingBytes <= 0L) {
                    return false;
                }
                this.currChunkByteBuf = FastZipEntry.this.parentLogicalZipFile.physicalZipFile.getByteBuffer(this.currChunkIdx).duplicate();
                ((Buffer)this.currChunkByteBuf).position(0);
                ((Buffer)this.currChunkByteBuf).limit((int)Math.min(0x7FFFFFF7L, remainingBytes));
                this.isLastChunk = remainingBytes <= 0x7FFFFFF7L;
                return true;
            }

            private int readDeflated(byte[] buf, int off, int len) throws IOException, InterruptedException {
                try {
                    int numInflatedBytes;
                    byte[] inflateBuf = new byte[1024];
                    while ((numInflatedBytes = this.inflater.inflate(buf, off, len)) == 0) {
                        if (this.inflater.finished() || this.inflater.needsDictionary()) {
                            this.eof = true;
                            return -1;
                        }
                        if (!this.inflater.needsInput()) continue;
                        if (!(this.currChunkByteBuf.hasRemaining() || this.readNextChunk() && this.currChunkByteBuf.hasRemaining())) {
                            throw new IOException("Unexpected EOF in deflated data");
                        }
                        try {
                            int remaining = this.currChunkByteBuf.remaining();
                            if (this.isLastChunk && remaining < inflateBuf.length) {
                                this.currChunkByteBuf.get(inflateBuf, 0, remaining);
                                inflateBuf[remaining] = 0;
                                this.inflater.setInput(inflateBuf, 0, remaining + 1);
                                continue;
                            }
                            if (this.isLastChunk && remaining == inflateBuf.length) {
                                this.currChunkByteBuf.get(inflateBuf, 0, remaining - 1);
                                this.inflater.setInput(inflateBuf, 0, remaining - 1);
                                continue;
                            }
                            int bytesToRead = Math.min(inflateBuf.length, remaining);
                            this.currChunkByteBuf.get(inflateBuf, 0, bytesToRead);
                            this.inflater.setInput(inflateBuf, 0, bytesToRead);
                        }
                        catch (BufferUnderflowException e) {
                            throw new IOException("Unexpected EOF in deflated data");
                        }
                    }
                    return numInflatedBytes;
                }
                catch (DataFormatException e) {
                    throw new ZipException(e.getMessage() != null ? e.getMessage() : "Invalid deflated zip entry data");
                }
            }

            private int readStored(byte[] buf, int off, int len) throws IOException, InterruptedException {
                int read;
                int numBytesRead;
                for (read = 0; read < len; read += numBytesRead) {
                    if (!this.currChunkByteBuf.hasRemaining() && !this.readNextChunk()) {
                        return read == 0 ? -1 : read;
                    }
                    int remainingToRead = len - read;
                    int remainingInBuf = this.currChunkByteBuf.remaining();
                    numBytesRead = Math.min(remainingToRead, remainingInBuf);
                    try {
                        this.currChunkByteBuf.get(buf, off + read, numBytesRead);
                        continue;
                    }
                    catch (BufferUnderflowException e) {
                        throw new EOFException("Unexpected EOF in stored (non-deflated) zip entry data");
                    }
                }
                return read;
            }

            @Override
            public int read(byte[] buf, int off, int len) throws IOException {
                if (this.closed.get()) {
                    throw new IOException("Stream closed");
                }
                if (buf == null) {
                    throw new NullPointerException();
                }
                if (off < 0 || len < 0 || len > buf.length - off) {
                    throw new IndexOutOfBoundsException();
                }
                if (len == 0) {
                    return 0;
                }
                if (FastZipEntry.this.parentLogicalZipFile.physicalZipFile.fileLen == 0L) {
                    return -1;
                }
                try {
                    if (FastZipEntry.this.isDeflated) {
                        return this.readDeflated(buf, off, len);
                    }
                    return this.readStored(buf, off, len);
                }
                catch (InterruptedException e) {
                    ((FastZipEntry)FastZipEntry.this).nestedJarHandler.interruptionChecker.interrupt();
                    throw new IOException("Thread was interrupted");
                }
            }

            @Override
            public int read() throws IOException {
                if (this.closed.get()) {
                    throw new IOException("Stream closed");
                }
                return this.read(this.scratch, 0, 1) == -1 ? -1 : this.scratch[0] & 0xFF;
            }

            @Override
            public int available() throws IOException {
                if (this.closed.get()) {
                    throw new IOException("Stream closed");
                }
                if (this.inflater.finished()) {
                    this.eof = true;
                }
                return this.eof ? 0 : 1;
            }

            @Override
            public long skip(long n) throws IOException {
                long total;
                int numSkipped;
                if (this.closed.get()) {
                    throw new IOException("Stream closed");
                }
                if (n < 0L) {
                    throw new IllegalArgumentException("Invalid skip value");
                }
                for (total = 0L; total < n; total += (long)numSkipped) {
                    numSkipped = this.read(this.scratch, 0, (int)Math.min(n - total, (long)this.scratch.length));
                    if (numSkipped != -1) continue;
                    this.eof = true;
                    break;
                }
                return total;
            }

            @Override
            public boolean markSupported() {
                return false;
            }

            @Override
            public synchronized void mark(int readlimit) {
                throw new IllegalArgumentException("Not supported");
            }

            @Override
            public synchronized void reset() throws IOException {
                throw new IllegalArgumentException("Not supported");
            }

            @Override
            public void close() throws IOException {
                if (!this.closed.getAndSet(true)) {
                    this.currChunkByteBuf = null;
                    if (FastZipEntry.this.recyclableInflaterInstance != null) {
                        ((FastZipEntry)FastZipEntry.this).nestedJarHandler.inflaterRecycler.recycle(FastZipEntry.this.recyclableInflaterInstance);
                        FastZipEntry.this.recyclableInflaterInstance = null;
                    }
                }
            }
        };
    }

    public byte[] load() throws IOException, InterruptedException {
        try (InputStream is = this.open();){
            byte[] byArray = FileUtils.readAllBytesAsArray(is, this.uncompressedSize);
            return byArray;
        }
    }

    public String loadAsString() throws IOException, InterruptedException {
        try (InputStream is = this.open();){
            String string = FileUtils.readAllBytesAsString(is, this.uncompressedSize);
            return string;
        }
    }

    public String getPath() {
        return this.parentLogicalZipFile.getPath() + "!/" + this.entryName;
    }

    public String toString() {
        return "jar:file:" + this.getPath();
    }

    @Override
    public int compareTo(FastZipEntry o) {
        int diff0 = o.version - this.version;
        if (diff0 != 0) {
            return diff0;
        }
        int diff1 = this.entryNameUnversioned.compareTo(o.entryNameUnversioned);
        if (diff1 != 0) {
            return diff1;
        }
        int diff2 = this.entryName.compareTo(o.entryName);
        if (diff2 != 0) {
            return diff2;
        }
        long diff3 = this.locHeaderPos - o.locHeaderPos;
        return diff3 < 0L ? -1 : (diff3 > 0L ? 1 : 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FastZipEntry)) {
            return false;
        }
        FastZipEntry other = (FastZipEntry)obj;
        return this.parentLogicalZipFile.equals(other.parentLogicalZipFile) && this.compareTo(other) == 0;
    }

    public int hashCode() {
        return this.parentLogicalZipFile.hashCode() ^ this.version ^ this.entryName.hashCode() ^ (int)this.locHeaderPos;
    }
}

