/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.List;
import java.util.function.Supplier;
import lombok.NonNull;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.rest.webmvc.HttpHeadersPreparer;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.support.ETag;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

class ResourceStatus {
    private static final String INVALID_DOMAIN_OBJECT = "Domain object %s is not an instance of the given PersistentEntity of type %s!";
    @NonNull
    private final HttpHeadersPreparer preparer;

    public StatusAndHeaders getStatusAndHeaders(HttpHeaders requestHeaders, Object domainObject, PersistentEntity<?, ?> entity) {
        Assert.notNull((Object)requestHeaders, (String)"Request headers must not be null!");
        Assert.notNull((Object)domainObject, (String)"Domain object must not be null!");
        Assert.notNull(entity, (String)"PersistentEntity must not be null!");
        Assert.isTrue((boolean)entity.getType().isInstance(domainObject), () -> String.format(INVALID_DOMAIN_OBJECT, domainObject, entity.getType()));
        List ifNoneMatch = requestHeaders.getIfNoneMatch();
        ETag eTag = ifNoneMatch.isEmpty() ? ETag.NO_ETAG : ETag.from((String)ifNoneMatch.get(0));
        HttpHeaders responseHeaders = this.preparer.prepareHeaders(entity, domainObject);
        return eTag.matches(entity, domainObject) || this.preparer.isObjectStillValid(domainObject, requestHeaders) ? StatusAndHeaders.notModified(responseHeaders) : StatusAndHeaders.modified(responseHeaders);
    }

    private ResourceStatus(@NonNull HttpHeadersPreparer preparer) {
        if (preparer == null) {
            throw new IllegalArgumentException("preparer is marked non-null but is null");
        }
        this.preparer = preparer;
    }

    public static ResourceStatus of(@NonNull HttpHeadersPreparer preparer) {
        return new ResourceStatus(preparer);
    }

    public static class StatusAndHeaders {
        @NonNull
        private final HttpHeaders headers;
        private final boolean modified;

        private static StatusAndHeaders notModified(HttpHeaders headers) {
            return new StatusAndHeaders(headers, false);
        }

        private static StatusAndHeaders modified(HttpHeaders headers) {
            return new StatusAndHeaders(headers, true);
        }

        public ResponseEntity<EntityModel<?>> toResponseEntity(Supplier<PersistentEntityResource> supplier) {
            return this.modified ? new ResponseEntity((Object)supplier.get(), (MultiValueMap)this.headers, HttpStatus.OK) : new ResponseEntity((MultiValueMap)this.headers, HttpStatus.NOT_MODIFIED);
        }

        private StatusAndHeaders(@NonNull HttpHeaders headers, boolean modified) {
            if (headers == null) {
                throw new IllegalArgumentException("headers is marked non-null but is null");
            }
            this.headers = headers;
            this.modified = modified;
        }

        boolean isModified() {
            return this.modified;
        }
    }
}

